/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MessageProcessorSerializer;
import org.apache.synapse.message.processors.MessageProcessor;
import org.wso2.carbon.mediation.initializer.persistence.AbstractStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.MessageProcessorRegistryStore;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class MessageProcessorStore
extends AbstractStore<MessageProcessor> {
    public MessageProcessorStore(String configPath, UserRegistry registry, String configName) {
        super(configPath);
        if (registry != null) {
            this.registryStore = new MessageProcessorRegistryStore(registry, configName);
        }
    }

    @Override
    protected OMElement saveToFile(MessageProcessor processor, SynapseConfiguration synapseConfig) {
        try {
            return this.serializer.serializeMessageProcessor(processor, synapseConfig, null);
        }
        catch (Exception e) {
            this.handleException("Error while saving the Message Processr: " + processor.getName() + " to " + "the file system", e);
            return null;
        }
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration config) {
        File mpDir = new File(this.configPath, "message-processors");
        if (!mpDir.exists()) {
            return;
        }
        File mpFile = new File(mpDir, fileName);
        config.getArtifactDeploymentStore().addBackedUpArtifact(mpFile.getAbsolutePath());
        mpFile.delete();
    }

    @Override
    protected MessageProcessor getObjectToPersist(String name, SynapseConfiguration config) {
        return (MessageProcessor)config.getMessageProcessors().get(name);
    }

    @Override
    protected String getFileName(MessageProcessor processor) {
        return processor.getFileName();
    }

    @Override
    protected OMElement serialize(MessageProcessor obj) {
        return MessageProcessorSerializer.serializeMessageProcessor(null, (MessageProcessor)obj);
    }
}

