/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.multitenancy;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.XMLToObjectMapper;
import org.apache.synapse.config.xml.IEntryFactory;

public class StratosEntryFactory
implements IEntryFactory,
XMLToObjectMapper {
    private static Log log = LogFactory.getLog(StratosEntryFactory.class);
    private static final QName DESCRIPTION_Q = new QName("http://ws.apache.org/ns/synapse", "description");

    public Entry createEntry(OMElement elem) {
        Entry entry;
        block9: {
            String src;
            OMAttribute key = elem.getAttribute(new QName("", "key"));
            entry = new Entry(key.getAttributeValue());
            OMElement descriptionElem = elem.getFirstChildWithName(DESCRIPTION_Q);
            if (descriptionElem != null) {
                entry.setDescription(descriptionElem.getText());
                descriptionElem.detach();
            }
            if ((src = elem.getAttributeValue(new QName("", "src"))) != null) {
                try {
                    URL url = new URL(src.trim());
                    if (!"file".equals(url.getProtocol())) {
                        entry.setSrc(url);
                        entry.setType(2);
                        entry.setValue(SynapseConfigUtils.getObject((URL)entry.getSrc(), (Properties)new Properties()));
                        break block9;
                    }
                    StratosEntryFactory.handleException("Cannot create LocalEntry. Read blocked for local file system with path : " + url.getPath());
                }
                catch (MalformedURLException e) {
                    StratosEntryFactory.handleException("The entry with key : " + key + " refers to an invalid URL");
                }
            } else {
                OMNode nodeValue = elem.getFirstOMChild();
                OMElement elemValue = elem.getFirstElement();
                if (elemValue != null) {
                    entry.setType(1);
                    entry.setValue((Object)elemValue);
                } else if (nodeValue != null && nodeValue instanceof OMText) {
                    entry.setType(0);
                    entry.setValue((Object)elem.getText());
                }
            }
        }
        return entry;
    }

    public Object getObjectFromOMNode(OMNode om, Properties properties) {
        if (om instanceof OMElement) {
            return this.createEntry((OMElement)om);
        }
        StratosEntryFactory.handleException("Invalid XML configuration for an Entry. OMElement expected");
        return null;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

