/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Axis2SynapseController;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.config.xml.MultiXMLConfigurationSerializer;
import org.apache.synapse.core.axis2.MessageContextCreatorForAxis2;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.deployers.ExtensionDeployer;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.mediation.initializer.RegistryBasedSynapseConfigBuilder;
import org.wso2.carbon.mediation.initializer.RegistryBasedSynapseConfigSerializer;
import org.wso2.carbon.mediation.initializer.ServiceBusInitializer;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class CarbonSynapseController
extends Axis2SynapseController {
    private static final Log log = LogFactory.getLog(CarbonSynapseController.class);
    private String currentConfigurationName;
    private String synapseXMLLocation;

    public void init(ServerConfigurationInformation serverConfigurationInformation, ServerContextInformation serverContextInformation) {
        Object context = serverContextInformation.getServerContext();
        if (context instanceof ConfigurationContext) {
            AxisConfiguration axisCfg = ((ConfigurationContext)context).getAxisConfiguration();
            DeploymentEngine deploymentEngine = (DeploymentEngine)axisCfg.getConfigurator();
            String carbonRepoPath = axisCfg.getRepository().getPath();
            String mediatorsPath = carbonRepoPath + File.separator + "mediators";
            String extensionsPath = carbonRepoPath + File.separator + "extensions";
            ExtensionDeployer deployer = new ExtensionDeployer();
            deploymentEngine.addDeployer((Deployer)deployer, mediatorsPath, "xar");
            deploymentEngine.addDeployer((Deployer)deployer, extensionsPath, "xar");
            deploymentEngine.addDeployer((Deployer)deployer, mediatorsPath, "jar");
            deploymentEngine.addDeployer((Deployer)deployer, extensionsPath, "jar");
            this.currentConfigurationName = ((ConfigurationContext)context).getAxisConfiguration().getParameterValue("SYNAPSE_CURRENT_CONFIGURATION").toString();
            this.synapseXMLLocation = serverConfigurationInformation.getSynapseXMLLocation();
        }
        super.init(serverConfigurationInformation, serverContextInformation);
    }

    public void start() {
        if (this.getContext() != null) {
            List inflowPhases = ((ConfigurationContext)this.getContext()).getAxisConfiguration().getInFlowPhases();
            for (Phase inPhase : inflowPhases) {
                if (!"Dispatch".equals(inPhase.getPhaseName())) continue;
                for (Handler handler : inPhase.getHandlers()) {
                    if (!"MultitenantDispatcher".equals(handler.getName())) continue;
                    return;
                }
                super.start();
            }
        } else {
            this.handleFatal("Couldn't start Synapse, ConfigurationContext not found");
        }
    }

    public SynapseConfiguration createSynapseConfiguration() {
        SynapseConfiguration synapseConfig = null;
        boolean loadFromRegistry = "true".equals(this.getParameter("MediationConfig.LoadFromRegistry"));
        UserRegistry registry = this.getRegistry();
        Properties properties = SynapsePropertiesLoader.loadSynapseProperties();
        if (this.serverConfigurationInformation.getResolveRoot() != null) {
            properties.put("resolve.root", this.serverConfigurationInformation.getResolveRoot());
        }
        if (this.serverConfigurationInformation.getSynapseHome() != null) {
            properties.put("synapse.home", this.serverConfigurationInformation.getSynapseHome());
        }
        if (loadFromRegistry) {
            try {
                this.synapseConfiguration = synapseConfig = this.loadFromRegistry(registry, properties);
            }
            catch (Exception e) {
                log.error((Object)"Error while loading the mediation configuration from the registry", (Throwable)e);
                synapseConfig = null;
            }
        }
        if (synapseConfig == null) {
            log.info((Object)"Loading the mediation configuration from the file system");
            synapseConfig = super.createSynapseConfiguration();
            this.saveToRegistry(registry, synapseConfig);
        } else if ("true".equals(this.getParameter("MediationConfig.SaveToFile"))) {
            this.saveToFileSystem(synapseConfig);
        }
        return synapseConfig;
    }

    public void destroySynapseEnvironment() {
        AxisConfiguration axisConfiguration = this.synapseConfiguration.getAxisConfiguration();
        for (ProxyService proxy : this.synapseConfiguration.getProxyServices()) {
            try {
                axisConfiguration.getService(proxy.getName()).addParameter("keepServiceHistory", (Object)"true");
            }
            catch (AxisFault axisFault) {
                log.error((Object)("Error while accesing the Proxy Service " + proxy.getName() + ". Service configuration history might get lost"), (Throwable)axisFault);
            }
        }
        super.destroySynapseEnvironment();
    }

    private void saveToFileSystem(SynapseConfiguration synapseConfig) {
        log.info((Object)"Saving the mediation configuration to the file system");
        String confPath = synapseConfig.getPathToConfigFile();
        MultiXMLConfigurationSerializer serializer = new MultiXMLConfigurationSerializer(confPath);
        serializer.serialize(synapseConfig);
    }

    private void saveToRegistry(UserRegistry registry, SynapseConfiguration synapseConfig) {
        if (registry == null) {
            log.warn((Object)"Unable to persist the mediation configuration to the registry. System registry is not available.");
            return;
        }
        RegistryBasedSynapseConfigSerializer serializer = new RegistryBasedSynapseConfigSerializer(registry, this.currentConfigurationName);
        serializer.serializeConfiguration(synapseConfig);
        try {
            Resource resource = registry.resourceExists("/repository/esb/configuration") ? registry.get("/repository/esb/configuration") : registry.newResource();
            resource.setProperty("synapseConfiguration", "serializedToRegistry");
            registry.put("/repository/esb/configuration", resource);
        }
        catch (RegistryException e) {
            log.warn((Object)"Error ocured while saving the mediation configuration in the registry. Mediation configuration might get loaded from the file system next time.", (Throwable)e);
        }
    }

    private SynapseConfiguration loadFromRegistry(UserRegistry registry, Properties properties) {
        if (registry == null) {
            log.warn((Object)"Unable to load the mediation configuration from the registry. System registry is not available.");
            return null;
        }
        if (this.isInitialStartup(registry)) {
            log.warn((Object)"Unable to load the mediation configuration from the registry. Mediation configuration data is not available in the registry.");
            return null;
        }
        String registryFailSafeProperty = this.getParameter("MediationConfig.RegistryFailSafe");
        boolean registryFailSafe = true;
        if ("false".equals(registryFailSafeProperty)) {
            registryFailSafe = false;
        }
        log.info((Object)"Loading the mediation configuration from the registry");
        RegistryBasedSynapseConfigBuilder builder = new RegistryBasedSynapseConfigBuilder(registry, this.currentConfigurationName, this.synapseXMLLocation, properties, registryFailSafe);
        SynapseConfiguration synapseConfig = builder.getConfiguration();
        synapseConfig.setProperties(SynapsePropertiesLoader.loadSynapseProperties());
        AxisConfiguration axisConfiguration = ((ConfigurationContext)this.getContext()).getAxisConfiguration();
        synapseConfig.setAxisConfiguration(axisConfiguration);
        MessageContextCreatorForAxis2.setSynConfig((SynapseConfiguration)synapseConfig);
        Parameter synapseConfigurationParameter = new Parameter("synapse.config", (Object)synapseConfig);
        try {
            axisConfiguration.addParameter(synapseConfigurationParameter);
        }
        catch (AxisFault e) {
            log.warn((Object)("Could not set parameter 'synapse.config' to the Axis2 configuration : " + e.getMessage()));
        }
        this.addServerIPAndHostEnrties(synapseConfig);
        synapseConfig.setPathToConfigFile(ServiceBusInitializer.getServerConfigurationInformation().getSynapseXMLLocation());
        return synapseConfig;
    }

    private UserRegistry getRegistry() {
        RegistryService registrySvc = ServiceBusInitializer.getRegistryService();
        if (registrySvc == null) {
            log.warn((Object)"Unable to access the registry service");
            return null;
        }
        try {
            return registrySvc.getConfigSystemRegistry();
        }
        catch (RegistryException e) {
            log.error((Object)"Error while obtaining a system registry instance", (Throwable)e);
            return null;
        }
    }

    private void addServerIPAndHostEnrties(SynapseConfiguration configuration) {
        Entry entry;
        String hostName = ServiceBusInitializer.getServerConfigurationInformation().getHostName();
        String ipAddress = ServiceBusInitializer.getServerConfigurationInformation().getIpAddress();
        if (hostName != null && !"".equals(hostName)) {
            entry = new Entry("SERVER_HOST");
            entry.setValue((Object)hostName);
            configuration.addEntry("SERVER_HOST", entry);
        }
        if (ipAddress != null && !"".equals(ipAddress)) {
            entry = new Entry("SERVER_IP");
            entry.setValue((Object)ipAddress);
            configuration.addEntry("SERVER_IP", entry);
        }
    }

    private boolean isInitialStartup(UserRegistry registry) {
        try {
            Resource resource;
            if (registry.resourceExists("/repository/esb/configuration") && (resource = registry.get("/repository/esb/configuration")) != null && "serializedToRegistry".equals(resource.getProperty("synapseConfiguration"))) {
                return false;
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while validating mediation configuration data in the registry", (Throwable)e);
        }
        return true;
    }

    private String getParameter(String name) {
        String value = System.getProperty(name);
        if (value != null) {
            return value;
        }
        ServerConfiguration serverConf = ServerConfiguration.getInstance();
        return serverConf.getFirstProperty(name);
    }

    private void handleFatal(String msg) {
        log.fatal((Object)msg);
        throw new SynapseException(msg);
    }
}

