/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence.registry;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.mediation.initializer.persistence.registry.AbstractRegistryStore;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class StartupRegistryStore
extends AbstractRegistryStore {
    public StartupRegistryStore(UserRegistry registry, String ConfigName) {
        super(registry, ConfigName);
        this.createCollection(this.getConfigurationPath());
    }

    @Override
    public Collection<OMElement> getElements() {
        ArrayList<OMElement> startupElements = new ArrayList();
        try {
            startupElements = this.getChildElementsInPath(this.getConfigurationPath());
        }
        catch (RegistryException e) {
            this.handleException("Couldn't get the list of startup tasks from the registry in path : " + this.getConfigurationPath(), (Exception)((Object)e));
        }
        return startupElements;
    }

    @Override
    public OMElement getElement(String name) {
        return null;
    }

    @Override
    public void persistElement(String name, OMElement element, String fileName) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Persisting startup task : " + name + " to the registry"));
        }
        String startupPath = this.getConfigurationPath() + "/" + name;
        AppDeployerUtils.attachArtifactToOwnerApp((String)fileName, (String)"synapse/task", (String)name, (int)this.registry.getTenantId());
        try {
            this.persistElement(element, startupPath, fileName);
        }
        catch (RegistryException e) {
            this.handleException("Unable to persist the startup task in the path : " + startupPath, (Exception)((Object)e));
        }
    }

    @Override
    public void deleteElement(String name) {
        String startupPath = this.getConfigurationPath() + "/" + name;
        try {
            if (this.registry.resourceExists(startupPath)) {
                this.registry.delete(startupPath);
            }
        }
        catch (RegistryException e) {
            this.handleException("Error in deleting the startup task at path : " + startupPath, (Exception)((Object)e));
        }
    }

    @Override
    protected String getConfigurationPath() {
        return this.getConfigurationRoot() + "/" + "synapse-startups";
    }
}

