/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.jaxp.SchemaResourceLSInput;
import org.apache.synapse.util.resolver.ResourceMap;
import org.apache.synapse.util.resolver.UserDefinedXmlSchemaURIResolver;
import org.w3c.dom.ls.LSInput;
import org.wso2.carbon.mediation.initializer.RegistryDependency;
import org.xml.sax.InputSource;

public class RegistryXmlSchemaURIResolver
implements UserDefinedXmlSchemaURIResolver {
    private String wsdlKey;
    private ResourceMap resourceMap;
    private SynapseConfiguration synCfg;
    private List<Value> schemaRegKeys = new ArrayList<Value>();
    private static final Log log = LogFactory.getLog(RegistryXmlSchemaURIResolver.class);

    public void init(ResourceMap resourceMap, SynapseConfiguration synCfg, String wsdlKey) {
        this.resourceMap = resourceMap;
        this.synCfg = synCfg;
        this.wsdlKey = wsdlKey;
    }

    public void init(ResourceMap resourceMap, SynapseConfiguration synCfg, List<Value> schemaRegKeys) {
        this.resourceMap = resourceMap;
        this.synCfg = synCfg;
        this.schemaRegKeys = schemaRegKeys;
    }

    public InputSource resolveEntity(String targetNamespace, String schemaLocation, String baseUri) {
        InputSource result = null;
        if (this.resourceMap != null) {
            result = this.resourceMap.resolve(this.synCfg, schemaLocation);
        }
        if (result == null && this.wsdlKey != null) {
            RegistryDependency regWSDLDep;
            Map<String, String> dependencyMap;
            if (log.isDebugEnabled()) {
                log.info((Object)("Starting to resolve schema " + schemaLocation + " using the dependencies got from wsdlKey " + this.wsdlKey));
            }
            if ((dependencyMap = (regWSDLDep = new RegistryDependency(this.wsdlKey)).getDependencies()) != null) {
                Set<String> keys = dependencyMap.keySet();
                for (String key : keys) {
                    String constructedPath;
                    String value = dependencyMap.get(key);
                    if (!value.endsWith(constructedPath = regWSDLDep.constructRegistryPathToRelativePath(schemaLocation))) continue;
                    if (this.resourceMap == null) {
                        this.resourceMap = new ResourceMap();
                    }
                    this.resourceMap.addResource(schemaLocation, value);
                    break;
                }
                result = this.resourceMap.resolve(this.synCfg, schemaLocation);
            }
        } else if (result == null) {
            result = new InputSource(SynapseConfigUtils.resolveRelativeURI((String)baseUri, (String)schemaLocation));
        }
        return result;
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        InputSource inputSource = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolving Schema resource " + systemId));
        }
        if (this.resourceMap == null) {
            for (int i = 0; i < this.schemaRegKeys.size(); ++i) {
                RegistryDependency regWSDLDep = new RegistryDependency(this.schemaRegKeys.get(i).getKeyValue());
                Map<String, String> dependencyMap = regWSDLDep.getDependencies();
                if (dependencyMap.size() > 0) {
                    Set<String> keys = dependencyMap.keySet();
                    for (String key : keys) {
                        String constructedPath;
                        String value = dependencyMap.get(key);
                        if (!value.endsWith(constructedPath = regWSDLDep.constructRegistryPathToRelativePath(systemId))) continue;
                        if (this.resourceMap == null) {
                            this.resourceMap = new ResourceMap();
                        }
                        this.resourceMap.addResource(systemId, value);
                        break;
                    }
                    inputSource = this.resourceMap.resolve(this.synCfg, systemId);
                    continue;
                }
                this.resourceMap.addResource(systemId, this.schemaRegKeys.get(i).getKeyValue());
            }
        } else {
            inputSource = this.resourceMap.resolve(this.synCfg, systemId);
        }
        if (inputSource == null) {
            log.warn((Object)("Unable to resolve schema resource " + systemId));
            return null;
        }
        SchemaResourceLSInput schemaResourceLSInput = new SchemaResourceLSInput();
        schemaResourceLSInput.setByteStream(inputSource.getByteStream());
        return schemaResourceLSInput;
    }
}

