/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.initializer.ServiceBusInitializer;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryDependency {
    private String registryKey;
    private List<String> dependencyResourcePaths = new ArrayList<String>();
    private static final Log log = LogFactory.getLog(RegistryDependency.class);

    public RegistryDependency(String registryKey) {
        this.registryKey = registryKey;
    }

    public Map<String, String> getDependencies() {
        List<Association> childDependencies = null;
        HashMap<String, String> dependencyMap = new HashMap<String, String>();
        UserRegistry registry = this.getRegistry();
        this.registryKey = this.constructResourcePath();
        if (this.registryKey != null) {
            childDependencies = this.getChildDependencies(this.registryKey, registry);
        }
        if (childDependencies == null || childDependencies.size() == 0) {
            return dependencyMap;
        }
        Iterator<Association> parentDependenciesItr = childDependencies.iterator();
        while (parentDependenciesItr.hasNext()) {
            Map<Object, Object> childDependencyMap = new HashMap();
            Association childAssociation = parentDependenciesItr.next();
            childDependencyMap = this.createAssociationTree(childAssociation, registry);
            dependencyMap.putAll(childDependencyMap);
        }
        return dependencyMap;
    }

    private Map<String, String> createAssociationTree(Association childAssociation, UserRegistry registry) {
        HashMap<String, String> childAssociationMap = new HashMap<String, String>();
        boolean loopEnd = false;
        String childAssociationResourcePath = childAssociation.getDestinationPath();
        String childAssociationResourceKey = this.constructResourceKey(childAssociationResourcePath);
        childAssociationMap.put(childAssociationResourcePath, childAssociationResourceKey);
        this.dependencyResourcePaths.add(childAssociationResourcePath);
        try {
            if (registry.resourceExists(childAssociationResourcePath)) {
                List<Association> childAssociations = this.getChildDependencies(childAssociationResourcePath, registry);
                if (childAssociations == null) {
                    loopEnd = true;
                }
                if (!loopEnd && !childAssociations.isEmpty()) {
                    for (Association descendantChildAssociation : childAssociations) {
                        if (childAssociationResourcePath.equals(descendantChildAssociation.getDestinationPath()) || this.dependencyResourcePaths.contains(descendantChildAssociation.getDestinationPath())) continue;
                        String childResourcePath = descendantChildAssociation.getDestinationPath();
                        String childResourceKey = this.constructResourceKey(childResourcePath);
                        childAssociationMap.put(childResourcePath, childResourceKey);
                        break;
                    }
                }
                if (!loopEnd && !childAssociations.isEmpty()) {
                    for (Association descendantChildAssociation : childAssociations) {
                        if (childAssociationResourcePath.equals(descendantChildAssociation.getDestinationPath()) || this.dependencyResourcePaths.contains(descendantChildAssociation.getDestinationPath())) continue;
                        this.createAssociationTree(descendantChildAssociation, registry);
                    }
                }
            }
        }
        catch (RegistryException e) {
            String msg = "Could not locate the resource/dependencies for the" + childAssociationResourcePath;
            log.error((Object)msg, (Throwable)e);
        }
        return childAssociationMap;
    }

    private List<Association> getChildDependencies(String registryActualPath, UserRegistry registry) {
        Association[] dependencies = null;
        ArrayList<Association> dependencyList = new ArrayList<Association>();
        ArrayList<Association> temproryList = new ArrayList<Association>();
        try {
            dependencies = registry.getAssociations(registryActualPath, "depends");
            temproryList.addAll(Arrays.asList(dependencies));
        }
        catch (RegistryException e) {
            String msg = "Could not locate the dependencies for the" + this.registryKey;
            log.error((Object)msg, (Throwable)e);
        }
        for (Association childAssociation : temproryList) {
            dependencyList.add(childAssociation);
        }
        return dependencyList;
    }

    private String constructResourceKey(String resourcePath) {
        String prefix;
        String resourceKey = null;
        if (resourcePath.startsWith("/_system/config")) {
            prefix = "/_system/config";
            resourceKey = resourcePath.replace(prefix, "conf:");
        }
        if (resourcePath.startsWith("/_system/governance")) {
            prefix = "/_system/governance";
            resourceKey = resourcePath.replace(prefix, "gov:");
        }
        return resourceKey;
    }

    private UserRegistry getRegistry() {
        RegistryService registrySvc = ServiceBusInitializer.getRegistryService();
        if (registrySvc == null) {
            log.warn((Object)"Unable to access the registry service");
            return null;
        }
        try {
            return registrySvc.getRegistry();
        }
        catch (RegistryException e) {
            log.error((Object)"Error while obtaining a system registry instance", (Throwable)e);
            return null;
        }
    }

    private String constructResourcePath() {
        String wsdlResourcePath = null;
        if (this.registryKey != null && !"".equals(this.registryKey)) {
            String prefix;
            if (this.registryKey.startsWith("conf:")) {
                prefix = "conf:";
                wsdlResourcePath = this.registryKey.replace(prefix, "/_system/config");
            }
            if (this.registryKey.startsWith("gov:")) {
                prefix = "gov:";
                wsdlResourcePath = this.registryKey.replace(prefix, "/_system/governance");
            }
        }
        return wsdlResourcePath;
    }

    public String constructRegistryPathToRelativePath(String relativeLocation) {
        String registryPath_suffix;
        if (relativeLocation.contains(";")) {
            String relativeLocation_new;
            relativeLocation = relativeLocation_new = relativeLocation.substring(0, relativeLocation.indexOf(";"));
        }
        if (relativeLocation.contains("../")) {
            relativeLocation = registryPath_suffix = relativeLocation.substring(relativeLocation.lastIndexOf("../") + 3, relativeLocation.length());
        }
        if (relativeLocation.contains("./")) {
            relativeLocation = registryPath_suffix = relativeLocation.substring(relativeLocation.lastIndexOf("./") + 2, relativeLocation.length());
        }
        return relativeLocation;
    }
}

