/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.configurations;

import java.util.Collection;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MultiXMLConfigurationSerializer;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.task.TaskDescriptionRepository;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.mediation.initializer.RegistryBasedSynapseConfigBuilder;
import org.wso2.carbon.mediation.initializer.RegistryBasedSynapseConfigSerializer;
import org.wso2.carbon.mediation.initializer.configurations.ConfigurationInitilizerException;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ConfigurationUtils {
    private static Log log = LogFactory.getLog(ConfigurationUtils.class);

    public static String getParameter(String name) {
        String value = System.getProperty(name);
        if (value != null) {
            return value;
        }
        ServerConfiguration serverConf = ServerConfiguration.getInstance();
        return serverConf.getFirstProperty(name);
    }

    public static SynapseConfiguration loadFromRegistry(UserRegistry registry, String name, String synapseXMLLocation, Properties properties) {
        if (registry == null) {
            log.warn((Object)"Unable to load the mediation configuration from the registry. System registry is not available.");
            return null;
        }
        if (ConfigurationUtils.isInitialStartup(registry)) {
            log.warn((Object)"Unable to load the mediation configuration from the registry. Mediation configuration data is not available in the registry.");
            return null;
        }
        log.info((Object)"Loading the mediation configuration from the registry");
        String registryFailSafeProperty = ConfigurationUtils.getParameter("MediationConfig.RegistryFailSafe");
        boolean registryFailSafe = true;
        if ("false".equals(registryFailSafeProperty)) {
            registryFailSafe = false;
        }
        RegistryBasedSynapseConfigBuilder builder = new RegistryBasedSynapseConfigBuilder(registry, name, synapseXMLLocation, properties, registryFailSafe);
        return builder.getConfiguration();
    }

    public static boolean isInitialStartup(UserRegistry registry) {
        try {
            Resource resource;
            if (registry.resourceExists("/repository/esb/configuration") && (resource = registry.get("/repository/esb/configuration")) != null && "serializedToRegistry".equals(resource.getProperty("synapseConfiguration"))) {
                return false;
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while validating mediation configuration data in the registry", (Throwable)e);
        }
        return true;
    }

    public static void destroyConfiguration(SynapseConfiguration oldConfig, AxisConfiguration axisCfg, SynapseEnvironment synapseEnvironment) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Stopping Proxy services...");
        }
        for (ProxyService proxyService : oldConfig.getProxyServices()) {
            if (proxyService == null) continue;
            try {
                AxisService axisService;
                if (proxyService.getTargetInLineInSequence() != null) {
                    proxyService.getTargetInLineInSequence().destroy();
                }
                if (proxyService.getTargetInLineOutSequence() != null) {
                    proxyService.getTargetInLineOutSequence().destroy();
                }
                if (proxyService.getTargetInLineEndpoint() != null) {
                    proxyService.getTargetInLineEndpoint().destroy();
                }
                if ((axisService = axisCfg.getServiceForActivation(proxyService.getName())) != null) {
                    axisService.getParent().addParameter("keepServiceHistory", (Object)"true");
                }
                axisCfg.removeService(proxyService.getName());
            }
            catch (AxisFault e) {
                throw new ConfigurationInitilizerException("Error removing Proxy service : " + proxyService.getName(), e);
            }
        }
        for (SequenceMediator seq : oldConfig.getDefinedSequences().values()) {
            if (seq == null) continue;
            seq.destroy();
        }
        for (Startup stp : oldConfig.getStartups()) {
            if (stp == null) continue;
            stp.destroy();
        }
        TaskDescriptionRepository repository = synapseEnvironment.getTaskManager().getTaskDescriptionRepository();
        if (repository != null) {
            repository.clear();
        }
        synapseEnvironment.getTaskManager().cleanup();
        Collection eventSources = oldConfig.getEventSources();
        for (SynapseEventSource ses : eventSources) {
            AxisService axisService = axisCfg.getServiceForActivation(ses.getName());
            if (axisService != null) {
                axisService.getParent().addParameter("keepServiceHistory", (Object)"true");
            }
            axisCfg.removeService(ses.getName());
        }
        for (PriorityExecutor executor : oldConfig.getPriorityExecutors().values()) {
            executor.destroy();
        }
    }

    public static void saveToRegistry(UserRegistry registry, SynapseConfiguration synapseConfig, String name) {
        if (registry == null) {
            log.warn((Object)"Unable to persist the mediation configuration to the registry. System registry is not available.");
            return;
        }
        RegistryBasedSynapseConfigSerializer serializer = new RegistryBasedSynapseConfigSerializer(registry, name);
        serializer.serializeConfiguration(synapseConfig);
        try {
            Resource resource = registry.resourceExists("/repository/esb/configuration") ? registry.get("/repository/esb/configuration") : registry.newResource();
            resource.setProperty("synapseConfiguration", "serializedToRegistry");
            registry.put("/repository/esb/configuration", resource);
        }
        catch (RegistryException e) {
            log.warn((Object)"Error ocured while saving the mediation configuration in the registry. Mediation configuration might get loaded from the file system next time.", (Throwable)e);
        }
    }

    public static void initPersistence(SynapseConfiguration synCfgConfiguration, UserRegistry registry, String configurationLocation, AxisConfiguration axisConfiguration, String name) throws ConfigurationInitilizerException {
        ServerConfiguration serverConf = ServerConfiguration.getInstance();
        String persistence = serverConf.getFirstProperty("MediationConfig.Persistence");
        if (!"disabled".equals(persistence)) {
            String regPersistence = serverConf.getFirstProperty("MediationConfig.RegistryPersistence");
            String interval = serverConf.getFirstProperty("MediationConfig.WorkerInterval");
            long intervalInMillis = 5000L;
            if (interval != null && !"".equals(interval)) {
                try {
                    intervalInMillis = Long.parseLong(interval);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Invalid value " + interval + " specified for the mediation " + "persistence worker interval, Using defaults"), (Throwable)e);
                }
            }
            MediationPersistenceManager pm = new MediationPersistenceManager("disabled".equals(regPersistence) ? null : registry, configurationLocation, synCfgConfiguration, intervalInMillis, name);
            try {
                axisConfiguration.addParameter(new Parameter("PERSISTENCE_MANAGER", (Object)pm));
            }
            catch (AxisFault axisFault) {
                throw new ConfigurationInitilizerException("Cannot add the PERSISTENCE_MANAGER to the configuration", axisFault);
            }
        }
        log.info((Object)"Persistence for mediation configuration is disabled");
    }

    public static void saveToFileSystem(SynapseConfiguration synapseConfig) {
        log.info((Object)"Saving the mediation configuration to the file system");
        String confPath = synapseConfig.getPathToConfigFile();
        MultiXMLConfigurationSerializer serializer = new MultiXMLConfigurationSerializer(confPath);
        serializer.serialize(synapseConfig);
    }
}

