/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.registry;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegistryHelper {
    private static final Log log = LogFactory.getLog(RegistryHelper.class);
    public static final char URL_SEPARATOR_CHAR = '/';

    public static File getRootDirectory(String path) {
        if (path == null) {
            String msg = "Path can not be null";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        try {
            URL url = new URL(path);
            path = url.getPath();
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            String esbHome = RegistryHelper.getHome();
            if (!esbHome.endsWith("/")) {
                esbHome = esbHome + "/";
            }
            file = new File(esbHome + path);
        }
        return file;
    }

    public static String getHome() {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null || "".equals(carbonHome) || ".".equals(carbonHome)) {
            carbonHome = RegistryHelper.getSystemDependentPath(new File(".").getAbsolutePath());
        }
        return carbonHome;
    }

    public static String getSystemDependentPath(String path) {
        return path.replace('/', File.separatorChar);
    }
}

