/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.Startup;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.EntrySerializer;
import org.apache.synapse.config.xml.MediatorSerializerFinder;
import org.apache.synapse.config.xml.MessageProcessorSerializer;
import org.apache.synapse.config.xml.MessageStoreSerializer;
import org.apache.synapse.config.xml.ProxyServiceSerializer;
import org.apache.synapse.config.xml.RegistrySerializer;
import org.apache.synapse.config.xml.StartupFinder;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.config.xml.eventing.EventSourceSerializer;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.message.processors.MessageProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.registry.Registry;
import org.wso2.carbon.mediation.initializer.persistence.registry.EndpointRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.EventSourceRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.LocalEntryRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.MessageProcessorRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.MessageStoreRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.ProxyServiceRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.SequenceRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.StartupRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.SynapseRegistriesRegistryStore;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryBasedSynapseConfigSerializer {
    private static final Log log = LogFactory.getLog(RegistryBasedSynapseConfigSerializer.class);
    private UserRegistry registry;
    private String configName;

    public RegistryBasedSynapseConfigSerializer(UserRegistry registry, String configName) {
        this.registry = registry;
        this.configName = configName;
    }

    public void serializeConfiguration(SynapseConfiguration configuration) {
        log.info((Object)"Persisting the SynapseConfiguration to the registry...");
        try {
            boolean transactionStarted = Transaction.isStarted();
            if (!transactionStarted) {
                this.registry.beginTransaction();
            }
            this.clearSynapseConfigRegistrySpace();
            if (configuration.getRegistry() != null) {
                String fileName = null;
                if (Boolean.valueOf(configuration.getProperty("__separateRegDef")).booleanValue()) {
                    fileName = "registry.xml";
                }
                this.serializeSynapseRegistryToRegistry(configuration.getRegistry(), fileName);
            }
            for (ProxyService proxyService : configuration.getProxyServices()) {
                this.serializeProxyServiceToRegistry(proxyService);
            }
            for (SynapseEventSource synapseEventSource : configuration.getEventSources()) {
                this.serializeEventSourceToRegistry(synapseEventSource);
            }
            for (Startup startup : configuration.getStartups()) {
                this.serializeStartupToRegistry(startup);
            }
            for (Map.Entry entry : configuration.getMessageStores().entrySet()) {
                this.serializeMessageStoreToRegistry((MessageStore)entry.getValue());
            }
            for (Map.Entry entry : configuration.getMessageProcessors().entrySet()) {
                this.serializeMessageProcessorToRegistry((MessageProcessor)entry.getValue());
            }
            for (Object object : configuration.getLocalRegistry().values()) {
                Entry entry;
                if (object instanceof SequenceMediator) {
                    this.serializeSequenceToRegistry((SequenceMediator)object);
                    continue;
                }
                if (object instanceof Endpoint) {
                    this.serializeEndpointToRegistry((Endpoint)object);
                    continue;
                }
                if (!(object instanceof Entry) || "SERVER_HOST".equals((entry = (Entry)object).getKey()) || "SERVER_IP".equals(entry.getKey()) || entry.getType() == 3) continue;
                this.serializeEntryToRegistry(entry);
            }
            if (!transactionStarted) {
                this.registry.commitTransaction();
            }
        }
        catch (Exception e) {
            try {
                this.registry.rollbackTransaction();
            }
            catch (Exception ex) {
                log.error((Object)"Unable to persist SynapseConfiguration to the registry", (Throwable)ex);
            }
            log.error((Object)"Unable to persist SynapseConfiguration to the registry", (Throwable)e);
        }
    }

    private void serializeSynapseRegistryToRegistry(Registry synapseRegistry, String fileName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Persisting the synapse registry declaration");
        }
        SynapseRegistriesRegistryStore synapseRegistryStore = new SynapseRegistriesRegistryStore(this.registry, this.configName);
        synapseRegistryStore.persistElement(RegistrySerializer.serializeRegistry(null, (Registry)synapseRegistry), fileName);
    }

    private void serializeProxyServiceToRegistry(ProxyService proxyService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persisting the proxy service " + proxyService.getName()));
        }
        ProxyServiceRegistryStore proxyServiceStore = new ProxyServiceRegistryStore(this.registry, this.configName);
        proxyServiceStore.persistElement(proxyService.getName(), ProxyServiceSerializer.serializeProxy(null, (ProxyService)proxyService), proxyService.getFileName());
    }

    private void serializeEventSourceToRegistry(SynapseEventSource eventSource) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persisting the event source " + eventSource.getName()));
        }
        EventSourceRegistryStore eventSourceStore = new EventSourceRegistryStore(this.registry, this.configName);
        eventSourceStore.persistElement(eventSource.getName(), EventSourceSerializer.serializeEventSource(null, (SynapseEventSource)eventSource), eventSource.getFileName());
    }

    private void serializeSequenceToRegistry(SequenceMediator sequence) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persisting the sequence " + sequence.getName()));
        }
        SequenceRegistryStore sequenceStore = new SequenceRegistryStore(this.registry, this.configName);
        sequenceStore.persistElement(sequence.getName(), MediatorSerializerFinder.getInstance().getSerializer((Mediator)sequence).serializeMediator(null, (Mediator)sequence), sequence.getFileName());
    }

    private void serializeEndpointToRegistry(Endpoint endpoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persisting the endpoint " + endpoint.getName()));
        }
        EndpointRegistryStore endpointStore = new EndpointRegistryStore(this.registry, this.configName);
        endpointStore.persistElement(endpoint.getName(), EndpointSerializer.getElementFromEndpoint((Endpoint)endpoint), endpoint.getFileName());
    }

    private void serializeEntryToRegistry(Entry entry) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persisting the local entry " + entry.getKey()));
        }
        LocalEntryRegistryStore localEntryStore = new LocalEntryRegistryStore(this.registry, this.configName);
        localEntryStore.persistElement(entry.getKey(), EntrySerializer.serializeEntry((Entry)entry, null), entry.getFileName());
    }

    private void serializeStartupToRegistry(Startup startup) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persisting the startup task " + startup.getName()));
        }
        StartupRegistryStore startupStore = new StartupRegistryStore(this.registry, this.configName);
        startupStore.persistElement(startup.getName(), StartupFinder.getInstance().serializeStartup(null, startup), startup.getFileName());
    }

    private void serializeMessageStoreToRegistry(MessageStore messageStore) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persisting the message store '" + messageStore.getName() + "'"));
        }
        MessageStoreRegistryStore messageStoreRegistryStore = new MessageStoreRegistryStore(this.registry, this.configName);
        messageStoreRegistryStore.persistElement(messageStore.getName(), MessageStoreSerializer.serializeMessageStore(null, (MessageStore)messageStore), messageStore.getFileName());
    }

    private void serializeMessageProcessorToRegistry(MessageProcessor messageProcessor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persisting the message processor '" + messageProcessor.getName() + "'"));
        }
        MessageProcessorRegistryStore messageProcessorRegistryStore = new MessageProcessorRegistryStore(this.registry, this.configName);
        messageProcessorRegistryStore.persistElement(messageProcessor.getName(), MessageProcessorSerializer.serializeMessageProcessor(null, (MessageProcessor)messageProcessor), messageProcessor.getFileName());
    }

    private void clearSynapseConfigRegistrySpace() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Clearing the registry space at path : /repository/synapse");
            }
            if (this.registry.resourceExists("/repository/synapse/" + this.configName)) {
                this.registry.delete("/repository/synapse/" + this.configName);
            }
        }
        catch (RegistryException e) {
            log.warn((Object)"Couldn't clear the synapse configuration registry space");
        }
    }
}

