/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal.delivery.registry;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.wso2.carbon.event.core.delivery.MatchingManager;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.internal.util.EventBrokerHolder;
import org.wso2.carbon.event.core.internal.util.JavaUtil;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryMatchingManager
implements MatchingManager {
    private RegistryService registryService;
    private String subscriptionStoragePath;

    public RegistryMatchingManager(String subscriptionStoragePath) {
        this.subscriptionStoragePath = subscriptionStoragePath;
        this.registryService = EventBrokerHolder.getInstance().getRegistryService();
    }

    @Override
    public void addSubscription(Subscription subscription) {
    }

    @Override
    public List<Subscription> getMatchingSubscriptions(String topicName) throws EventBrokerException {
        String topicResourcePath = this.subscriptionStoragePath;
        if (!topicName.startsWith("/")) {
            topicResourcePath = topicResourcePath + "/";
        }
        topicResourcePath = topicResourcePath + topicName;
        if (!topicName.endsWith("/")) {
            topicResourcePath = topicResourcePath + "/";
        }
        topicResourcePath = topicResourcePath + "ws.subscriptions";
        ArrayList<Subscription> matchingSubscriptions = new ArrayList<Subscription>();
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String subscriptionID = null;
            if (userRegistry.resourceExists(topicResourcePath)) {
                String[] subscriptionPaths;
                Collection subscriptions = (Collection)userRegistry.get(topicResourcePath);
                for (String subscriptionPath : subscriptionPaths = (String[])subscriptions.getContent()) {
                    Resource resource = userRegistry.get(subscriptionPath);
                    Subscription subscription = JavaUtil.getSubscription(resource);
                    subscriptionID = subscriptionPath.substring(subscriptionPath.lastIndexOf("/") + 1);
                    subscription.setId(subscriptionID);
                    subscription.setTopicName(topicName);
                    Calendar current = Calendar.getInstance();
                    if (subscription.getExpires() != null) {
                        if (!current.before(subscription.getExpires())) continue;
                        matchingSubscriptions.add(subscription);
                        continue;
                    }
                    matchingSubscriptions.add(subscription);
                }
            }
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Can not get the Registry ", e);
        }
        return matchingSubscriptions;
    }

    @Override
    public void unSubscribe(String subscriptionID) throws EventBrokerException {
    }

    @Override
    public void renewSubscription(Subscription subscription) throws EventBrokerException {
    }

    @Override
    public void initializeTenant() throws EventBrokerException {
    }
}

