/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.event.core.EventBrokerFactory;
import org.wso2.carbon.event.core.delivery.DeliveryManagerFactory;
import org.wso2.carbon.event.core.exception.EventBrokerConfigurationException;
import org.wso2.carbon.event.core.internal.CarbonEventBroker;
import org.wso2.carbon.event.core.internal.util.JavaUtil;
import org.wso2.carbon.event.core.subscription.SubscriptionManagerFactory;
import org.wso2.carbon.event.core.topic.TopicManager;
import org.wso2.carbon.event.core.topic.TopicManagerFactory;

public class CarbonEventBrokerFactory
implements EventBrokerFactory {
    public static final String EB_MIN_SPARE_THREADS = "minSpareThreads";
    public static final String EB_MAX_THREADS = "maxThreads";
    public static final String EB_MAX_QUEUED_REQUESTS = "maxQueuedRequests";
    public static final String EB_KEEP_ALIVE_TIME = "keepAliveTime";

    @Override
    public EventBroker getEventBroker(OMElement config) throws EventBrokerConfigurationException {
        CarbonEventBroker carbonEventBroker = new CarbonEventBroker();
        OMElement topicManagerElement = config.getFirstChildWithName(new QName("http://wso2.org/carbon/event/broker", "topicManager"));
        TopicManagerFactory topicManagerFactory = (TopicManagerFactory)JavaUtil.getObject(topicManagerElement);
        TopicManager topicManager = topicManagerFactory.getTopicManager(topicManagerElement);
        carbonEventBroker.setTopicManager(topicManager);
        OMElement subscriptionManager = config.getFirstChildWithName(new QName("http://wso2.org/carbon/event/broker", "subscriptionManager"));
        SubscriptionManagerFactory subscriptionManagerFactory = (SubscriptionManagerFactory)JavaUtil.getObject(subscriptionManager);
        carbonEventBroker.setSubscriptionManager(subscriptionManagerFactory.getSubscriptionManager(subscriptionManager));
        OMElement delivaryManager = config.getFirstChildWithName(new QName("http://wso2.org/carbon/event/broker", "deliveryManager"));
        DeliveryManagerFactory delivaryManagerfactory = (DeliveryManagerFactory)JavaUtil.getObject(delivaryManager);
        carbonEventBroker.setDelivaryManager(delivaryManagerfactory.getDeliveryManger(delivaryManager));
        OMElement eventPublisher = config.getFirstChildWithName(new QName("http://wso2.org/carbon/event/broker", "eventPublisher"));
        int minSpareThreads = Integer.parseInt(JavaUtil.getValue(eventPublisher, EB_MIN_SPARE_THREADS));
        int maxThreads = Integer.parseInt(JavaUtil.getValue(eventPublisher, EB_MAX_THREADS));
        int maxQueuedRequests = Integer.parseInt(JavaUtil.getValue(eventPublisher, EB_MAX_QUEUED_REQUESTS));
        long keepAliveTime = Integer.parseInt(JavaUtil.getValue(eventPublisher, EB_KEEP_ALIVE_TIME));
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(maxQueuedRequests);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(minSpareThreads, maxThreads, keepAliveTime, TimeUnit.MILLISECONDS, queue);
        carbonEventBroker.setExecutor(executor);
        carbonEventBroker.init();
        return carbonEventBroker;
    }
}

