/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.startup.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.Startup;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.task.service.TaskManagementService;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsService;
import org.wso2.carbon.startup.StartupAdminService;
import org.wso2.carbon.startup.StartupJobMetaDataProviderService;
import org.wso2.carbon.startup.StartupTaskDeployer;
import org.wso2.carbon.task.services.JobMetaDataProviderService;

public class StartupAdminServiceComponent {
    private static final Log log = LogFactory.getLog(StartupAdminServiceComponent.class);
    private Map<Integer, SynapseEnvironmentService> synapseEnvironmentServices = new HashMap<Integer, SynapseEnvironmentService>();
    private boolean initialized = false;

    protected void activate(ComponentContext context) throws Exception {
        try {
            this.initialized = true;
            SynapseEnvironmentService synEnvService = this.synapseEnvironmentServices.get(-1234);
            if (synEnvService != null) {
                context.getBundleContext().registerService(TaskManagementService.class.getName(), (Object)new StartupAdminService(), null);
                context.getBundleContext().registerService(JobMetaDataProviderService.class.getName(), (Object)new StartupJobMetaDataProviderService(), null);
                this.registerDeployer(synEnvService.getConfigurationContext().getAxisConfiguration(), synEnvService.getSynapseEnvironment());
            } else {
                log.error((Object)"Couldn't initialize the StartupManager, SynapseEnvironment service and/or TaskDescriptionRepositoryService not found");
            }
        }
        catch (Throwable t) {
            log.error((Object)"Couldn't initialize the StartupManager, SynapseEnvironment service and/or TaskDescriptionRepositoryService not found");
        }
    }

    protected void deactivate(ComponentContext context) throws Exception {
        Set<Map.Entry<Integer, SynapseEnvironmentService>> entrySet = this.synapseEnvironmentServices.entrySet();
        for (Map.Entry<Integer, SynapseEnvironmentService> entry : entrySet) {
            this.unregistryDeployer(entry.getValue().getConfigurationContext().getAxisConfiguration(), entry.getValue().getSynapseEnvironment());
        }
    }

    private void registerDeployer(AxisConfiguration axisConfig, SynapseEnvironment synEnv) {
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        SynapseArtifactDeploymentStore deploymentStore = synEnv.getSynapseConfiguration().getArtifactDeploymentStore();
        String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath((ServerContextInformation)synEnv.getServerContextInformation());
        String taskDirDirPath = synapseConfigPath + File.separator + "tasks";
        for (Startup stp : synEnv.getSynapseConfiguration().getStartups()) {
            if (stp.getFileName() == null) continue;
            deploymentStore.addRestoredArtifact(taskDirDirPath + File.separator + stp.getFileName());
        }
        deploymentEngine.addDeployer((Deployer)new StartupTaskDeployer(), taskDirDirPath, "xml");
    }

    protected void setSynapseEnvironmentService(SynapseEnvironmentService synEnvSvc) {
        boolean alreadyCreated = this.synapseEnvironmentServices.containsKey(synEnvSvc.getTenantId());
        this.synapseEnvironmentServices.put(synEnvSvc.getTenantId(), synEnvSvc);
        if (this.initialized) {
            int tenantId = synEnvSvc.getTenantId();
            AxisConfiguration axisConfiguration = synEnvSvc.getConfigurationContext().getAxisConfiguration();
            if (!alreadyCreated) {
                this.registerDeployer(synEnvSvc.getConfigurationContext().getAxisConfiguration(), synEnvSvc.getSynapseEnvironment());
            }
        }
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        this.synapseEnvironmentServices.remove(synapseEnvironmentService.getTenantId());
    }

    protected void setSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
    }

    protected void unsetSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
        int tenantId = synapseRegistrationsService.getTenantId();
        if (this.synapseEnvironmentServices.containsKey(tenantId)) {
            SynapseEnvironment env = this.synapseEnvironmentServices.get(tenantId).getSynapseEnvironment();
            this.synapseEnvironmentServices.remove(synapseRegistrationsService.getTenantId());
            AxisConfiguration axisConfig = synapseRegistrationsService.getConfigurationContext().getAxisConfiguration();
            if (axisConfig != null) {
                this.unregistryDeployer(axisConfig, env);
            }
        }
    }

    private void unregistryDeployer(AxisConfiguration axisConfig, SynapseEnvironment synapseEnvironment) {
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath((ServerContextInformation)synapseEnvironment.getServerContextInformation());
        String proxyDirPath = synapseConfigPath + File.separator + "tasks";
        deploymentEngine.removeDeployer(proxyDirPath, "xml");
    }
}

