/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MultiXMLConfigurationSerializer;
import org.apache.synapse.config.xml.XMLConfigurationSerializer;
import org.wso2.carbon.mediation.initializer.RegistryBasedSynapseConfigSerializer;
import org.wso2.carbon.mediation.initializer.persistence.APIStore;
import org.wso2.carbon.mediation.initializer.persistence.AbstractStore;
import org.wso2.carbon.mediation.initializer.persistence.EndpointStore;
import org.wso2.carbon.mediation.initializer.persistence.EndpointTemplateStore;
import org.wso2.carbon.mediation.initializer.persistence.EventSourceStore;
import org.wso2.carbon.mediation.initializer.persistence.ExecutorStore;
import org.wso2.carbon.mediation.initializer.persistence.ImportStore;
import org.wso2.carbon.mediation.initializer.persistence.LocalEntryStore;
import org.wso2.carbon.mediation.initializer.persistence.MessageProcessorStore;
import org.wso2.carbon.mediation.initializer.persistence.MessageStoreStore;
import org.wso2.carbon.mediation.initializer.persistence.ProxyServiceStore;
import org.wso2.carbon.mediation.initializer.persistence.SequenceStore;
import org.wso2.carbon.mediation.initializer.persistence.ServiceBusPersistenceException;
import org.wso2.carbon.mediation.initializer.persistence.StartupStore;
import org.wso2.carbon.mediation.initializer.persistence.SynapseRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.TemplateStore;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class MediationPersistenceManager {
    private static final Log log = LogFactory.getLog(MediationPersistenceManager.class);
    private UserRegistry registry;
    private boolean initialized = false;
    private String configPath;
    private boolean flatFileMode;
    private SynapseConfiguration synapseConfiguration;
    private String configName;
    private final LinkedList<PersistenceRequest> requestQueue = new LinkedList();
    private MediationPersistenceWorker worker;
    private boolean acceptRequests;
    private long interval = 5000L;
    private Map<Integer, AbstractStore> dataStores;

    public MediationPersistenceManager(UserRegistry registry, String configPath, SynapseConfiguration synapseConfiguration, long interval, String configName) {
        if (this.initialized) {
            log.warn((Object)"Mediation persistence manager is already initialized");
            return;
        }
        if (configPath == null) {
            log.warn((Object)"Synapse configuration location is not provided - Unable to initialize the mediation persistence manager.");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing the mediation persistence manager");
        }
        this.registry = registry;
        this.configPath = configPath;
        this.synapseConfiguration = synapseConfiguration;
        this.configName = configName;
        if (interval > 0L) {
            this.interval = interval;
        } else {
            log.warn((Object)("Invalid interval value " + interval + " for the mediation persistence " + "worker, Using defaults"));
        }
        File file = new File(configPath);
        this.flatFileMode = file.exists() && file.isFile();
        this.initDataStores();
        this.worker = new MediationPersistenceWorker();
        this.worker.start();
        this.acceptRequests = true;
        this.initialized = true;
    }

    private void initDataStores() {
        this.dataStores = new HashMap<Integer, AbstractStore>();
        this.dataStores.put(0, new ProxyServiceStore(this.configPath, this.registry, this.configName));
        this.dataStores.put(1, new SequenceStore(this.configPath, this.registry, this.configName));
        this.dataStores.put(2, new EndpointStore(this.configPath, this.registry, this.configName));
        this.dataStores.put(3, new StartupStore(this.configPath, this.registry, this.configName));
        this.dataStores.put(5, new EventSourceStore(this.configPath, this.registry, this.configName));
        this.dataStores.put(4, new LocalEntryStore(this.configPath, this.registry, this.configName));
        this.dataStores.put(6, new SynapseRegistryStore(this.configPath, this.registry, this.configName));
        this.dataStores.put(8, new ExecutorStore(this.configPath, this.registry, this.configName));
        this.dataStores.put(9, new TemplateStore(this.configPath, this.registry, this.configName));
        this.dataStores.put(12, new EndpointTemplateStore(this.configPath, this.registry, this.configName));
        this.dataStores.put(10, new MessageStoreStore(this.configPath, this.registry, this.configName));
        this.dataStores.put(11, new MessageProcessorStore(this.configPath, this.registry, this.configName));
        this.dataStores.put(13, new APIStore(this.configPath, this.registry, this.configName));
        this.dataStores.put(14, new ImportStore(this.configPath, this.registry, this.configName));
    }

    public void destroy() {
        if (!this.initialized) {
            return;
        }
        this.acceptRequests = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Shutting down mediation persistence manager");
        }
        while (!this.requestQueue.isEmpty()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.worker.proceed = false;
        if (this.worker.isAlive()) {
            this.worker.interrupt();
        }
        this.initialized = false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveItem(String name, int itemType) {
        if (!this.initialized || !this.acceptRequests) {
            log.warn((Object)"Mediation persistence manager is either not initialized or not in the 'accepting' mode. Ignoring the save request.");
            return;
        }
        if (itemType == 7) {
            this.saveFullConfiguration(false);
            return;
        }
        PersistenceRequest request = new PersistenceRequest(name, itemType, true);
        LinkedList<PersistenceRequest> linkedList = this.requestQueue;
        synchronized (linkedList) {
            this.addToQueue(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteItem(String name, String fileName, int itemType) {
        if (!this.initialized || !this.acceptRequests) {
            log.warn((Object)"Mediation persistence manager is either not initialized or not in the 'accepting' mode. Ignoring the delete request.");
            return;
        }
        if (itemType == 7) {
            return;
        }
        PersistenceRequest request = new PersistenceRequest(name, fileName, itemType, false);
        LinkedList<PersistenceRequest> linkedList = this.requestQueue;
        synchronized (linkedList) {
            this.addToQueue(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveItemToRegistry(String name, int itemType) {
        if (!this.initialized || !this.acceptRequests) {
            log.warn((Object)"Mediation persistence manager is either not initialized or not in the 'accepting' mode. Ignoring the save request.");
            return;
        }
        if (this.registry == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registry persistence is disabled for mediation configuration. Ignoring the persistence request for " + name));
            }
            return;
        }
        if (itemType == 7) {
            this.saveFullConfiguration(true);
            return;
        }
        PersistenceRequest request = new PersistenceRequest(name, itemType, true);
        request.registryOnly = true;
        LinkedList<PersistenceRequest> linkedList = this.requestQueue;
        synchronized (linkedList) {
            this.addToQueue(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteItemFromRegistry(String name, int itemType) {
        if (!this.initialized || !this.acceptRequests) {
            log.warn((Object)"Mediation persistence manager is either not initialized or not in the 'accepting' mode. Ignoring the delete request.");
            return;
        }
        if (this.registry == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registry persistence is disabled for mediation configuration. Ignoring the persistence request for " + name));
            }
            return;
        }
        if (itemType == 7) {
            return;
        }
        PersistenceRequest request = new PersistenceRequest(name, null, itemType, false);
        request.registryOnly = true;
        LinkedList<PersistenceRequest> linkedList = this.requestQueue;
        synchronized (linkedList) {
            this.addToQueue(request);
        }
    }

    private void addToQueue(PersistenceRequest request) {
        int i;
        boolean matchFound = false;
        for (i = 0; i < this.requestQueue.size(); ++i) {
            PersistenceRequest oldRequest = this.requestQueue.get(i);
            if (oldRequest.subjectType == 7) {
                return;
            }
            if (oldRequest.subjectType != request.subjectType || !oldRequest.subjectId.equals(request.subjectId)) continue;
            matchFound = true;
            break;
        }
        if (matchFound) {
            this.requestQueue.remove(i);
            this.requestQueue.add(i, request);
        } else {
            this.requestQueue.offer(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFullConfiguration(boolean registryOnly) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Received request to save full mediation configuration");
        }
        PersistenceRequest request = new PersistenceRequest(null, 7, true);
        request.registryOnly = registryOnly;
        LinkedList<PersistenceRequest> linkedList = this.requestQueue;
        synchronized (linkedList) {
            this.requestQueue.clear();
            this.requestQueue.offer(request);
        }
    }

    private void handleException(String msg, Throwable t) {
        log.error((Object)msg, t);
        throw new ServiceBusPersistenceException(msg, t);
    }

    private void persistElement(SynapseConfiguration config, PersistenceRequest request) {
        if (request.subjectType == 7) {
            this.saveFullConfiguration(config);
        } else {
            AbstractStore dataStore = this.dataStores.get(request.subjectType);
            dataStore.save(request.subjectId, config);
        }
    }

    private void deleteElement(SynapseConfiguration config, PersistenceRequest request) {
        AbstractStore dataStore = this.dataStores.get(request.subjectType);
        dataStore.delete(request.subjectId, request.fileName, config);
    }

    private void persistElementToRegistry(SynapseConfiguration config, PersistenceRequest request) {
        if (request.subjectType == 7) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Serializing full mediation configuration to the registry");
            }
            RegistryBasedSynapseConfigSerializer registrySerializer = new RegistryBasedSynapseConfigSerializer(this.registry, this.configName);
            registrySerializer.serializeConfiguration(config);
        } else {
            AbstractStore dataStore = this.dataStores.get(request.subjectType);
            dataStore.saveItemToRegistry(request.subjectId, config);
        }
    }

    private void deleteElementFromRegistry(PersistenceRequest request) {
        AbstractStore dataStore = this.dataStores.get(request.subjectType);
        dataStore.deleteItemFromRegistry(request.subjectId);
    }

    private void saveToFlatFile(SynapseConfiguration config) throws IOException, XMLStreamException {
        File outputFile = new File(this.configPath);
        if (!outputFile.exists()) {
            outputFile.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        XMLConfigurationSerializer.serializeConfiguration((SynapseConfiguration)config, (OutputStream)fos);
        fos.flush();
        fos.close();
    }

    private void saveFullConfiguration(SynapseConfiguration config) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Serializing full mediation configuration to the file system");
        }
        MultiXMLConfigurationSerializer serializer = new MultiXMLConfigurationSerializer(this.configPath);
        serializer.serialize(config);
        if (this.registry != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Serializing full mediation configuration to the registry");
            }
            RegistryBasedSynapseConfigSerializer registrySerializer = new RegistryBasedSynapseConfigSerializer(this.registry, this.configName);
            registrySerializer.serializeConfiguration(config);
        }
    }

    private class PersistenceRequest {
        private boolean save;
        private int subjectType;
        private String subjectId;
        private String fileName;
        private boolean registryOnly;

        public PersistenceRequest(String subjectId, int subjectType, boolean save) {
            this.save = save;
            this.subjectId = subjectId;
            this.subjectType = subjectType;
        }

        public PersistenceRequest(String subjectId, String fileName, int subjectType, boolean save) {
            this.save = save;
            this.subjectId = subjectId;
            this.subjectType = subjectType;
            this.fileName = fileName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersistenceRequest pr = (PersistenceRequest)o;
            return pr.subjectType == this.subjectType && pr.save == this.save && pr.subjectId.equals(this.subjectId);
        }

        public int hashCode() {
            int result = this.save ? 1 : 0;
            result = 31 * result + this.subjectType;
            result = 31 * result + (this.subjectId != null ? this.subjectId.hashCode() : 0);
            return result;
        }
    }

    private class MediationPersistenceWorker
    extends Thread {
        boolean proceed = true;

        private MediationPersistenceWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting the mediation persistence worker thread");
            }
            while (this.proceed) {
                PersistenceRequest request;
                LinkedList linkedList = MediationPersistenceManager.this.requestQueue;
                synchronized (linkedList) {
                    request = (PersistenceRequest)MediationPersistenceManager.this.requestQueue.poll();
                }
                if (request == null) {
                    try {
                        MediationPersistenceWorker.sleep(MediationPersistenceManager.this.interval);
                    }
                    catch (InterruptedException ignore) {}
                    continue;
                }
                try {
                    if (request.registryOnly && MediationPersistenceManager.this.registry != null) {
                        if (request.save) {
                            MediationPersistenceManager.this.persistElementToRegistry(MediationPersistenceManager.this.synapseConfiguration, request);
                            continue;
                        }
                        MediationPersistenceManager.this.deleteElementFromRegistry(request);
                        continue;
                    }
                    if (MediationPersistenceManager.this.flatFileMode) {
                        MediationPersistenceManager.this.saveToFlatFile(MediationPersistenceManager.this.synapseConfiguration);
                        continue;
                    }
                    if (request.save) {
                        MediationPersistenceManager.this.persistElement(MediationPersistenceManager.this.synapseConfiguration, request);
                        continue;
                    }
                    MediationPersistenceManager.this.deleteElement(MediationPersistenceManager.this.synapseConfiguration, request);
                }
                catch (Throwable t) {
                    log.error((Object)"Error while saving mediation configuration changes", t);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Stopping the mediation persistence worker thread");
            }
        }
    }
}

