/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal.topic.registry;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.internal.util.EventBrokerHolder;
import org.wso2.carbon.event.core.internal.util.JavaUtil;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.event.core.topic.TopicManager;
import org.wso2.carbon.event.core.topic.TopicNode;
import org.wso2.carbon.event.core.topic.TopicRolePermission;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;

public class RegistryTopicManager
implements TopicManager {
    private String topicStoragePath;
    private RegistryService registryService;

    public RegistryTopicManager(String topicStoragePath) {
        this.topicStoragePath = topicStoragePath;
        this.registryService = EventBrokerHolder.getInstance().getRegistryService();
    }

    @Override
    public TopicNode getTopicTree() throws EventBrokerException {
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            if (!userRegistry.resourceExists(this.topicStoragePath)) {
                userRegistry.put(this.topicStoragePath, (Resource)userRegistry.newCollection());
            }
            Resource root = userRegistry.get(this.topicStoragePath);
            TopicNode rootTopic = new TopicNode("/", "/");
            this.buildTopicTree(rootTopic, (Collection)root, userRegistry);
            return rootTopic;
        }
        catch (RegistryException e) {
            throw new EventBrokerException(e.getMessage(), e);
        }
    }

    private void buildTopicTree(TopicNode topicNode, Collection resource, UserRegistry userRegistry) throws EventBrokerException {
        try {
            String[] children = resource.getChildren();
            if (children != null) {
                ArrayList<TopicNode> nodes = new ArrayList<TopicNode>();
                for (String childTopic : children) {
                    String nodeName;
                    Resource childResource = userRegistry.get(childTopic);
                    if (!(childResource instanceof Collection)) continue;
                    if (childTopic.endsWith("/")) {
                        childTopic = childTopic.substring(0, childTopic.length() - 2);
                    }
                    if ((nodeName = childTopic.substring(childTopic.lastIndexOf("/") + 1)).equals("ws.subscriptions") || nodeName.equals("jms.subscriptions")) continue;
                    childTopic = childTopic.substring(childTopic.indexOf(this.topicStoragePath) + this.topicStoragePath.length() + 1);
                    TopicNode childNode = new TopicNode(nodeName, childTopic);
                    nodes.add(childNode);
                    this.buildTopicTree(childNode, (Collection)childResource, userRegistry);
                }
                topicNode.setChildren(nodes.toArray(new TopicNode[nodes.size()]));
            }
        }
        catch (RegistryException e) {
            throw new EventBrokerException(e.getMessage(), e);
        }
    }

    @Override
    public void addTopic(String topicName) throws EventBrokerException {
        if (!this.validateTopicName(topicName)) {
            throw new EventBrokerException("Topic name " + topicName + " is not a valid topic name. " + "Only alphanumeric characters, hyphens (-), stars(*)," + " hash(#) ,dot(.),question mark(?)" + " and underscores (_) are allowed.");
        }
        String loggedInUser = CarbonContext.getCurrentContext().getUsername();
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
            if (!userRegistry.resourceExists(resourcePath)) {
                Collection collection = userRegistry.newCollection();
                userRegistry.put(resourcePath, (Resource)collection);
                UserRealm userRealm = CarbonContext.getCurrentContext().getUserRealm();
                userRealm.getAuthorizationManager().authorizeUser(loggedInUser, resourcePath, "changePermission");
            }
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Can not access the config registry", e);
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Error while granting user " + loggedInUser + ", permission " + "changePermission" + ", on topic " + topicName, e);
        }
    }

    private String removeResourcePath(String topic) {
        String resourcePath = this.topicStoragePath;
        if (topic.indexOf(resourcePath) > -1) {
            topic = topic.substring(topic.indexOf(resourcePath) + resourcePath.length());
        }
        return topic;
    }

    @Override
    public TopicRolePermission[] getTopicRolePermission(String topicName) throws EventBrokerException {
        String topicResoucePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
        ArrayList<TopicRolePermission> topicRolePermissions = new ArrayList<TopicRolePermission>();
        UserRealm userRealm = CarbonContext.getCurrentContext().getUserRealm();
        String adminRole = EventBrokerHolder.getInstance().getRealmService().getBootstrapRealmConfiguration().getAdminRoleName();
        try {
            for (String role : userRealm.getUserStoreManager().getRoleNames()) {
                if (role.equals(adminRole) || "wso2.anonymous.role".equals(role)) continue;
                TopicRolePermission topicRolePermission = new TopicRolePermission();
                topicRolePermission.setRoleName(role);
                topicRolePermission.setAllowedToSubscribe(userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResoucePath, "subscribe"));
                topicRolePermission.setAllowedToPublish(userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResoucePath, "publish"));
                topicRolePermissions.add(topicRolePermission);
            }
            return topicRolePermissions.toArray(new TopicRolePermission[topicRolePermissions.size()]);
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Can not access the Userstore manager ", e);
        }
    }

    @Override
    public void updatePermissions(String topicName, TopicRolePermission[] topicRolePermissions) throws EventBrokerException {
        String topicResourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
        UserRealm userRealm = CarbonContext.getCurrentContext().getUserRealm();
        String loggedInUser = CarbonContext.getCurrentContext().getUsername();
        try {
            if (!userRealm.getAuthorizationManager().isUserAuthorized(loggedInUser, topicResourcePath, "changePermission") && !JavaUtil.isAdmin(loggedInUser)) {
                throw new EventBrokerException(" User " + loggedInUser + " can not change" + " the permissions of " + topicName);
            }
            for (TopicRolePermission topicRolePermission : topicRolePermissions) {
                String role = topicRolePermission.getRoleName();
                if (topicRolePermission.isAllowedToSubscribe()) {
                    if (!userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "subscribe")) {
                        userRealm.getAuthorizationManager().authorizeRole(role, topicResourcePath, "subscribe");
                    }
                } else if (userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "subscribe")) {
                    userRealm.getAuthorizationManager().denyRole(role, topicResourcePath, "subscribe");
                }
                if (topicRolePermission.isAllowedToPublish()) {
                    if (userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "publish")) continue;
                    userRealm.getAuthorizationManager().authorizeRole(role, topicResourcePath, "publish");
                    continue;
                }
                if (!userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "publish")) continue;
                userRealm.getAuthorizationManager().denyRole(role, topicResourcePath, "publish");
            }
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Can not access the user store manager", e);
        }
    }

    public String getTopicStoragePath() {
        return this.topicStoragePath;
    }

    public void setTopicStoragePath(String topicStoragePath) {
        this.topicStoragePath = topicStoragePath;
    }

    @Override
    public Subscription[] getSubscriptions(String topicName, boolean withChildren) throws EventBrokerException {
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        LinkedList<String> pathsQueue = new LinkedList<String>();
        String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
        pathsQueue.add(resourcePath);
        while (!pathsQueue.isEmpty()) {
            this.addSubscriptions((String)pathsQueue.remove(), subscriptions, pathsQueue, withChildren);
        }
        return subscriptions.toArray(new Subscription[subscriptions.size()]);
    }

    @Override
    public Subscription[] getJMSSubscriptions(String topicName) throws EventBrokerException {
        try {
            Subscription[] subscriptionsArray = new Subscription[]{};
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
            if (!resourcePath.endsWith("/")) {
                resourcePath = resourcePath + "/";
            }
            if (userRegistry.resourceExists(resourcePath = resourcePath + "jms.subscriptions")) {
                Collection subscriptionCollection = (Collection)userRegistry.get(resourcePath);
                subscriptionsArray = new Subscription[subscriptionCollection.getChildCount()];
                int index = 0;
                for (String subs : subscriptionCollection.getChildren()) {
                    Collection subscription = (Collection)userRegistry.get(subs);
                    Subscription subscriptionDetails = new Subscription();
                    subscriptionDetails.setId(subscription.getProperty("Name"));
                    subscriptionDetails.setOwner(subscription.getProperty("Owner"));
                    subscriptionDetails.setCreatedTime(ConverterUtil.convertToDate((String)subscription.getProperty("createdTime")));
                    subscriptionsArray[index++] = subscriptionDetails;
                }
            }
            return subscriptionsArray;
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Can not read the registry resouces ", e);
        }
    }

    private void addSubscriptions(String resourcePath, List<Subscription> subscriptions, Queue<String> pathsQueue, boolean withChildren) throws EventBrokerException {
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String subscriptionsPath = this.getSubscriptionsPath(resourcePath);
            if (userRegistry.resourceExists(subscriptionsPath)) {
                Collection collection = (Collection)userRegistry.get(subscriptionsPath);
                for (String subscriptionPath : collection.getChildren()) {
                    Resource subscriptionResource = userRegistry.get(subscriptionPath);
                    Subscription subscription = JavaUtil.getSubscription(subscriptionResource);
                    subscription.setTopicName(this.removeResourcePath(resourcePath));
                    if (subscriptionPath.endsWith("/")) {
                        subscriptionPath = subscriptionsPath.substring(0, subscriptionPath.lastIndexOf("/"));
                    }
                    subscription.setId(subscriptionPath.substring(subscriptionPath.lastIndexOf("/") + 1));
                    subscriptions.add(subscription);
                }
            }
            if (withChildren) {
                Collection childResouces = (Collection)userRegistry.get(resourcePath);
                for (String childResoucePath : childResouces.getChildren()) {
                    if (childResoucePath.indexOf("ws.subscriptions") >= 0 || childResoucePath.indexOf("jms.subscriptions") >= 0) continue;
                    pathsQueue.add(childResoucePath);
                }
            }
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Can not access the registry", e);
        }
    }

    private String getSubscriptionsPath(String topicName) {
        if (!topicName.endsWith("/")) {
            topicName = topicName + "/";
        }
        topicName = topicName + "ws.subscriptions";
        return topicName;
    }

    private boolean validateTopicName(String topicName) {
        String topicNameRegex = "([a-zA-Z0-9_\\-/#*.?&\\s])+";
        return Pattern.matches(topicNameRegex, topicName);
    }

    @Override
    public String[] getBackendRoles() throws EventBrokerException {
        UserRealm userRealm = CarbonContext.getCurrentContext().getUserRealm();
        try {
            String adminRole = EventBrokerHolder.getInstance().getRealmService().getBootstrapRealmConfiguration().getAdminRoleName();
            String[] allRoles = userRealm.getUserStoreManager().getRoleNames();
            if (allRoles != null && allRoles.length > 2) {
                String[] rolesExceptAdminRole = new String[allRoles.length - 2];
                int index = 0;
                for (String role : allRoles) {
                    if (role.equals(adminRole) || "wso2.anonymous.role".equals(role)) continue;
                    rolesExceptAdminRole[index] = role;
                    ++index;
                }
                return rolesExceptAdminRole;
            }
            return new String[0];
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Unable to getRoles from user store", e);
        }
    }

    @Override
    public boolean removeTopic(String topicName) throws EventBrokerException {
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
            if (userRegistry.resourceExists(resourcePath)) {
                userRegistry.delete(resourcePath);
                return true;
            }
            return false;
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Can not access the config registry");
        }
    }

    @Override
    public boolean isTopicExists(String topicName) throws EventBrokerException {
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
            return userRegistry.resourceExists(resourcePath);
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Can not access the config registry");
        }
    }
}

