/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal.delivery;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.event.core.Message;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.notify.NotificationManager;
import org.wso2.carbon.event.core.subscription.Subscription;

public class Worker
implements Runnable {
    private NotificationManager notificationManager;
    private Message message;
    private Subscription subscription;
    private static final Log log = LogFactory.getLog(Worker.class);

    public Worker(NotificationManager notificationManager, Message message, Subscription subscription) {
        this.notificationManager = notificationManager;
        this.message = message;
        this.subscription = subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(this.subscription.getTenantId());
            SuperTenantCarbonContext.getCurrentContext().setUsername(this.subscription.getOwner());
            SuperTenantCarbonContext.getCurrentContext().getTenantDomain(true);
            this.notificationManager.sendNotification(this.message, this.subscription);
        }
        catch (EventBrokerException e) {
            log.error((Object)"Can not send the notification ", (Throwable)e);
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }
}

