/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal.builder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.event.core.EventBundleNotificationService;
import org.wso2.carbon.event.core.exception.EventBrokerConfigurationException;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.internal.CarbonEventBroker;
import org.wso2.carbon.event.core.internal.builder.EventAxis2ConfigurationContextObserver;
import org.wso2.carbon.event.core.internal.builder.EventBrokerBuilder;
import org.wso2.carbon.event.core.internal.util.EventBrokerHolder;
import org.wso2.carbon.event.core.qpid.QpidServerDetails;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;

public class EventBrokerHandler
implements EventBundleNotificationService {
    private static final Log log = LogFactory.getLog(EventBrokerHandler.class);
    private ComponentContext context;
    private ServiceRegistration eventServiceRegistration;

    public EventBrokerHandler(ComponentContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEventBroker() {
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(-1234);
            SuperTenantCarbonContext.getCurrentContext().setUsername("wso2.system.user");
            EventBroker eventBroker = EventBrokerBuilder.createEventBroker();
            this.eventServiceRegistration = this.context.getBundleContext().registerService(EventBroker.class.getName(), (Object)eventBroker, null);
            EventAxis2ConfigurationContextObserver observer = new EventAxis2ConfigurationContextObserver();
            observer.setEventBroker(eventBroker);
            this.context.getBundleContext().registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)observer, null);
            if (log.isDebugEnabled()) {
                log.info((Object)"Successfully registered the event broker");
            }
        }
        catch (EventBrokerConfigurationException e) {
            log.error((Object)"Can not create the event broker", (Throwable)e);
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    public void stopEventBroker() {
        ServiceReference serviceReference = this.context.getBundleContext().getServiceReference(EventBroker.class.getName());
        CarbonEventBroker carbonEventBroker = (CarbonEventBroker)this.context.getBundleContext().getService(serviceReference);
        this.eventServiceRegistration.unregister();
        try {
            carbonEventBroker.cleanUp();
        }
        catch (EventBrokerException e) {
            log.error((Object)"Can not clean up the carbon broker ", (Throwable)e);
        }
    }

    @Override
    public void notifyStart(QpidServerDetails qpidServerDetails) {
        EventBrokerHolder.getInstance().registerQpidServerDetails(qpidServerDetails);
        this.startEventBroker();
    }
}

