/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.registry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMDocumentImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.registry.AbstractRegistry;
import org.apache.synapse.registry.RegistryEntry;
import org.apache.synapse.util.SynapseBinaryDataSource;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.mediation.registry.MediationRegistryEntryImpl;
import org.wso2.carbon.mediation.registry.RegistryExtension;
import org.wso2.carbon.mediation.registry.RegistryServiceHolder;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class WSO2Registry
extends AbstractRegistry {
    private static final Log log = LogFactory.getLog(WSO2Registry.class);
    public static final String CONFIG_REGISTRY_PREFIX = "conf:";
    public static final String GOVERNANCE_REGISTRY_PREFIX = "gov:";
    public static final String LOCAL_REGISTRY_PREFIX = "local:";
    private static final String EXPIRY_TIME = "expiryTime";
    private static final String CACHABLE_DURATION = "cachableDuration";
    private static final String EXTENSIONS = "extensions";
    private static final String ROOT = "root";
    private static final int MAX_KEYS = 200;
    private Registry configRegistry;
    private Registry localRegistry;
    private Registry governanceRegistry;
    private String rootPath;
    private List<RegistryExtension> extensions = new ArrayList<RegistryExtension>();

    public WSO2Registry() {
        RegistryService registryService = RegistryServiceHolder.getInstance().getRegistryService();
        try {
            this.configRegistry = registryService.getConfigSystemRegistry(CarbonContext.getCurrentContext().getTenantId());
            this.governanceRegistry = registryService.getGovernanceSystemRegistry(CarbonContext.getCurrentContext().getTenantId());
            this.localRegistry = registryService.getLocalRepository();
        }
        catch (RegistryException e) {
            this.handleException("Error while initializing the mediation registry adapter", (Exception)((Object)e));
        }
    }

    public void init(Properties properties) {
        super.init(properties);
        String root = properties.getProperty(ROOT);
        if (root == null || "".equals(root)) {
            this.rootPath = "/";
        } else {
            if (!root.startsWith("/")) {
                root = "/" + root;
            }
            if (!root.endsWith("/")) {
                root = root + "/";
            }
            this.rootPath = root;
        }
        String extensionsProperty = properties.getProperty(EXTENSIONS);
        if (extensionsProperty != null && !"".equals(extensionsProperty)) {
            String[] classNames;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initializing mediation registry extensions");
            }
            for (String className : classNames = extensionsProperty.split(",")) {
                this.registerExtension(className);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMNode lookup(String key) {
        if (key == null) {
            this.handleException("Resource cannot be found.");
        }
        if ("".equals(key)) {
            this.handleException("Resource cannot be empty");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("==> Repository fetch of resource with key : " + key));
        }
        try {
            Resource resource = this.getResource(key);
            if (resource instanceof Collection) {
                return null;
            }
            if (resource == null) {
                if (this.extensions.size() > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Attempting to fetch the resource from the engaged extensions");
                    }
                    for (RegistryExtension extension : this.extensions) {
                        OMNode result = extension.lookup(key);
                        if (result == null) continue;
                        return result;
                    }
                }
                return null;
            }
            ByteArrayInputStream inputStream = null;
            Object content = resource.getContent();
            if (content instanceof String) {
                inputStream = new ByteArrayInputStream(content.toString().getBytes());
            } else if (content instanceof byte[]) {
                inputStream = new ByteArrayInputStream((byte[])content);
            }
            OMNode result = null;
            try {
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                result = builder.getDocumentElement();
            }
            catch (OMException ignored) {
                result = this.readNonXML(resource);
            }
            catch (XMLStreamException ignored) {
                result = this.readNonXML(resource);
            }
            catch (Exception e) {
                log.error((Object)("Error while reading the resource '" + key + "'"), (Throwable)e);
            }
            finally {
                try {
                    resource.discard();
                    if (result != null && result.getParent() != null) {
                        result.detach();
                        OMDocumentImpl parent = new OMDocumentImpl(OMAbstractFactory.getOMFactory());
                        parent.addChild(result);
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing the input stream", (Throwable)e);
                }
            }
            return result;
        }
        catch (RegistryException e) {
            this.handleException("Error while fetching the resource " + key, (Exception)((Object)e));
            return null;
        }
    }

    public void delete(String key) {
        try {
            Registry registry = this.getRegistry(key);
            String resolvedPath = this.resolvePath(key);
            if (registry.resourceExists(resolvedPath)) {
                registry.delete(resolvedPath);
            }
        }
        catch (RegistryException e) {
            this.handleException("Error while deleting the resource at path :" + key, (Exception)((Object)e));
        }
    }

    public void newResource(String key, boolean isDirectory) {
        Registry registry = this.getRegistry(key);
        String resolvedKey = this.resolvePath(key);
        try {
            Object resource = isDirectory ? registry.newCollection() : registry.newResource();
            registry.put(resolvedKey, (Resource)resource);
        }
        catch (RegistryException e) {
            this.handleException("Error while saving a resource at " + key, (Exception)((Object)e));
        }
    }

    public void updateResource(String path, Object value) {
        Resource resource = this.getResource(path);
        if (resource != null) {
            Registry registry = this.getRegistry(path);
            if (value instanceof OMNode) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
                    ((OMNode)value).serialize(xmlStreamWriter);
                    resource.setContent((Object)baos.toByteArray());
                }
                catch (XMLStreamException e) {
                    this.handleException("Error when serializing OMNode " + value, e);
                }
                catch (RegistryException e) {
                    this.handleException("Error when setting content " + value, (Exception)((Object)e));
                }
            } else {
                try {
                    resource.setContent(value);
                }
                catch (RegistryException e) {
                    this.handleException("Error when setting content " + value, (Exception)((Object)e));
                }
            }
            try {
                registry.put(resource.getPath(), resource);
                resource.discard();
            }
            catch (RegistryException e) {
                this.handleException("Error when setting a resource in the path : " + path, (Exception)((Object)e));
            }
        }
    }

    public void updateRegistryEntry(RegistryEntry entry) {
        String key = entry.getKey();
        Resource resource = this.getResource(key);
        if (resource != null) {
            Registry registry = this.getRegistry(key);
            resource.setProperty(CACHABLE_DURATION, String.valueOf(entry.getCachableDuration()));
            resource.setProperty(EXPIRY_TIME, String.valueOf(System.currentTimeMillis() + entry.getCachableDuration()));
            try {
                registry.put(resource.getPath(), resource);
                resource.discard();
            }
            catch (RegistryException e) {
                this.handleException("Error when setting a resource in the path : " + key, (Exception)((Object)e));
            }
        }
    }

    public RegistryEntry getRegistryEntry(String entryKey) {
        MediationRegistryEntryImpl entry = new MediationRegistryEntryImpl();
        Resource resource = this.getResource(entryKey);
        if (resource != null) {
            entry.setKey(entryKey);
            entry.setName(resource.getPath());
            if (resource instanceof Collection) {
                entry.setType("http://wso2.org/projects/esb/registry/types/folder");
            } else {
                entry.setType("http://wso2.org/projects/esb/registry/types/file");
            }
            entry.setDescription("Resource at : " + resource.getPath());
            entry.setLastModified(resource.getLastModified().getTime());
            entry.setVersion(resource.getLastModified().getTime());
            long cacheTime = this.getCachableDuration();
            String cachableDuration = resource.getProperty(CACHABLE_DURATION);
            if (cachableDuration != null) {
                try {
                    cacheTime = Long.parseLong(cachableDuration);
                }
                catch (NumberFormatException e) {
                    this.handleException("Couldn't pass the cachableDuration as a long", e);
                }
            }
            entry.setCachableDuration(cacheTime);
        } else {
            entry.setKey(entryKey);
            entry.setCachableDuration(this.getCachableDuration());
        }
        return entry;
    }

    public RegistryEntry[] getChildren(RegistryEntry entry) {
        if (entry == null) {
            MediationRegistryEntryImpl registryEntry = new MediationRegistryEntryImpl();
            registryEntry.setKey(this.rootPath);
            entry = registryEntry;
        } else if ("".equals(entry.getKey())) {
            ((MediationRegistryEntryImpl)((Object)entry)).setKey(this.rootPath);
        }
        String parentPath = !entry.getKey().endsWith("/") ? entry.getKey() + "/" : entry.getKey();
        Resource resource = this.getResource(entry.getKey());
        if (resource == null) {
            return new RegistryEntry[]{new MediationRegistryEntryImpl()};
        }
        if (resource instanceof Collection) {
            CollectionImpl collection = (CollectionImpl)resource;
            String[] children = new String[]{};
            try {
                children = collection.getChildren();
            }
            catch (RegistryException e) {
                this.handleException("Error when retrieving children");
            }
            ArrayList<MediationRegistryEntryImpl> entryList = new ArrayList<MediationRegistryEntryImpl>();
            for (String child : children) {
                String key = child.endsWith("/") ? child.substring(0, child.length() - 1) : child;
                Resource childResource = this.getResource(key);
                if (childResource == null) continue;
                MediationRegistryEntryImpl registryEntryEmbedded = new MediationRegistryEntryImpl();
                registryEntryEmbedded.setKey(parentPath + RegistryUtils.getResourceName((String)key));
                if (childResource instanceof Collection) {
                    registryEntryEmbedded.setType("http://wso2.org/projects/esb/registry/types/folder");
                } else {
                    registryEntryEmbedded.setType("http://wso2.org/projects/esb/registry/types/file");
                }
                entryList.add(registryEntryEmbedded);
            }
            return entryList.toArray(new RegistryEntry[entryList.size()]);
        }
        ((MediationRegistryEntryImpl)((Object)entry)).setType("http://wso2.org/projects/esb/registry/types/file");
        return new RegistryEntry[]{entry};
    }

    public RegistryEntry[] getDescendants(RegistryEntry entry) {
        ArrayList<RegistryEntry> list = new ArrayList<RegistryEntry>();
        RegistryEntry[] entries = this.getChildren(entry);
        if (entries != null) {
            for (RegistryEntry currentEntry : entries) {
                if (list.size() > 200) break;
                this.fillDescendants(currentEntry, list);
            }
        }
        RegistryEntry[] descendants = new RegistryEntry[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            descendants[i] = (RegistryEntry)list.get(i);
        }
        return descendants;
    }

    private void fillDescendants(RegistryEntry parent, ArrayList<RegistryEntry> list) {
        RegistryEntry[] entries = this.getChildren(parent);
        if (entries != null) {
            for (RegistryEntry entry : entries) {
                if (list.size() <= 200) {
                    this.fillDescendants(entry, list);
                    continue;
                }
                break;
            }
        } else {
            list.add(parent);
        }
    }

    public Resource getResource(String path) {
        Registry registry = this.getRegistry(path);
        String key = this.resolvePath(path);
        try {
            if (registry.resourceExists(key)) {
                return registry.get(key);
            }
        }
        catch (RegistryException e) {
            this.handleException("Error while fetching the resource " + path, (Exception)((Object)e));
        }
        return null;
    }

    public Properties getResourceProperties(String entryKey) {
        Resource resource = this.getResource(entryKey);
        if (resource != null) {
            Properties properties = new Properties();
            Properties resourceProperties = resource.getProperties();
            if (resourceProperties != null) {
                for (Object key : resourceProperties.keySet()) {
                    Object value = resourceProperties.get(key);
                    if (value instanceof List) {
                        if (((List)value).size() <= 0) continue;
                        properties.put(key, ((List)value).get(0));
                        continue;
                    }
                    properties.put(key, value);
                }
            }
            return properties;
        }
        return null;
    }

    private Registry getRegistry(String path) {
        if (path == null || "".equals(path) || path.startsWith(GOVERNANCE_REGISTRY_PREFIX)) {
            return this.governanceRegistry;
        }
        if (path.startsWith(CONFIG_REGISTRY_PREFIX)) {
            return this.configRegistry;
        }
        if (path.startsWith(LOCAL_REGISTRY_PREFIX)) {
            return this.localRegistry;
        }
        return this.governanceRegistry;
    }

    private String resolvePath(String path) {
        if (path == null || "".equals(path)) {
            path = "/";
        }
        boolean governanceReg = false;
        if (path.startsWith(GOVERNANCE_REGISTRY_PREFIX)) {
            path = path.substring(GOVERNANCE_REGISTRY_PREFIX.length());
            governanceReg = true;
        } else if (path.startsWith(CONFIG_REGISTRY_PREFIX)) {
            path = path.substring(CONFIG_REGISTRY_PREFIX.length());
        } else if (path.startsWith(LOCAL_REGISTRY_PREFIX)) {
            path = path.substring(LOCAL_REGISTRY_PREFIX.length());
        } else {
            governanceReg = true;
        }
        if (governanceReg && this.rootPath != null) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            path = this.rootPath + path;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OMNode readNonXML(Resource resource) throws RegistryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"The resource at the specified path does not contain well-formed XML - Processing as text");
        }
        if (resource != null) {
            if (resource.getMediaType().equals("text/plain")) {
                return OMAbstractFactory.getOMFactory().createOMText(new String((byte[])resource.getContent()));
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])resource.getContent());
            try {
                OMFactory omFactory = OMAbstractFactory.getOMFactory();
                OMText oMText = omFactory.createOMText((Object)new DataHandler((DataSource)new SynapseBinaryDataSource((InputStream)inputStream, resource.getMediaType())), true);
                return oMText;
            }
            catch (IOException e) {
                this.handleException("Error while getting a stream from resource content ", e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing the input stream", (Throwable)e);
                }
            }
        }
        return null;
    }

    private void registerExtension(String className) {
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className.trim());
            RegistryExtension ext = (RegistryExtension)clazz.newInstance();
            ext.init(this.properties);
            this.extensions.add(ext);
        }
        catch (Exception e) {
            this.handleException("Error while instantiating the registry extension class : " + className, e);
        }
    }

    private long getCachableDuration() {
        String cachableDuration = (String)this.properties.get(CACHABLE_DURATION);
        return cachableDuration == null ? 0L : Long.parseLong(cachableDuration);
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

