/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.registry;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.mediation.registry.RegistryServiceHolder;
import org.wso2.carbon.mediation.registry.persistence.PersistenceManager;
import org.wso2.carbon.mediation.registry.services.SynapseRegistryService;
import org.wso2.carbon.mediation.registry.services.SynapseRegistryServiceImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;

public class SynapseRegistryServiceComponent {
    private static Log log = LogFactory.getLog(SynapseRegistryServiceComponent.class);

    protected void activate(ComponentContext ctxt) {
        ctxt.getBundleContext().registerService(SynapseRegistryService.class.getName(), (Object)new SynapseRegistryServiceImpl(), (Dictionary)new Properties());
    }

    protected void deactivate(ComponentContext ctxt) {
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the SynapseRegistry initialization process");
        }
        RegistryServiceHolder.getInstance().setRegistryService(registryService);
        try {
            PersistenceManager.getInstance().setRegistry((Registry)registryService.getConfigSystemRegistry());
        }
        catch (RegistryException e) {
            log.error((Object)"Error while accessing the registry", (Throwable)e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the SynapseRegistry");
        }
        RegistryServiceHolder.getInstance().setRegistryService(null);
        PersistenceManager.getInstance().setRegistry(null);
    }
}

