/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.registry;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMDocumentImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.registry.AbstractRegistry;
import org.apache.synapse.registry.RegistryEntry;
import org.wso2.carbon.mediation.registry.MediationRegistryEntryImpl;
import org.wso2.carbon.mediation.registry.RegistryHelper;
import org.wso2.carbon.mediation.registry.persistence.PersistenceManager;
import org.wso2.carbon.mediation.registry.persistence.dataobject.RegistryEntryDO;

public class ESBRegistry
extends AbstractRegistry {
    public static final int FILE = 100;
    public static final int HTTP = 101;
    public static final int HTTPS = 102;
    public static final String URL_SEPARATOR = "/";
    public static final char URL_SEPARATOR_CHAR = '/';
    private static final int DELETE_RETRY_SLEEP_TIME = 10;
    private static final long DEFAULT_CACHABLE_DURATION = 0L;
    private static final Log log = LogFactory.getLog(ESBRegistry.class);
    private static final int MAX_KEYS = 200;
    private String localRegistry = RegistryHelper.getHome();
    private String metaDataService = null;
    private int registryType = 100;
    private int registryProtocol = 100;

    public void init(Properties properties) {
        super.init(properties);
        for (Object o : properties.keySet()) {
            if (o == null) continue;
            String name = (String)o;
            String value = (String)properties.get(name);
            this.addConfigProperty(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMNode lookup(String key) {
        URLConnection urlc;
        if (log.isDebugEnabled()) {
            log.info((Object)("==> Repository fetch of resource with key : " + key));
        }
        URL url = null;
        try {
            url = new URL(this.getRoot() + key);
        }
        catch (MalformedURLException e) {
            this.handleException("Invalid path '" + this.getRoot() + key + "' for URL", e);
        }
        if ("file".equals(url.getProtocol())) {
            try {
                url.openStream();
            }
            catch (IOException ignored) {
                if (!this.localRegistry.endsWith(URL_SEPARATOR)) {
                    this.localRegistry = this.localRegistry + URL_SEPARATOR;
                }
                try {
                    url = new URL(url.getProtocol() + ":" + this.localRegistry + key);
                }
                catch (MalformedURLException e) {
                    this.handleException("Invalid path '" + url.getProtocol() + ":" + this.localRegistry + key + "' for URL", e);
                }
                try {
                    url.openStream();
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
        try {
            urlc = url.openConnection();
            urlc.connect();
        }
        catch (IOException e) {
            return null;
        }
        InputStream input = null;
        try {
            input = urlc.getInputStream();
        }
        catch (IOException e) {
            this.handleException("Error when getting a stream from the URL", e);
        }
        if (input == null) {
            return null;
        }
        BufferedInputStream inputStream = new BufferedInputStream(input);
        OMElement result = null;
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            result = builder.getDocumentElement();
        }
        catch (OMException ignored) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The resource at the provided URL isn't well-formed XML,So,takes it as a text");
            }
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Error in closing the input stream. ", (Throwable)e);
            }
            result = SynapseConfigUtils.readNonXML((URL)url);
        }
        catch (XMLStreamException ignored) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The resource at the provided URL isn't well-formed XML,So,takes it as a text");
            }
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Error in closing the input stream. ", (Throwable)e);
            }
            result = SynapseConfigUtils.readNonXML((URL)url);
        }
        finally {
            try {
                result.detach();
                OMDocumentImpl parent = new OMDocumentImpl(OMAbstractFactory.getOMFactory());
                parent.addChild((OMNode)result);
                inputStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Error in closing the input stream.", (Throwable)e);
            }
        }
        return result;
    }

    public RegistryEntry getRegistryEntry(String key) {
        MediationRegistryEntryImpl entryEmbedded = new MediationRegistryEntryImpl();
        try {
            URL url = new URL(this.getRoot() + key);
            if ("file".equals(url.getProtocol())) {
                try {
                    url.openStream();
                }
                catch (IOException ignored) {
                    if (!this.localRegistry.endsWith(URL_SEPARATOR)) {
                        this.localRegistry = this.localRegistry + URL_SEPARATOR;
                    }
                    url = new URL(url.getProtocol() + ":" + this.localRegistry + key);
                    try {
                        url.openStream();
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            }
            URLConnection urlc = url.openConnection();
            entryEmbedded.setKey(key);
            entryEmbedded.setName(url.getFile());
            entryEmbedded.setType("http://wso2.org/projects/esb/registry/types/file");
            entryEmbedded.setDescription("Resource at : " + url.toString());
            entryEmbedded.setLastModified(urlc.getLastModified());
            entryEmbedded.setVersion(urlc.getLastModified());
            if (urlc.getExpiration() > 0L) {
                entryEmbedded.setCachableDuration(urlc.getExpiration() - System.currentTimeMillis());
            } else {
                entryEmbedded.setCachableDuration(this.getCachableDuration());
            }
        }
        catch (MalformedURLException e) {
            this.handleException("Invalid URL reference " + this.getRoot() + key, e);
        }
        catch (IOException e) {
            this.handleException("IO Error reading from URL " + this.getRoot() + key, e);
        }
        PersistenceManager persistenceManager = PersistenceManager.getInstance();
        RegistryEntryDO registryEntryDO = persistenceManager.getRegistryEntry(key);
        if (registryEntryDO != null) {
            if (registryEntryDO.getExpiryTime() != null) {
                entryEmbedded.setCachableDuration(registryEntryDO.getExpiryTime());
            } else {
                entryEmbedded.setCachableDuration(0L);
            }
        }
        return entryEmbedded;
    }

    public void updateRegistryEntry(RegistryEntry entry) {
        RegistryEntryDO registryEntryDO = new RegistryEntryDO();
        registryEntryDO.setRegistryKey(entry.getKey());
        registryEntryDO.setExpiryTime(entry.getCachableDuration());
        PersistenceManager persistenceManager = PersistenceManager.getInstance();
        persistenceManager.saveOrUpdateRegistryEntry(registryEntryDO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResource(String key, Object value) {
        if (this.registryType == 100) {
            File file = new File(this.localRegistry + RegistryHelper.getSystemDependentPath(key));
            if (file.exists()) {
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(new FileWriter(file));
                    writer.write(value.toString());
                    writer.flush();
                }
                catch (IOException e) {
                    this.handleException("Couldn't write to registry entry: " + key, e);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
        } else {
            this.handleException("Remote registry is not supported.");
        }
    }

    private void addResource(String parentName, String resourceName, boolean isLeaf) throws Exception {
        if (this.registryType == 100) {
            if (isLeaf) {
                this.createFile(RegistryHelper.getSystemDependentPath(parentName), resourceName);
            } else {
                this.createFolder(RegistryHelper.getSystemDependentPath(parentName), resourceName);
            }
        }
    }

    private void removeResource(String key) {
        if (this.registryType == 100) {
            File resource = new File(this.localRegistry + RegistryHelper.getSystemDependentPath(key));
            if (resource.exists()) {
                if (resource.isFile()) {
                    this.deleteFile(resource);
                } else if (resource.isDirectory()) {
                    this.deleteDirectory(resource);
                }
            } else {
                throw new SynapseException("Parent folder: " + key + " does not exists.");
            }
        }
    }

    private String getRegsitryKey(File file) {
        String path = file.getAbsolutePath();
        String rootPath = new File(this.localRegistry).getAbsolutePath();
        return this.getURLPath(path.substring(rootPath.length() + 1));
    }

    private void deleteFile(File file) {
        boolean success = file.delete();
        if (!success) {
            System.gc();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            success = file.delete();
            if (!success) {
                File renamedFile;
                int suffix = 1;
                File tempDir = new File("temp");
                if (!tempDir.exists()) {
                    tempDir.mkdir();
                }
                do {
                    String changedName = "d" + suffix + file.getName();
                    renamedFile = new File(tempDir, changedName);
                    ++suffix;
                } while (renamedFile.exists());
                if (file.renameTo(renamedFile)) {
                    renamedFile.deleteOnExit();
                } else {
                    this.handleException("Cannot delete the resource: " + file.getName());
                }
            }
        }
        PersistenceManager persistenceManager = PersistenceManager.getInstance();
        persistenceManager.deleteRegistryEntry(this.getRegsitryKey(file));
    }

    private void deleteDirectory(File dir) {
        File[] children;
        for (File aChildren : children = dir.listFiles()) {
            if (aChildren == null) continue;
            if (aChildren.isFile()) {
                this.deleteFile(aChildren);
                continue;
            }
            if (!aChildren.isDirectory()) continue;
            this.deleteDirectory(aChildren);
        }
        boolean success = dir.delete();
        if (success) {
            PersistenceManager persistenceManager = PersistenceManager.getInstance();
            persistenceManager.deleteRegistryEntry(this.getRegsitryKey(dir));
        } else {
            this.handleException("Cannot delete the resource: " + dir.getName());
        }
    }

    private void createFolder(String parentName, String newFolderName) throws Exception {
        if (this.registryType == 100) {
            File parent = new File(this.localRegistry + parentName);
            if (parent.exists()) {
                File newEntry = new File(parent, newFolderName);
                boolean success = newEntry.mkdir();
                if (!success) {
                    this.handleException("Couldn't create folder: " + newFolderName);
                }
                RegistryEntryDO registryEntryDO = new RegistryEntryDO();
                registryEntryDO.setRegistryKey(parentName + URL_SEPARATOR + newFolderName);
                PersistenceManager persistenceManager = PersistenceManager.getInstance();
                RegistryEntryDO parentEntryDO = persistenceManager.getRegistryEntry(this.getURLPath(parentName));
                if (parentEntryDO != null) {
                    registryEntryDO.setExpiryTime(parentEntryDO.getExpiryTime());
                } else {
                    registryEntryDO.setExpiryTime(this.getCachableDuration());
                }
                persistenceManager.addRegistryEntry(registryEntryDO);
            } else {
                this.handleException("Parent folder: " + parentName + " does not exists.");
            }
        }
    }

    private void createFile(String parentName, String newFileName) throws Exception {
        if (this.registryType == 100) {
            File parent = new File(this.localRegistry + parentName);
            if (parent.exists()) {
                File newFile = new File(parent, newFileName);
                boolean success = newFile.createNewFile();
                if (!success) {
                    this.handleException("Couldn't create resource: " + newFileName);
                }
                RegistryEntryDO registryEntryDO = new RegistryEntryDO();
                registryEntryDO.setRegistryKey(parentName + URL_SEPARATOR + newFileName);
                PersistenceManager persistenceManager = PersistenceManager.getInstance();
                RegistryEntryDO parentEntryDO = persistenceManager.getRegistryEntry(this.getURLPath(parentName));
                if (parentEntryDO != null) {
                    registryEntryDO.setExpiryTime(parentEntryDO.getExpiryTime());
                } else {
                    registryEntryDO.setExpiryTime(this.getCachableDuration());
                }
                persistenceManager.addRegistryEntry(registryEntryDO);
            } else {
                this.handleException("Parent folder: " + parentName + " does not exists.");
            }
        }
    }

    private void addConfigProperty(String name, String value) {
        if (this.localRegistry == null) {
            this.localRegistry = "registry/".endsWith(URL_SEPARATOR) ? "registry/" : "registry//";
        }
        if (name != null && value != null) {
            if (name.equals("root")) {
                try {
                    URL url = new URL(value);
                    if ("file".equals(url.getProtocol())) {
                        try {
                            url.openStream();
                        }
                        catch (IOException ignored) {
                            if (!this.localRegistry.endsWith(URL_SEPARATOR)) {
                                this.localRegistry = this.localRegistry + URL_SEPARATOR;
                            }
                            url = new URL(url.getProtocol() + ":" + this.localRegistry + url.getPath());
                            try {
                                url.openStream();
                            }
                            catch (IOException e) {
                                log.error((Object)("Unable to open a connection to url : " + url), (Throwable)e);
                            }
                        }
                    }
                    if (url.getProtocol().equals("file")) {
                        this.registryProtocol = 100;
                        this.registryType = 100;
                        this.localRegistry = url.getPath().endsWith(URL_SEPARATOR) ? RegistryHelper.getSystemDependentPath(url.getPath()) : RegistryHelper.getSystemDependentPath(url.getPath()) + File.separator;
                    } else if (url.getProtocol().equals("http")) {
                        this.registryProtocol = 101;
                    } else if (url.getProtocol().equals("https")) {
                        this.registryProtocol = 102;
                    }
                    if (!value.endsWith(URL_SEPARATOR)) {
                        value = value + URL_SEPARATOR;
                    }
                }
                catch (MalformedURLException e) {
                    this.handleException("Registry root should be a valid URL.", e);
                }
            }
            if (name.equals("localRegistry")) {
                this.registryType = 100;
                if (!value.endsWith(File.separator)) {
                    value = value + File.separator;
                }
                this.localRegistry = value;
            }
            if (name.equals("matadataService")) {
                this.registryType = 101;
                this.metaDataService = value;
            }
            if (name.equalsIgnoreCase("disableHostNameVerification") && value.equalsIgnoreCase("true")) {
                HostnameVerifier hv = new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        return true;
                    }
                };
                HttpsURLConnection.setDefaultHostnameVerifier(hv);
            }
        } else {
            log.debug((Object)"Name and Value must need");
        }
    }

    public String getRoot() {
        String root = (String)this.properties.get("root");
        if (root == null) {
            return "";
        }
        return root;
    }

    public long getCachableDuration() {
        String cachableDuration = (String)this.properties.get("cachableDuration");
        return cachableDuration == null ? 0L : Long.parseLong(cachableDuration);
    }

    public RegistryEntry[] getChildren(RegistryEntry entry) {
        String registryRoot = this.localRegistry;
        if (entry == null) {
            MediationRegistryEntryImpl registryEntry = new MediationRegistryEntryImpl();
            registryEntry.setKey("");
            entry = registryEntry;
        }
        if (this.registryType == 100) {
            String entryPath = RegistryHelper.getSystemDependentPath(entry.getKey());
            File file = new File(registryRoot + entryPath);
            if (!file.isDirectory()) {
                return null;
            }
            try {
                String[] children = file.list();
                RegistryEntry[] entries = new RegistryEntry[children.length];
                for (int i = 0; i < children.length; ++i) {
                    MediationRegistryEntryImpl registryEntry = new MediationRegistryEntryImpl();
                    if (entry.getKey().equals("")) {
                        registryEntry.setKey(children[i]);
                    } else if (entryPath.endsWith(URL_SEPARATOR)) {
                        registryEntry.setKey(this.getURLPath(entry.getKey() + children[i]));
                    } else {
                        registryEntry.setKey(this.getURLPath(entry.getKey() + URL_SEPARATOR + children[i]));
                    }
                    File entryFile = new File(registryRoot + RegistryHelper.getSystemDependentPath(registryEntry.getKey()));
                    if (entryFile.isDirectory()) {
                        registryEntry.setType("http://wso2.org/projects/esb/registry/types/folder");
                    }
                    entries[i] = registryEntry;
                }
                return entries;
            }
            catch (Exception e) {
                this.handleException("Error in reading the URL.");
            }
        } else if (this.registryType == 101) {
            // empty if block
        }
        return null;
    }

    public RegistryEntry[] getDescendants(RegistryEntry entry) {
        ArrayList<RegistryEntry> list = new ArrayList<RegistryEntry>();
        RegistryEntry[] entries = this.getChildren(entry);
        if (entries != null) {
            for (RegistryEntry entry1 : entries) {
                if (list.size() > 200) break;
                this.fillDescendants(entry1, list);
            }
        }
        RegistryEntry[] descendants = new RegistryEntry[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            descendants[i] = (RegistryEntry)list.get(i);
        }
        return descendants;
    }

    public void delete(String path) {
        this.removeResource(path);
    }

    public void newResource(String path, boolean isDirectory) {
        String parent = this.getParentPath(path);
        String fileName = this.getResourceName(path);
        try {
            this.addResource(parent, fileName, !isDirectory);
        }
        catch (Exception e) {
            this.handleException("Error when adding a new resource", e);
        }
    }

    private void fillDescendants(RegistryEntry parent, ArrayList<RegistryEntry> list) {
        RegistryEntry[] entries = this.getChildren(parent);
        if (entries != null) {
            for (RegistryEntry entry : entries) {
                if (list.size() <= 200) {
                    this.fillDescendants(entry, list);
                    continue;
                }
                break;
            }
        } else {
            list.add(parent);
        }
    }

    private String getURLPath(String filePath) {
        return filePath.replace(File.separatorChar, '/');
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private String getParentPath(String resourcePath) {
        String parentPath = resourcePath.equals(URL_SEPARATOR) ? null : (resourcePath.lastIndexOf(URL_SEPARATOR) == 0 ? URL_SEPARATOR : resourcePath.substring(0, resourcePath.lastIndexOf(URL_SEPARATOR)));
        return parentPath;
    }

    private String getResourceName(String path) {
        if (path != null) {
            String correctedPath = path;
            if (path.endsWith(URL_SEPARATOR)) {
                correctedPath = path.substring(0, path.lastIndexOf(URL_SEPARATOR));
            }
            return correctedPath.substring(correctedPath.lastIndexOf(URL_SEPARATOR) + 1, correctedPath.length());
        }
        return "";
    }
}

