/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.dependency.mgt.services;

import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.SynapseObserver;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.mediation.dependency.mgt.DependencyTracker;
import org.wso2.carbon.mediation.dependency.mgt.services.ConfigurationTrackingService;
import org.wso2.carbon.mediation.dependency.mgt.services.DependencyManagementService;
import org.wso2.carbon.mediation.dependency.mgt.services.DependencyManagementServiceImpl;

public class ConfigurationTrackingServiceImpl
implements ConfigurationTrackingService {
    private final Log log = LogFactory.getLog(this.getClass());
    private BundleContext bndCtx;
    private DependencyManagementServiceImpl mgtService = new DependencyManagementServiceImpl();
    private boolean serviceRegistered = false;

    public ConfigurationTrackingServiceImpl(BundleContext bndCtx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Initializing ConfigurationTrackingService");
        }
        this.bndCtx = bndCtx;
    }

    @Override
    public void setSynapseConfiguration(SynapseConfiguration synCfg) {
        int tenantId = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)synCfg.getAxisConfiguration()).getTenantId();
        List observers = synCfg.getObservers();
        for (SynapseObserver o : observers) {
            if (!(o instanceof DependencyTracker)) continue;
            DependencyTracker tracker = (DependencyTracker)o;
            this.mgtService.setDependencyTracker(tenantId, tracker);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Dependency tracker found for the tenant: " + tenantId));
            }
            if (this.serviceRegistered) break;
            this.bndCtx.registerService(DependencyManagementService.class.getName(), (Object)this.mgtService, (Dictionary)new Properties());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"DependencyManagementService registered and ready to be used");
            }
            this.serviceRegistered = true;
            break;
        }
    }
}

