/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.dependency.mgt.services;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.mediation.dependency.mgt.ConfigurationObject;
import org.wso2.carbon.mediation.dependency.mgt.DependencyTracker;
import org.wso2.carbon.mediation.dependency.mgt.services.DependencyManagementService;

public class DependencyManagementServiceImpl
implements DependencyManagementService {
    private Map<Integer, DependencyTracker> trackers = new HashMap<Integer, DependencyTracker>();

    public DependencyManagementServiceImpl() {
    }

    public DependencyManagementServiceImpl(DependencyTracker tracker) {
        this.trackers.put(-1234, tracker);
    }

    protected synchronized void setDependencyTracker(int tenantId, DependencyTracker tracker) {
        this.trackers.put(tenantId, tracker);
    }

    @Override
    public boolean hasDependents(int tenantId, int type, String key) {
        DependencyTracker tracker = this.trackers.get(tenantId);
        return tracker != null && tracker.hasDependents(type, key);
    }

    @Override
    public boolean hasActiveDependents(int tenantId, int type, String key) {
        DependencyTracker tracker = this.trackers.get(tenantId);
        return tracker != null && tracker.hasActiveDependents(type, key);
    }

    @Override
    public ConfigurationObject[] getDependents(int tenantId, int type, String key) {
        ConfigurationObject[] dependents;
        DependencyTracker tracker = this.trackers.get(tenantId);
        if (tracker != null && (dependents = tracker.getDependents(type, key)) != null) {
            return (ConfigurationObject[])dependents.clone();
        }
        return null;
    }

    @Override
    public boolean hasDependents(int type, String key) {
        return this.hasDependents(-1234, type, key);
    }

    @Override
    public boolean hasActiveDependents(int type, String key) {
        return this.hasActiveDependents(-1234, type, key);
    }

    @Override
    public ConfigurationObject[] getDependents(int type, String key) {
        return this.getDependents(-1234, type, key);
    }
}

