/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.dependency.mgt;

import java.util.List;
import org.apache.synapse.Mediator;
import org.apache.synapse.Startup;
import org.apache.synapse.config.AbstractSynapseObserver;
import org.apache.synapse.config.Entry;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.IndirectEndpoint;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.wso2.carbon.mediation.dependency.mgt.ConfigurationObject;
import org.wso2.carbon.mediation.dependency.mgt.DependencyGraph;
import org.wso2.carbon.mediation.dependency.mgt.DependencyResolver;
import org.wso2.carbon.mediation.dependency.mgt.DependencyResolverFactory;

public class DependencyTracker
extends AbstractSynapseObserver {
    private DependencyGraph dependencyGraph = new DependencyGraph();

    public DependencyTracker() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Synapse configuration dependency tracker initialized...");
        }
    }

    public void entryAdded(Entry entry) {
        ConfigurationObject entryObject = this.findEntry(entry.getKey());
        if (entryObject == null) {
            entryObject = new ConfigurationObject(3, entry.getKey());
            this.dependencyGraph.add(entryObject);
        } else if (entryObject.getType() == 6) {
            this.dependencyGraph.resolveObject(entryObject, 3);
        }
    }

    public void entryRemoved(Entry entry) {
        this.dependencyGraph.remove(3, entry.getKey());
    }

    public void sequenceAdded(Mediator sequence) {
        if (!(sequence instanceof SequenceMediator)) {
            return;
        }
        SequenceMediator seqMediator = (SequenceMediator)sequence;
        ConfigurationObject seqObject = this.findSequence(seqMediator.getName());
        if (seqObject == null) {
            seqObject = new ConfigurationObject(1, seqMediator.getName());
            this.dependencyGraph.add(seqObject);
        } else if (seqObject.getType() == 6) {
            this.dependencyGraph.resolveObject(seqObject, 1);
        }
        this.resolveSequenceMediator(seqMediator, seqObject, true);
    }

    public void endpointAdded(Endpoint endpoint) {
        if (endpoint instanceof IndirectEndpoint) {
            return;
        }
        ConfigurationObject endpointObject = this.findEndpoint(endpoint.getName());
        if (endpointObject == null) {
            endpointObject = new ConfigurationObject(0, endpoint.getName());
            this.dependencyGraph.add(endpointObject);
        } else if (endpointObject.getType() == 6) {
            this.dependencyGraph.resolveObject(endpointObject, 0);
        }
        this.resolveEndpoint(endpoint, endpointObject);
    }

    public void endpointRemoved(Endpoint endpoint) {
        this.dependencyGraph.remove(0, endpoint.getName());
    }

    public void proxyServiceAdded(ProxyService proxyService) {
        ConfigurationObject proxyObject = new ConfigurationObject(2, proxyService.getName());
        this.dependencyGraph.add(proxyObject);
        this.resolveProxyService(proxyService, proxyObject);
    }

    public void proxyServiceRemoved(ProxyService proxy) {
        this.dependencyGraph.remove(2, proxy.getName());
    }

    public boolean hasDependents(int type, String id) {
        ConfigurationObject configObj = this.dependencyGraph.find(type, id);
        return configObj != null && this.dependencyGraph.hasDependents(configObj);
    }

    public boolean hasActiveDependents(int type, String id) {
        ConfigurationObject configObj = this.dependencyGraph.find(type, id);
        return configObj != null && this.dependencyGraph.hasActiveDependents(configObj);
    }

    public ConfigurationObject[] getDependents(int type, String id) {
        ConfigurationObject configObj = this.dependencyGraph.find(type, id);
        if (configObj != null) {
            return this.dependencyGraph.getDependents(configObj);
        }
        return null;
    }

    private ConfigurationObject findEndpoint(String key) {
        ConfigurationObject endpoint = this.dependencyGraph.find(0, key);
        if (endpoint != null) {
            return endpoint;
        }
        endpoint = this.dependencyGraph.find(3, key);
        if (endpoint != null) {
            return endpoint;
        }
        return this.dependencyGraph.find(6, key);
    }

    private ConfigurationObject findSequence(String key) {
        ConfigurationObject sequence = this.dependencyGraph.find(1, key);
        if (sequence != null) {
            return sequence;
        }
        sequence = this.dependencyGraph.find(3, key);
        if (sequence != null) {
            return sequence;
        }
        return this.dependencyGraph.find(6, key);
    }

    private ConfigurationObject findEntry(String key) {
        ConfigurationObject entry = this.dependencyGraph.find(3, key);
        if (entry != null) {
            return entry;
        }
        return this.dependencyGraph.find(6, key);
    }

    private ConfigurationObject createUnknownObject(String key) {
        ConfigurationObject unknownObject = new ConfigurationObject(6, key);
        this.dependencyGraph.add(unknownObject);
        return unknownObject;
    }

    private void resolveProxyService(ProxyService proxyService, ConfigurationObject dependentObject) {
        if (proxyService.getTargetEndpoint() != null) {
            ConfigurationObject endpointObject = this.findEndpoint(proxyService.getTargetEndpoint());
            if (endpointObject == null) {
                endpointObject = this.createUnknownObject(proxyService.getTargetEndpoint());
            }
            this.dependencyGraph.createEdge(endpointObject, dependentObject);
        } else if (proxyService.getTargetInLineEndpoint() instanceof IndirectEndpoint) {
            IndirectEndpoint indirectEndpoint = (IndirectEndpoint)proxyService.getTargetInLineEndpoint();
            ConfigurationObject endpointObject = this.findEndpoint(indirectEndpoint.getKey());
            if (endpointObject == null) {
                endpointObject = this.createUnknownObject(indirectEndpoint.getKey());
            }
            this.dependencyGraph.createEdge(endpointObject, dependentObject);
        }
        if (proxyService.getTargetInSequence() != null) {
            ConfigurationObject inSeqObject = this.findSequence(proxyService.getTargetInSequence());
            if (inSeqObject == null) {
                inSeqObject = this.createUnknownObject(proxyService.getTargetInSequence());
            }
            this.dependencyGraph.createEdge(inSeqObject, dependentObject);
        } else if (proxyService.getTargetInLineInSequence() != null) {
            this.resolveSequenceMediator(proxyService.getTargetInLineInSequence(), dependentObject, false);
        }
        if (proxyService.getTargetOutSequence() != null) {
            ConfigurationObject outSeqObject = this.findSequence(proxyService.getTargetOutSequence());
            if (outSeqObject == null) {
                outSeqObject = this.createUnknownObject(proxyService.getTargetOutSequence());
            }
            this.dependencyGraph.createEdge(outSeqObject, dependentObject);
        } else if (proxyService.getTargetInLineOutSequence() != null) {
            this.resolveSequenceMediator(proxyService.getTargetInLineOutSequence(), dependentObject, false);
        }
        if (proxyService.getTargetFaultSequence() != null) {
            ConfigurationObject faultSeqObject = this.findSequence(proxyService.getTargetFaultSequence());
            if (faultSeqObject == null) {
                faultSeqObject = this.createUnknownObject(proxyService.getTargetFaultSequence());
            }
            this.dependencyGraph.createEdge(faultSeqObject, dependentObject);
        } else if (proxyService.getTargetInLineFaultSequence() != null) {
            this.resolveSequenceMediator(proxyService.getTargetInLineFaultSequence(), dependentObject, false);
        }
        if (proxyService.getWSDLKey() != null) {
            ConfigurationObject wsdlObject = this.findEntry(proxyService.getWSDLKey());
            if (wsdlObject == null) {
                wsdlObject = this.createUnknownObject(proxyService.getWSDLKey());
            }
            this.dependencyGraph.createEdge(wsdlObject, dependentObject);
        }
    }

    private void resolveSequenceMediator(SequenceMediator sequence, ConfigurationObject dependentObject, boolean reset) {
        DependencyResolver resolver;
        List<ConfigurationObject> providers;
        if (reset) {
            this.dependencyGraph.removeDependencies(dependentObject);
        }
        if ((providers = (resolver = DependencyResolverFactory.getInstance().getResolver((Mediator)sequence)).resolve((Mediator)sequence)) != null) {
            for (ConfigurationObject o : providers) {
                ConfigurationObject provider = null;
                switch (o.getType()) {
                    case 0: {
                        provider = this.findEndpoint(o.getId());
                        break;
                    }
                    case 1: {
                        provider = this.findSequence(o.getId());
                        break;
                    }
                    case 3: {
                        provider = this.findEntry(o.getId());
                    }
                }
                if (provider == null) {
                    provider = this.createUnknownObject(o.getId());
                }
                this.dependencyGraph.createEdge(provider, dependentObject);
            }
        }
    }

    private void resolveEndpoint(Endpoint endpoint, ConfigurationObject dependentObject) {
        if (!(endpoint instanceof AbstractEndpoint)) {
            return;
        }
        AbstractEndpoint abstractEndpoint = (AbstractEndpoint)endpoint;
        EndpointDefinition def = abstractEndpoint.getDefinition();
        if (def == null) {
            return;
        }
        this.dependencyGraph.removeDependencies(dependentObject);
        this.resolveEntry(def.getWsSecPolicyKey(), dependentObject);
        this.resolveEntry(def.getWsRMPolicyKey(), dependentObject);
        this.resolveEntry(def.getInboundWsSecPolicyKey(), dependentObject);
        this.resolveEntry(def.getOutboundWsSecPolicyKey(), dependentObject);
        List children = abstractEndpoint.getChildren();
        if (children != null) {
            for (Endpoint child : children) {
                if (!(child instanceof IndirectEndpoint)) continue;
                String key = ((IndirectEndpoint)child).getKey();
                ConfigurationObject childEndpoint = this.findEndpoint(key);
                if (childEndpoint == null) {
                    childEndpoint = this.createUnknownObject(key);
                }
                this.dependencyGraph.createEdge(childEndpoint, dependentObject);
            }
        }
    }

    private void resolveEntry(String entryKey, ConfigurationObject dependentObject) {
        if (entryKey == null) {
            return;
        }
        this.dependencyGraph.removeDependencies(dependentObject);
        ConfigurationObject entryObject = this.findEntry(entryKey);
        if (entryObject == null) {
            entryObject = this.createUnknownObject(entryKey);
        }
        this.dependencyGraph.createEdge(entryObject, dependentObject);
    }

    public void eventSourceAdded(SynapseEventSource eventSource) {
    }

    public void eventSourceRemoved(SynapseEventSource eventSource) {
    }

    public void sequenceRemoved(Mediator sequence) {
        if (sequence instanceof SequenceMediator) {
            this.dependencyGraph.remove(1, ((SequenceMediator)sequence).getName());
        }
    }

    public void startupAdded(Startup startup) {
    }

    public void startupRemoved(Startup startup) {
    }
}

