/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.artifactuploader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.mediation.artifactuploader.util.SynapseArtifactUploaderUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class SynapseArtifactUploaderAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(SynapseArtifactUploaderAdmin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadArtifact(String fileName, DataHandler dataHandler) throws AxisFault {
        File artifactDir = new File(this.getExtensionRepoPath());
        File tempDir = new File(CarbonUtils.getCarbonHome() + File.separator + "tmp");
        File destinationTempFile = new File(tempDir, fileName);
        FileOutputStream fos = null;
        try {
            fos = FileUtils.openOutputStream((File)destinationTempFile);
            dataHandler.writeTo((OutputStream)fos);
        }
        catch (IOException e) {
            this.handleException("File Upload failed", e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)("Unable to close file " + destinationTempFile.getAbsolutePath()), (Throwable)e);
            }
        }
        try {
            FileUtils.copyFileToDirectory((File)destinationTempFile, (File)artifactDir, (boolean)true);
            FileUtils.deleteQuietly((File)destinationTempFile);
        }
        catch (IOException e) {
            this.handleException("Unable to move file to artifact directory :" + artifactDir.getAbsolutePath(), e);
        }
        return true;
    }

    public String[] getArtifacts() {
        return SynapseArtifactUploaderUtil.getArtifacts(this.getExtensionRepoPath());
    }

    public boolean removeArtifact(String fileName) throws AxisFault {
        File artifactFile = new File(this.getExtensionRepoPath() + File.separator + fileName);
        if (artifactFile.exists() && artifactFile.isFile()) {
            return artifactFile.delete();
        }
        this.handleException("Artifact " + artifactFile.getAbsolutePath() + " not found");
        return false;
    }

    private String getExtensionRepoPath() {
        return this.getAxisConfig().getRepository().getFile() + File.separator + "extensions";
    }

    private void handleException(String msg, Throwable e) throws AxisFault {
        log.error((Object)msg, e);
        throw new AxisFault(msg, e);
    }

    private void handleException(String msg) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg);
    }
}

