/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.artifactuploader.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.artifactuploader.stub.SynapseArtifactUploaderAdminStub;

public class SynapseArtifactUploaderClient {
    private static final Log log = LogFactory.getLog(SynapseArtifactUploaderClient.class);
    public SynapseArtifactUploaderAdminStub stub;

    public SynapseArtifactUploaderClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "SynapseArtifactUploaderAdmin";
        this.stub = new SynapseArtifactUploaderAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        option.setProperty("enableMTOM", (Object)"true");
    }

    public boolean uploadArtifact(String fileName, DataHandler dataHandler) throws AxisFault {
        try {
            this.stub.uploadArtifact(fileName, dataHandler);
        }
        catch (RemoteException ex) {
            this.handleException("Cannot Upload Artifact", ex);
        }
        return true;
    }

    public String[] getArtifacts() throws AxisFault {
        try {
            return this.stub.getArtifacts();
        }
        catch (RemoteException e) {
            this.handleException("Unable to retrieve artifact List", e);
            return new String[0];
        }
    }

    private void handleException(String msg, Exception ex) throws AxisFault {
        log.error((Object)msg, (Throwable)ex);
        throw new AxisFault(msg, (Throwable)ex);
    }

    public boolean removeArtifact(String fileName) throws AxisFault {
        try {
            return this.stub.removeArtifact(fileName);
        }
        catch (RemoteException e) {
            this.handleException("Unable to remove artifact", e);
            return false;
        }
    }
}

