/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.scriptengine.cache.ScriptCachingContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class MashupUtils {
    private static Log log = LogFactory.getLog(MashupUtils.class);

    public static int executeHTTPMethod(HttpMethod method, URL targetURL, String username, String password) throws IOException {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpClient httpClient = new HttpClient((HttpConnectionManager)connectionManager);
        method.setPath(targetURL.getPath());
        method.setQueryString(targetURL.getQuery());
        method.setRequestHeader("Host", targetURL.getHost());
        method.getParams().setCookiePolicy("ignoreCookies");
        if (username != null && password != null) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
            int port = targetURL.getPort();
            httpClient.getState().setCredentials(new AuthScope(targetURL.getHost(), port), (Credentials)creds);
        }
        return httpClient.executeMethod(method);
    }

    public static ScriptCachingContext getScriptCachingContext(ConfigurationContext configurationContext, AxisService service) {
        String tenantId = Integer.toString(MultitenantUtils.getTenantId((ConfigurationContext)configurationContext));
        String scriptPath = (String)service.getParameterValue("ServiceJS");
        ScriptCachingContext sctx = new ScriptCachingContext(tenantId, "/", "/", scriptPath);
        sctx.setSourceModifiedTime(service.getLastUpdate());
        return sctx;
    }

    public static ScriptCachingContext getScriptCachingContext(ConfigurationContext configurationContext, String scriptPath, long lastModified) {
        String tenantId = Integer.toString(MultitenantUtils.getTenantId((ConfigurationContext)configurationContext));
        ScriptCachingContext sctx = new ScriptCachingContext(tenantId, "/", "/", scriptPath);
        sctx.setSourceModifiedTime(lastModified);
        return sctx;
    }

    public static Reader readJS(AxisService service) throws AxisFault {
        InputStream jsFileStream = null;
        Parameter implInfoParam = service.getParameter("ServiceJS");
        if (implInfoParam == null) {
            throw new AxisFault("Parameter 'ServiceJS' not specified");
        }
        Object value = implInfoParam.getValue();
        jsFileStream = new ByteArrayInputStream(((String)service.getParameter("serviceJsStream").getValue()).getBytes());
        if (jsFileStream == null) {
            if (value instanceof String) {
                try {
                    String path = (String)value;
                    String latter = path.split(File.separator + "repository")[1];
                    path = CarbonUtils.getCarbonHome() + File.separator + "repository" + latter;
                    jsFileStream = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    throw new AxisFault("Unable to load the javaScript, File not Found", (Throwable)e);
                }
            } else {
                jsFileStream = service.getClassLoader().getResourceAsStream(implInfoParam.getValue().toString());
            }
        }
        if (jsFileStream == null) {
            throw new AxisFault("Unable to load the javaScript");
        }
        return new BufferedReader(new InputStreamReader(jsFileStream));
    }

    public static String getImportScriptsList(AxisService service) {
        String scripts = null;
        Parameter param = service.getParameter("loadJSScripts");
        if (param != null) {
            scripts = (String)param.getValue();
        }
        if ((param = service.getParameter("loadJSScripts")) != null) {
            if (scripts == null) {
                scripts = (String)param.getValue();
            } else if (!scripts.equals(param.getValue())) {
                scripts = scripts + "," + param.getValue();
            }
        }
        return scripts;
    }

    public static void writeFile(CarbonHttpResponse response, File file) throws CarbonException {
        String filePath = file.getAbsolutePath();
        if (!filePath.contains(CarbonUtils.getCarbonHome().concat(File.separator))) {
            String latter = filePath.split(File.separator + "repository")[1];
            filePath = CarbonUtils.getCarbonHome() + File.separator + "repository" + latter;
            file = new File(filePath);
        }
        response.addHeader("Content-Length", Integer.toString((int)file.length()));
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            fileInputStream = new FileInputStream(file);
            do {
                int len;
                byte[] buffer = new byte[4000];
                while ((len = fileInputStream.read(buffer)) > 0) {
                    outputStream.write(buffer, 0, len);
                }
            } while (fileInputStream.available() > 0);
            outputStream.flush();
        }
        catch (FileNotFoundException e) {
            throw new CarbonException("File " + file.getName() + " cannot be found", (Throwable)e);
        }
        catch (IOException e) {
            throw new CarbonException((Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Error closing the stream", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Error closing the stream", (Throwable)e);
                }
            }
        }
    }

    public static void writeFile(HttpServletResponse response, File file) throws CarbonException {
        String filePath = file.getAbsolutePath();
        if (!filePath.contains(CarbonUtils.getCarbonHome().concat(File.separator))) {
            String latter = filePath.split(File.separator + "repository")[1];
            filePath = CarbonUtils.getCarbonHome() + File.separator + "repository" + latter;
            file = new File(filePath);
        }
        response.setContentLength((int)file.length());
        FileInputStream fileInputStream = null;
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            fileInputStream = new FileInputStream(file);
            do {
                int len;
                byte[] buffer = new byte[4000];
                while ((len = fileInputStream.read(buffer)) > 0) {
                    outputStream.write(buffer, 0, len);
                }
            } while (fileInputStream.available() > 0);
            outputStream.flush();
        }
        catch (FileNotFoundException e) {
            throw new CarbonException("File " + file.getName() + " cannot be found", (Throwable)e);
        }
        catch (IOException e) {
            throw new CarbonException((Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Error closing the stream", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Error closing the stream", (Throwable)e);
                }
            }
        }
    }

    public static String filterUsername(String username) {
        String filteredUsername = username.replace('@', '_');
        return filteredUsername;
    }
}

