/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.request.processors.template;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;
import org.wso2.carbon.wsdl2form.Util;

public class TemplateRequestProcessor
implements HttpGetRequestProcessor {
    private static Log log = LogFactory.getLog(TemplateRequestProcessor.class);
    public static final String TEMPLATE_XSL_LOCATION = "/org/wso2/carbon/mashup/request/processors/template/";

    public void process(CarbonHttpRequest request, CarbonHttpResponse response, ConfigurationContext configurationContext) throws Exception {
        try {
            String requestURI = request.getRequestURI();
            String contextPath = configurationContext.getServiceContextPath();
            String serviceName = requestURI.substring(requestURI.indexOf(contextPath) + contextPath.length() + 1);
            AxisConfiguration configuration = configurationContext.getAxisConfiguration();
            AxisService axisService = configuration.getServiceForActivation(serviceName);
            if (axisService == null) {
                axisService = TenantAxisUtils.getAxisService((String)serviceName, (ConfigurationContext)configurationContext);
            }
            OutputStream outputStream = response.getOutputStream();
            if (axisService != null) {
                String contentTypeParameter;
                String langParameter;
                InputStream templateStream;
                if (!axisService.isActive()) {
                    response.setStatus(404);
                    response.addHeader("Content-Type", "text/html");
                    outputStream.write(("<h4>Service " + serviceName + " is inactive. Cannot generate API Documentation.</h4>").getBytes());
                    outputStream.flush();
                    return;
                }
                DOMSource xmlSource = Util.getSigStream((AxisService)axisService, null);
                String flavorParameter = request.getParameter("flavor");
                if (flavorParameter != null && !"".equals(flavorParameter)) {
                    if (!flavorParameter.equalsIgnoreCase("gadget") && !flavorParameter.equalsIgnoreCase("html")) {
                        response.setError(404);
                        response.addHeader("Content-Type", "text/html; charset=utf-8");
                        outputStream.write(("<h4>Unsupported template flavor parameter " + flavorParameter + "</h4>").getBytes());
                        return;
                    }
                } else {
                    flavorParameter = "html";
                }
                if ((templateStream = this.getClass().getClassLoader().getResourceAsStream("/org/wso2/carbon/mashup/request/processors/template/template-" + flavorParameter + ".xslt")) == null) {
                    response.setStatus(404);
                    response.addHeader("Content-Type", "text/html; charset=utf-8");
                    outputStream.write("<h4>Cannot find the stylesheet</h4>".getBytes());
                    return;
                }
                StreamSource xsltSource = new StreamSource(templateStream);
                StreamResult result = new StreamResult(outputStream);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                transformerFactory.setURIResolver(new TemplateURIResolver());
                Transformer transformer = transformerFactory.newTransformer(xsltSource);
                String serviceParameter = request.getParameter("service");
                if (serviceParameter != null && !"".equals(serviceParameter)) {
                    transformer.setParameter("service", serviceParameter);
                }
                if (!((langParameter = request.getParameter("lang")) == null || langParameter.equals("") || langParameter.equalsIgnoreCase("javascript") || langParameter.equalsIgnoreCase("ecmascript") || langParameter.equalsIgnoreCase("js"))) {
                    if (langParameter.equalsIgnoreCase("e4x")) {
                        transformer.setParameter("e4x", "true");
                    } else {
                        response.setError(404);
                        response.addHeader("Content-Type", "text/html; charset=utf-8");
                        outputStream.write(("<h4>Unsupported lang parameter " + langParameter + "</h4>").getBytes());
                        return;
                    }
                }
                String contentType = (contentTypeParameter = request.getParameter("content-type")) != null && !"".equals(contentTypeParameter.trim()) ? contentTypeParameter : ("html".equals(flavorParameter) ? "text/html" : "application/xml");
                response.addHeader("Content-Type", contentType + "; charset=utf-8");
                String localhostParameter = request.getParameter("localhost");
                if ("true".equals(localhostParameter)) {
                    transformer.setParameter("localhost-endpoints", "true");
                }
                transformer.setParameter("wsrequest-location", "?wsdl2form&type=js&resource=WSRequest.js");
                transformer.setParameter("stub-location", "../../" + axisService.getName() + "?stub");
                transformer.transform(xmlSource, result);
            } else {
                response.addHeader("Content-Type", "text/html");
                response.setStatus(404);
                outputStream.write("<h4>Service cannot be found. Cannot display <em>API Documentation</em>.</h4>".getBytes());
                outputStream.flush();
            }
        }
        catch (OMException e) {
            log.error((Object)e);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private class TemplateURIResolver
    implements URIResolver {
        TemplateURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) {
            InputStream is = TemplateURIResolver.class.getResourceAsStream(href);
            return new StreamSource(is);
        }
    }
}

