/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.request.processors.gadget;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;
import org.wso2.carbon.wsdl2form.Util;

public class GadgetRequestProcessor
implements HttpGetRequestProcessor {
    private static Log log = LogFactory.getLog(GadgetRequestProcessor.class);
    public static final String GADGET_XSL_LOCATION = "org/wso2/carbon/mashup/request/processors/gadget/xslt/gadget.xslt";

    public void process(CarbonHttpRequest request, CarbonHttpResponse response, ConfigurationContext configurationContext) throws Exception {
        try {
            String requestURI = request.getRequestURI();
            String contextPath = configurationContext.getServiceContextPath();
            String serviceName = requestURI.substring(requestURI.indexOf(contextPath) + contextPath.length() + 1);
            AxisConfiguration configuration = configurationContext.getAxisConfiguration();
            AxisService axisService = configuration.getServiceForActivation(serviceName);
            if (axisService == null) {
                axisService = TenantAxisUtils.getAxisService((String)serviceName, (ConfigurationContext)configurationContext);
            }
            OutputStream outputStream = response.getOutputStream();
            if (axisService == null) {
                response.addHeader("Content-Type", "text/html");
                response.setStatus(404);
                outputStream.write("<h4>Service cannot be found. Cannot display <em>Gadget</em>.</h4>".getBytes());
                outputStream.flush();
                return;
            }
            if (!axisService.isActive()) {
                response.addHeader("Content-Type", "text/html");
                response.setStatus(404);
                outputStream.write(("<h4>Service " + serviceName + " is inactive. Cannot display <em>Gadget</em>.</h4>").getBytes());
                outputStream.flush();
                return;
            }
            DOMSource xmlSource = Util.getSigStream((AxisService)axisService, null);
            StreamResult result = new StreamResult(response.getOutputStream());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("wsrequest-location", "../../carbon/admin/js/WSRequest.js");
            paramMap.put("stub-location", "?stub");
            this.generateGadget(xmlSource, result, paramMap);
        }
        catch (OMException e) {
            log.error((Object)e);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void generateGadget(Source xmlIn, Result result, Map paramMap) throws TransformerException {
        InputStream gadgetXSLTStream = GadgetRequestProcessor.class.getClassLoader().getResourceAsStream(GADGET_XSL_LOCATION);
        StreamSource gadgetXSLSource = new StreamSource(gadgetXSLTStream);
        Util.transform((Source)xmlIn, (Source)gadgetXSLSource, (Result)result, (Map)paramMap, (URIResolver)new GadgetURIResolver());
    }

    private class GadgetURIResolver
    implements URIResolver {
        private GadgetURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) {
            InputStream is = Util.class.getResourceAsStream(href);
            return new StreamSource(is);
        }
    }
}

