/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.request.processors.doc;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;
import org.wso2.carbon.wsdl2form.Util;

public class DocRequestProcessor
implements HttpGetRequestProcessor {
    private static Log log = LogFactory.getLog(DocRequestProcessor.class);
    public static final String DOC_XSL_LOCATION = "/org/wso2/carbon/mashup/request/processors/doc/doc.xslt";

    public void process(CarbonHttpRequest request, CarbonHttpResponse response, ConfigurationContext configurationContext) throws Exception {
        try {
            String requestURI = request.getRequestURI();
            String contextPath = configurationContext.getServiceContextPath();
            String serviceName = requestURI.substring(requestURI.indexOf(contextPath) + contextPath.length() + 1);
            AxisConfiguration configuration = configurationContext.getAxisConfiguration();
            AxisService axisService = configuration.getServiceForActivation(serviceName);
            if (axisService == null) {
                axisService = TenantAxisUtils.getAxisService((String)serviceName, (ConfigurationContext)configurationContext);
            }
            OutputStream outputStream = response.getOutputStream();
            if (axisService != null) {
                if (!axisService.isActive()) {
                    response.setStatus(404);
                    response.addHeader("Content-Type", "text/html");
                    outputStream.write(("<h4>Service " + serviceName + " is inactive. Cannot generate API Documentation.</h4>").getBytes());
                    outputStream.flush();
                    return;
                }
                DOMSource xmlSource = Util.getSigStream((AxisService)axisService, null);
                InputStream stubStream = this.getClass().getClassLoader().getResourceAsStream(DOC_XSL_LOCATION);
                if (stubStream == null) {
                    response.setStatus(404);
                    response.addHeader("Content-Type", "text/html; charset=utf-8");
                    outputStream.write("<h4>Cannot find the stylesheet</h4>".getBytes());
                    return;
                }
                StreamSource xsltSource = new StreamSource(stubStream);
                StreamResult result = new StreamResult(response.getOutputStream());
                Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
                String serviceParameter = request.getParameter("service");
                if (serviceParameter != null && !"".equals(serviceParameter)) {
                    transformer.setParameter("service", serviceParameter);
                }
                response.addHeader("Content-Type", "text/html");
                transformer.setParameter("image-path", "../../doc_request_processor/images/");
                transformer.transform(xmlSource, result);
            } else {
                response.addHeader("Content-Type", "text/html");
                response.setStatus(404);
                outputStream.write("<h4>Service cannot be found. Cannot display <em>API Documentation</em>.</h4>".getBytes());
                outputStream.flush();
            }
        }
        catch (OMException e) {
            log.error((Object)e);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

