/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.jsservices.custom.ui;

import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.OMException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.util.MIMEType2FileExtensionMap;
import org.wso2.carbon.mashup.jsservices.custom.ui.internal.CustomUIServiceComponent;
import org.wso2.carbon.mashup.utils.MashupUtils;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class CustomUIServletFilter
implements Filter {
    private static Log log = LogFactory.getLog(CustomUIServletFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (httpServletRequest.getMethod().equalsIgnoreCase("get") && httpServletRequest.getQueryString() == null) {
            String contextRoot = CustomUIServiceComponent.getCarbonContextRoot();
            if (!contextRoot.endsWith("/")) {
                contextRoot = contextRoot + "/";
            }
            String serviceRoot = CustomUIServiceComponent.getConfigurationContext().getServicePath();
            String fullRoot = contextRoot + serviceRoot;
            String requestURI = ((HttpServletRequest)request).getRequestURI();
            if (requestURI.startsWith(fullRoot, 0)) {
                String servicePath = requestURI.substring(fullRoot.length());
                int tIndex = servicePath.indexOf("/t/");
                String requestPath = servicePath;
                String tenant = null;
                if (tIndex != -1) {
                    tenant = MultitenantUtils.getTenantDomainFromRequestURL((String)servicePath);
                    requestPath = servicePath.substring(tIndex + tenant.length() + 4);
                } else {
                    requestPath = requestPath.substring(1);
                }
                String[] requestParts = requestPath.split("/");
                if (requestParts.length >= 2) {
                    AxisService axisService;
                    String serviceName = requestParts[0] + "/" + requestParts[1];
                    if (tenant != null) {
                        Parameter ghostParam;
                        axisService = TenantAxisUtils.getTenantAxisConfiguration((String)tenant, (ConfigurationContext)CustomUIServiceComponent.getConfigurationContext()).getServiceForActivation(serviceName);
                        if (axisService != null && (ghostParam = axisService.getParameter("GhostService")) != null && "true".equals(ghostParam.getValue())) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Request is heading to a ghost service. Deploying the actual service.");
                            }
                            axisService = GhostDeployerUtils.deployActualService((AxisConfiguration)TenantAxisUtils.getTenantAxisConfiguration((String)tenant, (ConfigurationContext)CustomUIServiceComponent.getConfigurationContext()), (AxisService)axisService);
                        }
                    } else {
                        axisService = CustomUIServiceComponent.getConfigurationContext().getAxisConfiguration().getServiceForActivation(serviceName);
                    }
                    if (axisService != null && "js_service".equals(axisService.getParameterValue("serviceType"))) {
                        if (!axisService.isActive()) {
                            ServletOutputStream outputStream = httpServletResponse.getOutputStream();
                            httpServletResponse.setContentType("text/html");
                            httpServletResponse.setStatus(503);
                            outputStream.write(("<h4>Service " + serviceName + " is inactive. Cannot display <em>web resources</em>.</h4>").getBytes());
                            outputStream.flush();
                            return;
                        }
                        int indexOfDot = requestPath.lastIndexOf(".");
                        boolean isFile = false;
                        try {
                            File file;
                            if (indexOfDot != -1) {
                                String endpointName;
                                int indexOfSlash;
                                String subString = requestPath.substring(indexOfDot);
                                isFile = subString.matches("\\.(.)*");
                                if (requestPath.length() > indexOfDot + 1 && (indexOfSlash = subString.indexOf("/")) != -1 && axisService.getEndpoint(endpointName = subString.substring(1, indexOfSlash)) != null) {
                                    isFile = subString.substring(indexOfDot + 1).matches("\\.(.)*");
                                }
                            }
                            Object resourceFolderObject = axisService.getParameterValue("ResourcesFolder");
                            File serviceResourceFolder = null;
                            if (resourceFolderObject != null && resourceFolderObject instanceof File) {
                                serviceResourceFolder = (File)resourceFolderObject;
                            }
                            if (requestPath.equals(serviceName + "/")) {
                                if (serviceResourceFolder != null) {
                                    serviceResourceFolder = (File)resourceFolderObject;
                                    file = new File(serviceResourceFolder + "/www/" + "index.html");
                                    if (!file.exists()) {
                                        file = new File(serviceResourceFolder + "/www/" + "index.htm");
                                    }
                                    if (file.exists()) {
                                        response.setContentType("text/html");
                                        MashupUtils.writeFile((HttpServletResponse)httpServletResponse, (File)file);
                                        return;
                                    }
                                }
                                requestURI = requestURI.substring(0, requestURI.length() - 1);
                                httpServletResponse.sendRedirect(requestURI + "?tryit");
                                return;
                            }
                            if (requestPath.equals(serviceName)) {
                                httpServletResponse.sendRedirect(requestURI + "/");
                                return;
                            }
                            if (isFile) {
                                if (serviceResourceFolder != null) {
                                    serviceResourceFolder = (File)resourceFolderObject;
                                    String subPath = requestPath.substring(requestPath.indexOf(serviceName) + serviceName.length() + 1);
                                    file = new File(serviceResourceFolder.getAbsolutePath() + "/www/" + subPath);
                                    if (file.exists()) {
                                        MIMEType2FileExtensionMap map = CustomUIServiceComponent.getExtensionMap();
                                        if (map != null) {
                                            response.setContentType(map.getMIMEType(file));
                                        }
                                        MashupUtils.writeFile((HttpServletResponse)httpServletResponse, (File)file);
                                        return;
                                    }
                                }
                                httpServletResponse.sendError(404);
                                return;
                            }
                        }
                        catch (OMException e) {
                            log.error((Object)e);
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                }
            }
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }
}

