/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.javascript.messagereceiver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.types.Day;
import org.apache.axis2.databinding.types.Duration;
import org.apache.axis2.databinding.types.Month;
import org.apache.axis2.databinding.types.MonthDay;
import org.apache.axis2.databinding.types.Time;
import org.apache.axis2.databinding.types.Year;
import org.apache.axis2.databinding.types.YearMonth;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.json.JSONOMBuilder;
import org.apache.axis2.receivers.AbstractInOutMessageReceiver;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.wso2.carbon.mashup.javascript.messagereceiver.JSToOMConverter;
import org.wso2.carbon.mashup.javascript.messagereceiver.JavaScriptEngine;
import org.wso2.carbon.mashup.javascript.messagereceiver.JavaScriptEngineUtils;
import org.wso2.carbon.mashup.utils.MashupUtils;
import org.wso2.javascript.xmlimpl.XML;
import org.wso2.javascript.xmlimpl.XMLList;

public class JavaScriptReceiver
extends AbstractInOutMessageReceiver
implements MessageReceiver {
    public void invokeBusinessLogic(MessageContext inMessage, MessageContext outMessage) throws AxisFault {
        SOAPEnvelope soapEnvelope = inMessage.getEnvelope();
        try {
            OMText textPayLoad;
            Object[] payload;
            RhinoEngine.enterContext();
            String serviceName = inMessage.getAxisService().getName();
            JavaScriptEngine engine = new JavaScriptEngine(serviceName);
            AxisService axisService = inMessage.getAxisService();
            ConfigurationContext configurationContext = inMessage.getConfigurationContext();
            JavaScriptEngineUtils.setActiveScope(JavaScriptEngineUtils.getEngine().getRuntimeScope());
            RhinoEngine.putContextProperty((Object)"messageContext", (Object)inMessage);
            RhinoEngine.putContextProperty((Object)"axisService", (Object)axisService);
            RhinoEngine.putContextProperty((Object)"axisConfigurationContext", (Object)configurationContext);
            JavaScriptEngineUtils.initialize();
            URL repoURL = inMessage.getConfigurationContext().getAxisConfiguration().getRepository();
            if (repoURL != null) {
                JavaScriptEngine.axis2RepositoryLocation = repoURL.getPath();
            }
            Reader reader = MashupUtils.readJS((AxisService)inMessage.getServiceContext().getAxisService());
            String jsFunctionName = this.inferJavaScriptFunctionName(inMessage);
            String scripts = this.getImportScriptsList(inMessage);
            Object[] args = payload = soapEnvelope.getBody().getFirstElement();
            if (payload != null) {
                AxisMessage axisMessage = inMessage.getAxisOperation().getMessage("In");
                XmlSchemaElement xmlSchemaElement = axisMessage.getSchemaElement();
                if (xmlSchemaElement != null) {
                    XmlSchemaType schemaType = xmlSchemaElement.getSchemaType();
                    if (schemaType instanceof XmlSchemaComplexType) {
                        XmlSchemaComplexType complexType = (XmlSchemaComplexType)schemaType;
                        List params = this.handleComplexTypeInRequest(complexType, (OMElement)payload, engine, new ArrayList());
                        args = params.toArray();
                    } else if (xmlSchemaElement.getSchemaTypeName() == Constants.XSD_ANYTYPE) {
                        args = payload;
                    }
                }
            } else if (soapEnvelope.getBody().getFirstOMChild() != null && (textPayLoad = (OMText)soapEnvelope.getBody().getFirstOMChild()).getText().trim().length() > 0) {
                throw new AxisFault("Non-XML payload is not allowed. PayLoad inside the SOAP body needs to be an XML element.");
            }
            AxisMessage outAxisMessage = inMessage.getAxisOperation().getMessage("Out");
            boolean annotated = false;
            Parameter parameter = outAxisMessage.getParameter("annotated");
            if (parameter != null) {
                annotated = (Boolean)parameter.getValue();
            }
            Object response = engine.call(jsFunctionName, axisService, args, scripts);
            SOAPFactory fac = inMessage.isSOAP11() ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
            SOAPEnvelope envelope = fac.getDefaultEnvelope();
            SOAPBody body = envelope.getBody();
            XmlSchemaElement xmlSchemaElement = outAxisMessage.getSchemaElement();
            String prefix = "ws";
            if (xmlSchemaElement != null) {
                OMElement element;
                QName elementQName = xmlSchemaElement.getSchemaTypeName();
                OMNamespace namespace = fac.createOMNamespace(elementQName.getNamespaceURI(), prefix);
                OMElement outElement = fac.createOMElement(xmlSchemaElement.getName(), namespace);
                XmlSchemaType schemaType = xmlSchemaElement.getSchemaType();
                if (schemaType instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType = (XmlSchemaComplexType)schemaType;
                    this.handleComplexTypeInResponse(complexType, outElement, response, (OMFactory)fac, engine.isJson(), false);
                    body.addChild((OMNode)outElement);
                } else if (xmlSchemaElement.getSchemaTypeName() == Constants.XSD_ANYTYPE && !JavaScriptEngine.isNull(response) && (element = this.buildResponse(false, engine.isJson(), response, xmlSchemaElement)) != null) {
                    body.addChild((OMNode)element);
                }
            } else if (!JavaScriptEngine.isNull(response)) {
                OMElement element;
                String contentType = (String)inMessage.getProperty("messageType");
                if (engine.isJson()) {
                    if (response instanceof XML) {
                        element = (OMElement)((XML)response).getAxiomFromXML();
                    } else if (response instanceof XMLList) {
                        OMFactory omFactory = OMAbstractFactory.getOMFactory();
                        element = omFactory.createOMElement("return", null);
                        XMLList list = (XMLList)response;
                        OMNode[] omNodes = list.getAxiomFromXML();
                        if (omNodes.length == 1) {
                            element.addChild(omNodes[0]);
                        } else {
                            for (OMNode omNode : omNodes) {
                                element.addChild(omNode);
                            }
                        }
                    } else {
                        String responseString;
                        String func = "function(obj){return obj.toSource();}";
                        Object result = engine.evaluateFunction(func, new Object[]{response});
                        if (result instanceof String) {
                            responseString = (String)result;
                            if (responseString.startsWith("(") && responseString.endsWith(")")) {
                                responseString = responseString.substring(1, responseString.length() - 1);
                            }
                        } else {
                            responseString = "{}";
                        }
                        ByteArrayInputStream in = new ByteArrayInputStream(responseString.getBytes());
                        JSONOMBuilder builder = new JSONOMBuilder();
                        element = builder.processDocument((InputStream)in, contentType, inMessage);
                        element.buildNext();
                    }
                } else {
                    element = this.buildResponse(annotated, engine.isJson(), response, xmlSchemaElement);
                }
                if (element != null) {
                    body.addChild((OMNode)element);
                }
            }
            outMessage.setEnvelope(envelope);
        }
        catch (Throwable throwable) {
            log.error((Object)throwable.getMessage(), throwable);
            AxisFault fault = AxisFault.makeFault((Throwable)throwable);
            fault.setFaultCode("http://www.w3.org/2003/05/soap-envelope".equals(soapEnvelope.getNamespace().getNamespaceURI()) ? "soapenv:Receiver" : "soapenv:Server");
            throw fault;
        }
        finally {
            RhinoEngine.exitContext();
        }
    }

    private void handleComplexTypeInResponse(XmlSchemaComplexType complexType, OMElement outElement, Object response, OMFactory fac, boolean json, boolean isInnerParam) throws AxisFault {
        XmlSchemaParticle particle = complexType.getParticle();
        if (particle instanceof XmlSchemaSequence) {
            XmlSchemaSequence xmlSchemaSequence = (XmlSchemaSequence)particle;
            XmlSchemaObjectCollection schemaObjectCollection = xmlSchemaSequence.getItems();
            int count = schemaObjectCollection.getCount();
            Iterator iterator = schemaObjectCollection.getIterator();
            while (iterator.hasNext()) {
                Object object;
                XmlSchemaElement innerElement = (XmlSchemaElement)iterator.next();
                String name = innerElement.getName();
                XmlSchemaType schemaType = innerElement.getSchemaType();
                if (schemaType instanceof XmlSchemaComplexType) {
                    Scriptable scriptable = (Scriptable)response;
                    Object object2 = scriptable.get(name, scriptable);
                    if (this.checkRequired(innerElement, object2)) continue;
                    XmlSchemaComplexType innerComplexType = (XmlSchemaComplexType)schemaType;
                    OMElement complexTypeElement = fac.createOMElement(name, outElement.getNamespace());
                    outElement.addChild((OMNode)complexTypeElement);
                    this.handleComplexTypeInResponse(innerComplexType, complexTypeElement, object2, fac, json, true);
                    continue;
                }
                if (isInnerParam || count > 1) {
                    Scriptable scriptable = (Scriptable)response;
                    object = scriptable.get(name, scriptable);
                } else {
                    object = response;
                }
                if (this.checkRequired(innerElement, object) && innerElement.getSchemaTypeName() != Constants.XSD_ANYTYPE) continue;
                this.handleSimpleTypeinResponse(innerElement, object, fac, json, outElement);
            }
        } else {
            throw new AxisFault("Unsupported schema type in response.");
        }
    }

    private boolean checkRequired(XmlSchemaElement innerElement, Object object) throws AxisFault {
        if (JavaScriptEngine.isNull(object)) {
            if (innerElement.getSchemaTypeName() == Constants.XSD_ANYTYPE || innerElement.getMinOccurs() == 0L) {
                return true;
            }
            throw new AxisFault("Required element " + innerElement.getName() + " of type " + innerElement.getSchemaTypeName() + " was not found in the response");
        }
        return false;
    }

    private List handleComplexTypeInRequest(XmlSchemaComplexType complexType, OMElement payload, JavaScriptEngine engine, List paramNames) throws AxisFault {
        XmlSchemaParticle particle = complexType.getParticle();
        ArrayList<Object> params = new ArrayList<Object>();
        if (particle instanceof XmlSchemaSequence) {
            XmlSchemaSequence xmlSchemaSequence = (XmlSchemaSequence)particle;
            Iterator iterator = xmlSchemaSequence.getItems().getIterator();
            while (iterator.hasNext()) {
                XmlSchemaElement innerElement = (XmlSchemaElement)iterator.next();
                XmlSchemaType schemaType = innerElement.getSchemaType();
                if (schemaType instanceof XmlSchemaComplexType) {
                    QName qName;
                    String innerElementName = innerElement.getName();
                    QName payloadQname = payload.getQName();
                    OMElement complexTypePayload = null;
                    if (payloadQname != null) {
                        qName = new QName(payloadQname.getNamespaceURI(), innerElementName);
                        complexTypePayload = payload.getFirstChildWithName(qName);
                    }
                    if (complexTypePayload == null) {
                        qName = new QName(innerElementName);
                        complexTypePayload = payload.getFirstChildWithName(qName);
                    }
                    if (complexTypePayload == null) {
                        throw new AxisFault("Required element " + complexType.getName() + " defined in the schema can not be found in the request");
                    }
                    ArrayList innerParamNames = new ArrayList();
                    List innerParams = this.handleComplexTypeInRequest((XmlSchemaComplexType)schemaType, complexTypePayload, engine, innerParamNames);
                    Scriptable scriptable = RhinoEngine.newObject((ScriptableObject)JavaScriptEngineUtils.getActiveScope());
                    for (int i = 0; i < innerParams.size(); ++i) {
                        scriptable.put((String)innerParamNames.get(i), scriptable, innerParams.get(i));
                    }
                    params.add(scriptable);
                    continue;
                }
                if (schemaType instanceof XmlSchemaSimpleType) {
                    XmlSchemaSimpleType xmlSchemaSimpleType = (XmlSchemaSimpleType)schemaType;
                    XmlSchemaSimpleTypeContent content = xmlSchemaSimpleType.getContent();
                    if (content instanceof XmlSchemaSimpleTypeRestriction) {
                        XmlSchemaSimpleTypeRestriction simpleTypeRestriction = (XmlSchemaSimpleTypeRestriction)content;
                        String elementName = innerElement.getName();
                        Object object = this.handleSimpleElement(payload, engine, elementName, innerElement.getMinOccurs(), simpleTypeRestriction.getBaseTypeName());
                        XmlSchemaObjectCollection facets = simpleTypeRestriction.getFacets();
                        Iterator iterator1 = facets.getIterator();
                        boolean valueFound = false;
                        while (iterator1.hasNext()) {
                            XmlSchemaEnumerationFacet enumerationFacet = (XmlSchemaEnumerationFacet)iterator1.next();
                            if (!enumerationFacet.getValue().equals(object)) continue;
                            valueFound = true;
                            break;
                        }
                        if (!valueFound) {
                            throw new AxisFault("The element " + innerElement.getName() + " is an enumeration of " + "strings. The input " + object + " does not match the defined enumeration.");
                        }
                        params.add(object);
                        paramNames.add(elementName);
                        continue;
                    }
                    throw new AxisFault("Unsupported restriction in Schema");
                }
                params.add(this.handleSimpleTypeInRequest(payload, engine, innerElement));
                paramNames.add(innerElement.getName());
            }
        } else {
            throw new AxisFault("Unsupported schema type in request");
        }
        return params;
    }

    private Object handleSimpleTypeInRequest(OMElement payload, JavaScriptEngine engine, XmlSchemaElement innerElement) throws AxisFault {
        long maxOccurs = innerElement.getMaxOccurs();
        if (maxOccurs > 1L) {
            String innerElemenrName = innerElement.getName();
            Iterator iterator1 = payload.getChildrenWithName(new QName(innerElemenrName));
            return this.handleArray(iterator1, innerElement.getSchemaTypeName(), engine);
        }
        return this.handleSimpleElement(payload, engine, innerElement.getName(), innerElement.getMinOccurs(), innerElement.getSchemaTypeName());
    }

    private Object handleSimpleElement(OMElement payload, JavaScriptEngine engine, String innerElementName, long minOccurs, QName schemaType) throws AxisFault {
        QName qName;
        QName payloadQname = payload.getQName();
        OMElement omElement = null;
        if (payloadQname != null) {
            qName = new QName(payloadQname.getNamespaceURI(), innerElementName);
            omElement = payload.getFirstChildWithName(qName);
        }
        if (omElement == null) {
            qName = new QName(innerElementName);
            omElement = payload.getFirstChildWithName(qName);
        }
        if (omElement == null) {
            if (minOccurs == 0L) {
                return Undefined.instance;
            }
            throw new AxisFault("Required element " + innerElementName + " defined in the schema can not be found in the request");
        }
        return this.createParam(omElement, schemaType, engine);
    }

    private void handleSimpleTypeinResponse(XmlSchemaElement innerElement, Object jsObject, OMFactory factory, boolean json, OMElement outElement) throws AxisFault {
        long maxOccurs = innerElement.getMaxOccurs();
        if (maxOccurs > 1L && !innerElement.getSchemaTypeName().equals(Constants.XSD_ANYTYPE)) {
            if (jsObject instanceof Object[]) {
                Object[] objects;
                for (Object object : objects = (Object[])jsObject) {
                    outElement.addChild((OMNode)this.handleSchemaTypeinResponse(innerElement, object, factory, json));
                }
            } else if (jsObject instanceof NativeArray) {
                Object[] objects;
                NativeArray nativeArray = (NativeArray)jsObject;
                for (Object object : objects = nativeArray.getIds()) {
                    Object o;
                    Object property;
                    if (object instanceof String) {
                        property = (String)object;
                        o = nativeArray.get((String)property, (Scriptable)nativeArray);
                    } else {
                        property = (Integer)object;
                        o = nativeArray.get(((Integer)property).intValue(), (Scriptable)nativeArray);
                    }
                    outElement.addChild((OMNode)this.handleSchemaTypeinResponse(innerElement, o, factory, json));
                }
            } else {
                outElement.addChild((OMNode)this.handleSchemaTypeinResponse(innerElement, jsObject, factory, json));
            }
            return;
        }
        outElement.addChild((OMNode)this.handleSchemaTypeinResponse(innerElement, jsObject, factory, json));
    }

    private OMElement handleSchemaTypeinResponse(XmlSchemaElement innerElement, Object jsObject, OMFactory factory, boolean json) throws AxisFault {
        QName qName = innerElement.getSchemaTypeName();
        OMElement element = factory.createOMElement(innerElement.getName(), null);
        if (qName.equals(Constants.XSD_ANYTYPE)) {
            if (JavaScriptEngine.isNull(jsObject)) {
                return element;
            }
            return this.buildResponse(false, json, jsObject, innerElement);
        }
        if (qName.equals(Constants.XSD_STRING)) {
            String str = JSToOMConverter.convertToString(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_FLOAT)) {
            String str = JSToOMConverter.convertToFloat(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_DOUBLE)) {
            String str = JSToOMConverter.convertToDouble(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_INTEGER)) {
            String str = JSToOMConverter.convertToInteger(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_INT)) {
            String str = JSToOMConverter.convertToInt(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_NONPOSITIVEINTEGER)) {
            String str = JSToOMConverter.convertToNonPositiveInteger(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_NONNEGATIVEINTEGER)) {
            String str = JSToOMConverter.convertToNonNegativeInteger(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_POSITIVEINTEGER)) {
            String str = JSToOMConverter.convertToPositiveInteger(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_NEGATIVEINTEGER)) {
            String str = JSToOMConverter.convertToNegativeInteger(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_LONG)) {
            String str = JSToOMConverter.convertToLong(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_SHORT)) {
            String str = JSToOMConverter.convertToShort(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_BYTE)) {
            String str = JSToOMConverter.convertToByte(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_UNSIGNEDLONG)) {
            String str = JSToOMConverter.convertToUnsignedLong(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_UNSIGNEDBYTE)) {
            String str = JSToOMConverter.convertToUnsignedByte(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_UNSIGNEDINT)) {
            String str = JSToOMConverter.convertToUnsignedInt(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_UNSIGNEDSHORT)) {
            String str = JSToOMConverter.convertToUnsignedShort(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_DECIMAL)) {
            String str = JSToOMConverter.convertToDecimal(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_BOOLEAN)) {
            String str = JSToOMConverter.convertToBoolean(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_DATETIME)) {
            String str = JSToOMConverter.convertToDateTime(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_DATE)) {
            String str = JSToOMConverter.convertToDate(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_TIME)) {
            String str = JSToOMConverter.convertToTime(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_YEARMONTH)) {
            String str = JSToOMConverter.convertToGYearMonth(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_MONTHDAY)) {
            String str = JSToOMConverter.convertToGMonthDay(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_YEAR)) {
            String str = JSToOMConverter.convertToGYear(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_MONTH)) {
            String str = JSToOMConverter.convertToGMonth(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_DAY)) {
            String str = JSToOMConverter.convertToGDay(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_DURATION)) {
            String str = JSToOMConverter.convertToDuration(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_NORMALIZEDSTRING)) {
            String str = JSToOMConverter.convertToNormalizedString(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_TOKEN)) {
            String str = JSToOMConverter.convertToToken(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_LANGUAGE)) {
            String str = JSToOMConverter.convertToLanguage(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_NAME)) {
            String str = JSToOMConverter.convertToName(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_NCNAME)) {
            String str = JSToOMConverter.convertToNCName(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_NOTATION)) {
            String str = JSToOMConverter.convertToNOTATION(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_ANYURI)) {
            String str = JSToOMConverter.convertToAnyURI(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_QNAME)) {
            String str = JSToOMConverter.convertToQName(jsObject, element);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_HEXBIN)) {
            String str = JSToOMConverter.convertToHexBinary(jsObject);
            element.setText(str);
            return element;
        }
        if (qName.equals(Constants.XSD_BASE64)) {
            String str = JSToOMConverter.convertToBase64Binary(jsObject);
            element.setText(str);
            return element;
        }
        return element;
    }

    private String getImportScriptsList(MessageContext inMessage) {
        String scripts = null;
        Parameter param = inMessage.getConfigurationContext().getAxisConfiguration().getParameter("loadJSScripts");
        if (param != null) {
            scripts = (String)param.getValue();
        }
        return scripts;
    }

    private Object createParam(OMElement omElement, QName type, JavaScriptEngine engine) throws AxisFault {
        RhinoEngine rhinoEngine = JavaScriptEngineUtils.getEngine();
        ScriptableObject serviceScope = JavaScriptEngineUtils.getActiveScope();
        if (Constants.XSD_ANYTYPE.equals(type)) {
            OMElement element = omElement.getFirstElement();
            if (element != null) {
                Object[] objects = new Object[]{element};
                return RhinoEngine.newObject((String)"XML", (ScriptableObject)serviceScope, (Object[])objects);
            }
            if (omElement.getText() != null) {
                String value;
                OMAttribute omAttribute = omElement.getAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "type"));
                if (omAttribute != null && (value = omAttribute.getAttributeValue()) != null && !value.trim().equals("")) {
                    String[] strings = value.split(":");
                    TypeTable table = new TypeTable();
                    QName qName = table.getQNamefortheType(strings[1]);
                    return this.createParam(omElement, qName, engine);
                }
                return omElement.getText();
            }
            return Undefined.instance;
        }
        String value = omElement.getText();
        if (value == null) {
            throw new AxisFault("The value of Element " + omElement.getLocalName() + " cannot be null");
        }
        if (Constants.XSD_BOOLEAN.equals(type)) {
            try {
                return ConverterUtil.convertToBoolean((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "boolean"));
            }
        }
        if (Constants.XSD_DOUBLE.equals(type)) {
            try {
                return ConverterUtil.convertToDouble((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "double"));
            }
        }
        if (Constants.XSD_FLOAT.equals(type)) {
            try {
                return Float.valueOf(ConverterUtil.convertToFloat((String)value));
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "float"));
            }
        }
        if (Constants.XSD_INT.equals(type)) {
            try {
                return ConverterUtil.convertToInt((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "int"));
            }
        }
        if (Constants.XSD_INTEGER.equals(type)) {
            try {
                if (value == null || value.equals("")) {
                    return Integer.MIN_VALUE;
                }
                if (value.startsWith("+")) {
                    value = value.substring(1);
                }
                return Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "integer"));
            }
        }
        if (Constants.XSD_POSITIVEINTEGER.equals(type)) {
            try {
                return ConverterUtil.convertToPositiveInteger((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "positive integer"));
            }
        }
        if (Constants.XSD_NEGATIVEINTEGER.equals(type)) {
            try {
                return ConverterUtil.convertToNegativeInteger((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "negative integer"));
            }
        }
        if (Constants.XSD_NONPOSITIVEINTEGER.equals(type)) {
            try {
                return ConverterUtil.convertToNonPositiveInteger((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "non-positive integer"));
            }
        }
        if (Constants.XSD_NONNEGATIVEINTEGER.equals(type)) {
            try {
                return ConverterUtil.convertToNonNegativeInteger((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "non-negative integer"));
            }
        }
        if (Constants.XSD_LONG.equals(type)) {
            try {
                return ConverterUtil.convertToLong((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "long"));
            }
        }
        if (Constants.XSD_SHORT.equals(type)) {
            try {
                return ConverterUtil.convertToShort((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "short"));
            }
        }
        if (Constants.XSD_BYTE.equals(type)) {
            try {
                return ConverterUtil.convertToByte((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "byte"));
            }
        }
        if (Constants.XSD_UNSIGNEDINT.equals(type)) {
            try {
                return ConverterUtil.convertToUnsignedInt((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "unsigned int"));
            }
        }
        if (Constants.XSD_UNSIGNEDLONG.equals(type)) {
            try {
                return ConverterUtil.convertToUnsignedLong((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "unsigned long"));
            }
        }
        if (Constants.XSD_UNSIGNEDSHORT.equals(type)) {
            try {
                return ConverterUtil.convertToUnsignedShort((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "unsigned short"));
            }
        }
        if (Constants.XSD_UNSIGNEDBYTE.equals(type)) {
            try {
                return ConverterUtil.convertToUnsignedByte((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "unsigned byte"));
            }
        }
        if (Constants.XSD_DECIMAL.equals(type)) {
            try {
                return ConverterUtil.convertToDecimal((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "decimal"));
            }
        }
        if (Constants.XSD_DATETIME.equals(type)) {
            try {
                Calendar calendar = ConverterUtil.convertToDateTime((String)value);
                return RhinoEngine.newObject((String)"Date", (ScriptableObject)serviceScope, (Object[])new Object[]{calendar.getTimeInMillis()});
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "date time"));
            }
        }
        if (Constants.XSD_DATE.equals(type)) {
            try {
                Date date = ConverterUtil.convertToDate((String)value);
                return RhinoEngine.newObject((String)"Date", (ScriptableObject)serviceScope, (Object[])new Object[]{date.getTime()});
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "date"));
            }
        }
        if (Constants.XSD_TIME.equals(type)) {
            try {
                Time time = ConverterUtil.convertToTime((String)value);
                return RhinoEngine.newObject((String)"Date", (ScriptableObject)serviceScope, (Object[])new Object[]{time.getAsCalendar().getTimeInMillis()});
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "time"));
            }
        }
        if (Constants.XSD_YEARMONTH.equals(type)) {
            try {
                YearMonth yearMonth = ConverterUtil.convertToGYearMonth((String)value);
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.set(1, yearMonth.getYear());
                calendar.set(2, yearMonth.getMonth());
                String timezone = yearMonth.getTimezone();
                if (timezone != null) {
                    calendar.setTimeZone(TimeZone.getTimeZone(timezone));
                }
                return RhinoEngine.newObject((String)"Date", (ScriptableObject)serviceScope, (Object[])new Object[]{calendar.getTimeInMillis()});
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "yearMonth"));
            }
        }
        if (Constants.XSD_MONTHDAY.equals(type)) {
            try {
                MonthDay monthDay = ConverterUtil.convertToGMonthDay((String)value);
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.set(5, monthDay.getDay());
                calendar.set(2, monthDay.getMonth());
                String timezone = monthDay.getTimezone();
                if (timezone != null) {
                    calendar.setTimeZone(TimeZone.getTimeZone(timezone));
                }
                return RhinoEngine.newObject((String)"Date", (ScriptableObject)serviceScope, (Object[])new Object[]{calendar.getTimeInMillis()});
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "MonthDay"));
            }
        }
        if (Constants.XSD_YEAR.equals(type)) {
            try {
                Year year = ConverterUtil.convertToGYear((String)value);
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.set(1, year.getYear());
                String timezone = year.getTimezone();
                if (timezone != null) {
                    calendar.setTimeZone(TimeZone.getTimeZone(timezone));
                }
                return RhinoEngine.newObject((String)"Date", (ScriptableObject)serviceScope, (Object[])new Object[]{calendar.getTimeInMillis()});
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "year"));
            }
        }
        if (Constants.XSD_MONTH.equals(type)) {
            try {
                Month month = ConverterUtil.convertToGMonth((String)value);
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.set(2, month.getMonth());
                String timezone = month.getTimezone();
                if (timezone != null) {
                    calendar.setTimeZone(TimeZone.getTimeZone(timezone));
                }
                return RhinoEngine.newObject((String)"Date", (ScriptableObject)serviceScope, (Object[])new Object[]{calendar.getTimeInMillis()});
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "month"));
            }
        }
        if (Constants.XSD_DAY.equals(type)) {
            try {
                Day day = ConverterUtil.convertToGDay((String)value);
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.set(5, day.getDay());
                String timezone = day.getTimezone();
                if (timezone != null) {
                    calendar.setTimeZone(TimeZone.getTimeZone(timezone));
                }
                return RhinoEngine.newObject((String)"Date", (ScriptableObject)serviceScope, (Object[])new Object[]{calendar.getTimeInMillis()});
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "day"));
            }
        }
        if (Constants.XSD_DURATION.equals(type)) {
            try {
                Duration duration = ConverterUtil.convertToDuration((String)value);
                return duration.toString();
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "duration"));
            }
        }
        if (Constants.XSD_QNAME.equals(type)) {
            try {
                int index = value.indexOf(":");
                String prefix = "";
                if (index > -1) {
                    prefix = value.substring(0, index);
                    value = value.substring(index + 1);
                }
                OMNamespace namespace = omElement.findNamespaceURI(prefix);
                String namespaceURI = null;
                if (namespace != null) {
                    namespaceURI = namespace.getNamespaceURI();
                }
                Scriptable e4xNamespace = null;
                if (namespaceURI != null) {
                    Object[] namespaceObjects = new Object[]{prefix, namespaceURI};
                    e4xNamespace = RhinoEngine.newObject((String)"Namespace", (ScriptableObject)serviceScope, (Object[])namespaceObjects);
                }
                Object[] qnameObjects = new Object[]{e4xNamespace, value};
                return RhinoEngine.newObject((String)"QName", (ScriptableObject)serviceScope, (Object[])qnameObjects);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "string"));
            }
        }
        if (Constants.XSD_HEXBIN.equals(type)) {
            try {
                return ConverterUtil.convertToString((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "hexBinary"));
            }
        }
        if (Constants.XSD_BASE64.equals(type)) {
            try {
                return ConverterUtil.convertToString((String)value);
            }
            catch (Exception e) {
                throw new AxisFault(this.getFaultString(value, "base64Binary"));
            }
        }
        return omElement.getText();
    }

    private Object handleArray(Iterator iterator, QName type, JavaScriptEngine engine) throws AxisFault {
        ArrayList<Object> objectList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            OMElement omElement = (OMElement)iterator.next();
            objectList.add(this.createParam(omElement, type, engine));
        }
        int length = objectList.size();
        NativeArray nativeArray = new NativeArray(0L);
        for (int i = 0; i < length; ++i) {
            nativeArray.put(i, (Scriptable)nativeArray, objectList.get(i));
        }
        return nativeArray;
    }

    private String inferJavaScriptFunctionName(MessageContext inMessage) throws AxisFault {
        AxisOperation op = inMessage.getOperationContext().getAxisOperation();
        if (op == null) {
            throw new AxisFault("Operation notFound");
        }
        Parameter parameter = op.getParameter("jsFunctionName");
        String jsFunctionName = parameter != null ? (String)parameter.getValue() : op.getName().getLocalPart();
        if (jsFunctionName == null) {
            throw new AxisFault("Unable to infer the JavaScript function  corresponding to this message.");
        }
        return jsFunctionName;
    }

    private OMElement buildResponse(boolean annotated, boolean json, Object result, XmlSchemaElement innerElement) throws AxisFault {
        if (innerElement != null) {
            return this.createResponseElement(result, innerElement.getName(), !annotated);
        }
        OMElement element = this.createResponseElement(result, "return", !annotated);
        OMElement omElement = element.getFirstElement();
        if (omElement == null) {
            String elementText = element.getText();
            if (elementText == null || "".equals(elementText)) {
                return null;
            }
            return element;
        }
        if (omElement.getNextOMSibling() != null) {
            return element;
        }
        return omElement;
    }

    private OMElement createResponseElement(Object jsObject, String elementName, boolean addTypeInfo) throws AxisFault {
        String className = jsObject.getClass().getName();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace namespace = fac.createOMNamespace("http://www.wso2.org/ns/jstype", "js");
        OMNamespace xsiNamespace = fac.createOMNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        OMNamespace xsNamespace = fac.createOMNamespace("http://www.w3.org/2001/XMLSchema", "xs");
        OMElement element = fac.createOMElement(elementName, null);
        if (jsObject instanceof XML) {
            element.addChild(((XML)jsObject).getAxiomFromXML());
            if (addTypeInfo) {
                element.addAttribute("type", "xml", namespace);
                element.declareNamespace(xsNamespace);
                element.addAttribute("type", "xs:anyType", xsiNamespace);
            }
        } else if (jsObject instanceof XMLList) {
            XMLList list = (XMLList)jsObject;
            OMNode[] omNodes = list.getAxiomFromXML();
            if (omNodes.length == 0) {
                return element;
            }
            if (omNodes.length == 1) {
                element.addChild(omNodes[0]);
                if (addTypeInfo) {
                    element.addAttribute("type", "xml", namespace);
                    element.declareNamespace(xsNamespace);
                    element.addAttribute("type", "xs:anyType", xsiNamespace);
                }
            } else {
                for (OMNode omNode : omNodes) {
                    element.addChild(omNode);
                }
                if (addTypeInfo) {
                    element.addAttribute("type", "xmlList", namespace);
                    element.declareNamespace(xsNamespace);
                    element.addAttribute("type", "xs:anyType", xsiNamespace);
                }
            }
        } else if (jsObject instanceof String) {
            element.setText((String)jsObject);
            if (addTypeInfo) {
                element.addAttribute("type", "string", namespace);
                element.declareNamespace(xsNamespace);
                element.addAttribute("type", "xs:string", xsiNamespace);
            }
        } else if (jsObject instanceof Boolean) {
            Boolean booljsObject = (Boolean)jsObject;
            element.setText(booljsObject.toString());
            if (addTypeInfo) {
                element.addAttribute("type", "boolean", namespace);
                element.declareNamespace(xsNamespace);
                element.addAttribute("type", "xs:boolean", xsiNamespace);
            }
        } else if (jsObject instanceof Number) {
            Number numjsObject = (Number)jsObject;
            String str = numjsObject.toString();
            if (str.indexOf("Infinity") >= 0) {
                str = str.replace("Infinity", "INF");
            }
            element.setText(str);
            if (addTypeInfo) {
                element.addAttribute("type", "number", namespace);
                element.addAttribute("type", "xs:double", xsiNamespace);
                element.declareNamespace(xsNamespace);
            }
        } else if (jsObject instanceof Date || "org.mozilla.javascript.NativeDate".equals(className)) {
            Date date = (Date)Context.jsToJava((Object)jsObject, Date.class);
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(date);
            String dateTime = ConverterUtil.convertToString((Calendar)calendar);
            element.setText(dateTime);
            if (addTypeInfo) {
                element.addAttribute("type", "date", namespace);
                element.addAttribute("type", "xs:dateTime", xsiNamespace);
                element.declareNamespace(xsNamespace);
            }
        } else if (jsObject instanceof NativeArray) {
            Object[] objects;
            element.addAttribute("type", "array", namespace);
            element.declareNamespace(xsiNamespace);
            element.declareNamespace(xsNamespace);
            NativeArray nativeArray = (NativeArray)jsObject;
            for (Object object : objects = nativeArray.getIds()) {
                Object propertyElementName;
                Object o;
                Object property;
                if (object instanceof String) {
                    property = (String)object;
                    o = nativeArray.get((String)property, (Scriptable)nativeArray);
                    propertyElementName = property;
                } else {
                    property = (Integer)object;
                    o = nativeArray.get(((Integer)property).intValue(), (Scriptable)nativeArray);
                    propertyElementName = "item";
                }
                OMElement paramElement = this.createResponseElement(o, (String)propertyElementName, true);
                element.addChild((OMNode)paramElement);
            }
        } else if (jsObject instanceof Object[]) {
            Object[] objects;
            element.addAttribute("type", "array", namespace);
            element.declareNamespace(xsiNamespace);
            element.declareNamespace(xsNamespace);
            for (Object object : objects = (Object[])jsObject) {
                OMElement paramElement = this.createResponseElement(object, "item", true);
                element.addChild((OMNode)paramElement);
            }
        } else if (jsObject instanceof NativeObject) {
            Object[] objects;
            element.addAttribute("type", "object", namespace);
            element.declareNamespace(xsiNamespace);
            element.declareNamespace(xsNamespace);
            NativeObject nativeObject = (NativeObject)jsObject;
            for (Object object : objects = NativeObject.getPropertyIds((Scriptable)nativeObject)) {
                if (!(object instanceof String)) continue;
                String property = (String)object;
                Object o = nativeObject.get(property, (Scriptable)nativeObject);
                OMElement paramElement = this.createResponseElement(o, property, true);
                element.addChild((OMNode)paramElement);
            }
        } else if ((jsObject instanceof Undefined || jsObject instanceof UniqueTag) && addTypeInfo) {
            element.addAttribute("type", "undefined", namespace);
        }
        return element;
    }

    private String getFaultString(String value, String type) {
        return "Unable to convert value \"" + value + "\" to " + type;
    }
}

