/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.javascript.messagereceiver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.scriptengine.engine.JavaScriptHostObject;
import org.jaggeryjs.scriptengine.engine.JavaScriptMethod;
import org.jaggeryjs.scriptengine.engine.JavaScriptProperty;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.mashup.javascript.hostobjects.hostobjectservice.service.HostObjectService;

public class JavaScriptEngineUtils {
    private static final Log log = LogFactory.getLog(JavaScriptEngineUtils.class);
    private static HostObjectService hostObjectService = null;
    private static RhinoEngine engine = null;

    public static void setEngine(RhinoEngine engine) throws AxisFault {
        JavaScriptEngineUtils.engine = engine;
        JavaScriptEngineUtils.loadHostObjects();
        JavaScriptMethod method = new JavaScriptMethod("print");
        method.setClazz(JavaScriptEngineUtils.class);
        method.setMethodName("print");
        method.setAttribute(2);
        engine.defineMethod(method);
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                System.out.print(" ");
            }
            String s = Context.toString((Object)args[i]);
            System.out.print(s);
        }
        System.out.println();
    }

    public static RhinoEngine getEngine() {
        return engine;
    }

    public static void initialize() {
        ScriptableObject scope = JavaScriptEngineUtils.getActiveScope();
        Map globalObjects = hostObjectService.getGlobalObjects();
        Set entries = globalObjects.entrySet();
        for (Map.Entry entry : entries) {
            String hostObject = (String)entry.getKey();
            String objectName = (String)entry.getValue();
            if (objectName == null || "".equals(objectName) || hostObject == null || "".equals(hostObject)) continue;
            Scriptable entryHostObject = RhinoEngine.newObject((String)hostObject, (ScriptableObject)scope, (Object[])new Object[0]);
            JavaScriptProperty property = new JavaScriptProperty(objectName);
            property.setValue((Object)entryHostObject);
            property.setAttribute(1);
            RhinoEngine.defineProperty((ScriptableObject)scope, (JavaScriptProperty)property);
        }
    }

    public static void setHostObjectService(HostObjectService hostObjectService) {
        JavaScriptEngineUtils.hostObjectService = hostObjectService;
    }

    public static ScriptableObject getActiveScope() {
        return (ScriptableObject)RhinoEngine.getContextProperty((Object)"active_scope");
    }

    public static void setActiveScope(ScriptableObject scope) {
        Context cx = RhinoEngine.enterContext();
        cx.evaluateString((Scriptable)scope, "new XML();", "XML() initialization", 0, null);
        RhinoEngine.putContextProperty((Object)"active_scope", (Object)scope);
        RhinoEngine.exitContext();
    }

    public static void loadHostObjects() throws AxisFault {
        if (hostObjectService != null) {
            List classes = hostObjectService.getHostObjectClasses();
            for (String classStr : classes) {
                try {
                    Class<?> clazz = Class.forName(classStr);
                    Method method = clazz.getMethod("getClassName", new Class[0]);
                    String name = (String)method.invoke(clazz.newInstance(), new Object[0]);
                    JavaScriptHostObject hostObject = new JavaScriptHostObject(name);
                    hostObject.setClazz(clazz);
                    engine.defineHostObject(hostObject);
                }
                catch (IllegalAccessException e) {
                    log.fatal((Object)e);
                    throw new AxisFault("Error occured while loading the host object :" + classStr, (Throwable)e);
                }
                catch (InstantiationException e) {
                    log.fatal((Object)e);
                    throw new AxisFault("Error occured while loading the host object :" + classStr, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.fatal((Object)e);
                    throw new AxisFault("Error occured while loading the host object :" + classStr, (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.fatal((Object)e);
                    throw new AxisFault("Error occured while loading the host object :" + classStr, (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    log.fatal((Object)e);
                    throw new AxisFault("Error occured while loading the host object :" + classStr, (Throwable)e);
                }
            }
        }
    }

    private static Class loadClass(final String className) throws PrivilegedActionException {
        return (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

            public Object run() throws AxisFault {
                Class selectorClass;
                try {
                    if (className == null || "".equals(className)) {
                        log.fatal((Object)"Invalid Class Name for the HostObject");
                        throw new AxisFault("Invalid Class Name");
                    }
                    selectorClass = Loader.loadClass((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)className);
                }
                catch (ClassNotFoundException e) {
                    log.fatal((Object)e);
                    throw new AxisFault("Error occured while loading the host object :" + className, (Throwable)e);
                }
                return selectorClass;
            }
        });
    }
}

