/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.javascript.messagereceiver;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.Reader;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.json.JSONBadgerfishDataSource;
import org.apache.axis2.json.JSONDataSource;
import org.jaggeryjs.scriptengine.cache.ScriptCachingContext;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.WrappedException;
import org.wso2.carbon.mashup.javascript.messagereceiver.JavaScriptEngineUtils;
import org.wso2.carbon.mashup.utils.MashupReader;
import org.wso2.carbon.mashup.utils.MashupUtils;

public class JavaScriptEngine {
    public static String axis2RepositoryLocation;
    private boolean json = false;
    private String scriptName;

    public JavaScriptEngine(String scriptName) {
        this.scriptName = scriptName;
    }

    public void evaluate(AxisService service) throws ScriptException {
        ScriptableObject scope = JavaScriptEngineUtils.getActiveScope();
        ConfigurationContext configurationContext = (ConfigurationContext)RhinoEngine.getContextProperty((Object)"axisConfigurationContext");
        RhinoEngine engine = JavaScriptEngineUtils.getEngine();
        engine.exec((Reader)new MashupReader(service), scope, MashupUtils.getScriptCachingContext((ConfigurationContext)configurationContext, (AxisService)service));
    }

    private Object call(String method, AxisService service, Object args) throws AxisFault {
        RhinoEngine engine = JavaScriptEngineUtils.getEngine();
        ScriptableObject scope = JavaScriptEngineUtils.getActiveScope();
        Context cx = RhinoEngine.enterContext();
        try {
            Object[] functionArgs;
            if (args instanceof OMSourcedElementImpl) {
                OMDataSource datasource = ((OMSourcedElementImpl)args).getDataSource();
                if (datasource instanceof JSONDataSource) {
                    args = ((JSONDataSource)datasource).getCompleteJOSNString();
                } else if (datasource instanceof JSONBadgerfishDataSource) {
                    args = ((JSONBadgerfishDataSource)datasource).getCompleteJOSNString();
                } else {
                    throw new AxisFault("Unsupported Data Format");
                }
                args = ((String)args).replaceAll("^[\\{][\\t\\s\\r\\n]*[\"](" + method + ")[\"][\\t\\s\\r\\n]*[:][\\t\\s\\r\\n]*|[\\}]$", "");
                Gson gson = new Gson();
                JsonElement element = (JsonElement)gson.fromJson((String)args, JsonElement.class);
                args = "var x = " + element.toString() + ";";
                ScriptableObject tmp = engine.getRuntimeScope();
                cx.evaluateString((Scriptable)tmp, (String)args, "Get JSON", 0, null);
                args = tmp.get("x", (Scriptable)tmp);
                functionArgs = new Object[]{args};
                this.json = true;
            } else if (args instanceof Object[]) {
                functionArgs = (Object[])args;
            } else if (args != null) {
                Object[] objects = new Object[]{args};
                args = RhinoEngine.newObject((String)"XML", (ScriptableObject)scope, (Object[])objects);
                functionArgs = new Object[]{args};
            } else {
                functionArgs = new Object[]{};
            }
            ConfigurationContext configurationContext = (ConfigurationContext)RhinoEngine.getContextProperty((Object)"axisConfigurationContext");
            ScriptCachingContext sctx = MashupUtils.getScriptCachingContext((ConfigurationContext)configurationContext, (AxisService)service);
            Object object = engine.call((Reader)new MashupReader(service), method, functionArgs, scope, scope, sctx);
            return object;
        }
        catch (WrappedException exception) {
            throw AxisFault.makeFault((Throwable)exception.getCause());
        }
        catch (JavaScriptException exception) {
            throw new AxisFault(exception.getValue().toString(), (Throwable)exception);
        }
        catch (Throwable throwable) {
            throw AxisFault.makeFault((Throwable)throwable);
        }
        finally {
            RhinoEngine.exitContext();
        }
    }

    public Object evaluateFunction(String func, Object[] args) throws ScriptException {
        func = "var x = " + func + ";";
        ScriptableObject scope = JavaScriptEngineUtils.getEngine().getRuntimeScope();
        Context cx = RhinoEngine.enterContext();
        cx.evaluateString((Scriptable)scope, func, "Eval Func", 0, null);
        Function function = (Function)scope.get("x", (Scriptable)scope);
        Object result = function.call(cx, (Scriptable)scope, (Scriptable)scope, args);
        RhinoEngine.exitContext();
        return result;
    }

    public Object call(String method, AxisService service, Object args, String scripts) throws AxisFault {
        return this.call(method, service, args);
    }

    public boolean isJson() {
        return this.json;
    }

    public static boolean isNull(Object object) {
        return object == null || object instanceof UniqueTag || object instanceof Undefined;
    }
}

