/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.javascript.hostobjects.registry;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.mashup.javascript.hostobjects.registry.CollectionHostObject;
import org.wso2.carbon.mashup.javascript.hostobjects.registry.RegistryHostObjectContext;
import org.wso2.carbon.mashup.javascript.hostobjects.registry.ResourceHostObject;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class RegistryHostObject
extends ScriptableObject {
    private Registry registry;
    private static String basePath = "";

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws CarbonException {
        RegistryHostObject registryHostObject = new RegistryHostObject();
        if (args.length == 0) {
            AxisConfiguration axisConfig = registryHostObject.getConfigContext(cx).getAxisConfiguration();
            Object object = cx.getThreadLocal((Object)"axisService");
            if (!(object instanceof AxisService)) {
                throw new CarbonException("Error obtaining the AxisService.");
            }
            AxisService axisService = (AxisService)object;
            String mashupAuthor = (String)axisService.getParameter("mashupAuthor").getValue();
            int tenantId = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfig).getTenantId();
            registryHostObject.registry = RegistryHostObjectContext.getUserRegistry(mashupAuthor, tenantId);
            return registryHostObject;
        }
        throw new CarbonException("Registry() constructor doesn't accept arguments.");
    }

    public String getClassName() {
        return "Registry";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void jsFunction_remove(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        if (arguments.length != 1) throw new CarbonException("Invalid no. of arguments for delete() method");
        if (!(arguments[0] instanceof String)) throw new CarbonException("Path argument of method delete() should be a string.");
        try {
            registryHostObject.registry.delete(RegistryHostObject.getAbsoluteRegistryPath((String)arguments[0]));
            return;
        }
        catch (RegistryException e) {
            throw new CarbonException("Registry error occurred while executing delete() operation.", (Throwable)e);
        }
    }

    public static Scriptable jsFunction_get(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        if (arguments.length == 1) {
            if (arguments[0] instanceof String) {
                try {
                    Resource resource = registryHostObject.registry.get(RegistryHostObject.getAbsoluteRegistryPath((String)arguments[0]));
                    Scriptable hostObject = resource instanceof Collection ? cx.newObject((Scriptable)registryHostObject, "Collection", new Object[]{resource}) : cx.newObject((Scriptable)registryHostObject, "Resource", new Object[]{resource});
                    return hostObject;
                }
                catch (RegistryException e) {
                    throw new CarbonException("Registry error occurred while executing get() operation.", (Throwable)e);
                }
            }
            throw new CarbonException("Path argument of method get() should be a string");
        }
        if (arguments.length == 3) {
            if (arguments[0] instanceof String && arguments[1] instanceof Number && arguments[2] instanceof Number) {
                try {
                    Collection collection = registryHostObject.registry.get(RegistryHostObject.getAbsoluteRegistryPath((String)arguments[0]), ((Number)arguments[1]).intValue(), ((Number)arguments[2]).intValue());
                    CollectionHostObject collectionHostobject = (CollectionHostObject)cx.newObject((Scriptable)registryHostObject, "Collection", new Object[]{collection});
                    return collectionHostobject;
                }
                catch (RegistryException e) {
                    throw new CarbonException("Registry error occurred while executing get() operation.", (Throwable)e);
                }
            }
            throw new CarbonException("Invalid argument types for get() method.");
        }
        throw new CarbonException("Invalid no. of arguments for get() method");
    }

    public static String jsFunction_put(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        if (arguments.length == 2) {
            if (arguments[0] instanceof String && arguments[1] instanceof Scriptable) {
                ResourceHostObject resourceHostobject = (ResourceHostObject)((Object)arguments[1]);
                try {
                    return registryHostObject.registry.put(RegistryHostObject.getAbsoluteRegistryPath((String)arguments[0]), resourceHostobject.getResource());
                }
                catch (RegistryException e) {
                    throw new CarbonException("Registry error occurred while executing get() operation.", (Throwable)e);
                }
            }
            throw new CarbonException("Invalid argument types for put() method.");
        }
        throw new CarbonException("Invalid no. of arguments for put() method");
    }

    public static Scriptable jsFunction_newCollection(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        if (arguments.length == 0) {
            if (registryHostObject.registry != null) {
                try {
                    Collection collection = registryHostObject.registry.newCollection();
                    CollectionHostObject collectionHostobject = (CollectionHostObject)cx.newObject((Scriptable)registryHostObject, "Collection", new Object[]{collection});
                    return collectionHostobject;
                }
                catch (RegistryException e) {
                    throw new CarbonException("Error occurred while creating a new Collection.", (Throwable)e);
                }
            }
            throw new CarbonException("Registry has not initialized.");
        }
        throw new CarbonException("newCollection() Method doesn't accept arguments.");
    }

    public static Scriptable jsFunction_newResource(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        if (arguments.length == 0) {
            if (registryHostObject.registry != null) {
                try {
                    Resource resource = registryHostObject.registry.newResource();
                    ResourceHostObject resourceHostobject = (ResourceHostObject)cx.newObject((Scriptable)registryHostObject, "Resource", new Object[]{resource});
                    return resourceHostobject;
                }
                catch (RegistryException e) {
                    throw new CarbonException("Error occurred while creating a new Resource.", (Throwable)e);
                }
            }
            throw new CarbonException("Registry has not initialized.");
        }
        throw new CarbonException("newResource() Method doesn't accept arguments.");
    }

    public static boolean jsFunction_resourceExists(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        if (arguments.length == 1) {
            if (arguments[0] instanceof String) {
                try {
                    return registryHostObject.registry.resourceExists(RegistryHostObject.getAbsoluteRegistryPath((String)arguments[0]));
                }
                catch (RegistryException e) {
                    throw new CarbonException("Error occurred while creating a new Resource.", (Throwable)e);
                }
            }
            throw new CarbonException("Invalid argument types for resourceExists() method.");
        }
        throw new CarbonException("Invalid no. of arguments");
    }

    private ConfigurationContext getConfigContext(Context cx) throws CarbonException {
        Object configurationContextObject = cx.getThreadLocal((Object)"axisConfigurationContext");
        if (configurationContextObject != null && configurationContextObject instanceof ConfigurationContext) {
            return (ConfigurationContext)configurationContextObject;
        }
        throw new CarbonException("Error obtaining the Service Meta Data : Axis2 ConfigurationContext");
    }

    private static String getAbsoluteRegistryPath(String relativePath) {
        return basePath + "/" + relativePath;
    }
}

