/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.javascript.hostobjects.im;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.mashup.imwrapper.core.IMException;
import org.wso2.carbon.mashup.imwrapper.core.IMWrapper;
import org.wso2.carbon.mashup.imwrapper.core.IMWrapperFactory;

public class IMHostObject
extends ScriptableObject {
    private IMWrapper imWrapper;
    private String protocol;

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws CarbonException {
        IMHostObject im = new IMHostObject();
        if (args.length == 1 & args[0] instanceof String) {
            String protocol;
            im.protocol = protocol = (String)args[0];
            try {
                im.imWrapper = IMWrapperFactory.createIMProtocolImpl((String)protocol);
            }
            catch (IMException e) {
                throw new CarbonException((Throwable)e);
            }
        } else {
            throw new CarbonException("Invalid parameters. The name of the IM protocol to be used should be parsed in as a parameter.");
        }
        return im;
    }

    public String getClassName() {
        return "IM";
    }

    public static void jsFunction_login(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws CarbonException {
        String password;
        String username;
        IMHostObject im = (IMHostObject)thisObj;
        if (args.length == 0) {
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            String key = "IMConfig." + im.protocol;
            username = serverConfig.getFirstProperty(key + "." + "username");
            password = serverConfig.getFirstProperty(key + "." + "password");
        } else if (args.length == 2) {
            username = (String)args[0];
            password = (String)args[1];
        } else {
            throw new CarbonException("Incorrect number of arguments. If you want to use login details specified in the server.xml call this method with 0 parameters else pass in the username and password");
        }
        try {
            im.imWrapper.login(username, password);
        }
        catch (IMException e) {
            throw new CarbonException((Throwable)e);
        }
    }

    public void jsFunction_sendMessage(String to, String message) throws CarbonException {
        try {
            this.imWrapper.sendMessage(to, message);
        }
        catch (IMException e) {
            throw new CarbonException((Throwable)e);
        }
    }

    public void jsFunction_disconnect() throws CarbonException {
        try {
            this.imWrapper.disconnect();
        }
        catch (IMException e) {
            throw new CarbonException((Throwable)e);
        }
    }
}

