/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.javascript.hostobjects.httpclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;
import org.wso2.carbon.CarbonException;

public class HttpClientHostObject
extends ScriptableObject {
    private HttpMethod method;
    private HttpClient httpClient;
    private NativeArray authSchemePriority = null;
    private NativeArray cookies = null;
    private NativeObject credentials = null;
    private NativeObject proxyCredentials = null;
    private NativeObject host = null;
    private static final String DEFAULT_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final String DEFAULT_HOST_PROTOCOL = "http";
    private static final int DEFAULT_HOST_PORT = 80;
    private static final Object AGE = null;
    private static final String PATH = "/";
    private static final Boolean SECURE = false;

    public HttpClientHostObject() {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        this.httpClient = new HttpClient((HttpConnectionManager)connectionManager);
    }

    public String getClassName() {
        return "HttpClient";
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws CarbonException {
        HttpClientHostObject httpClient = new HttpClientHostObject();
        if (args.length != 0) {
            throw new CarbonException("HttpClient constructor doesn't accept any arguments");
        }
        return httpClient;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int jsFunction_executeMethod(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws CarbonException {
        ArrayList<NameValuePair> pairs;
        String domainNT;
        String hostNT;
        NativeObject scope;
        String password;
        String username;
        String scheme;
        String realm;
        int port;
        String host;
        HttpClientHostObject httpClient = (HttpClientHostObject)thisObj;
        ArrayList<String> authSchemes = new ArrayList<String>();
        String contentType = DEFAULT_CONTENT_TYPE;
        String charset = DEFAULT_CHARSET;
        if (httpClient.authSchemePriority != null) {
            int i = 0;
            while ((long)i < httpClient.authSchemePriority.getLength()) {
                if (!(httpClient.authSchemePriority.get(i, (Scriptable)httpClient.authSchemePriority) instanceof String)) throw new CarbonException("Authentication Schemes should be Strings values");
                String currentScheme = (String)httpClient.authSchemePriority.get(i, (Scriptable)httpClient.authSchemePriority);
                if (currentScheme.equals("NTLM")) {
                    authSchemes.add("NTLM");
                } else if (currentScheme.equals("BASIC")) {
                    authSchemes.add("BASIC");
                } else {
                    if (!currentScheme.equals("DIGEST")) throw new CarbonException("Unsupported Authentication Scheme");
                    authSchemes.add("DIGEST");
                }
                ++i;
            }
            httpClient.httpClient.getParams().setParameter("http.auth.scheme-priority", authSchemes);
        }
        if (httpClient.credentials != null && ScriptableObject.getProperty((Scriptable)httpClient.credentials, (String)"credentials") instanceof NativeObject) {
            NativeObject creds = (NativeObject)ScriptableObject.getProperty((Scriptable)httpClient.credentials, (String)"credentials");
            if (!(ScriptableObject.getProperty((Scriptable)creds, (String)"username") instanceof String)) throw new CarbonException("Username should be a String");
            host = AuthScope.ANY_HOST;
            port = -1;
            realm = AuthScope.ANY_REALM;
            scheme = AuthScope.ANY_SCHEME;
            username = (String)ScriptableObject.getProperty((Scriptable)creds, (String)"username");
            if (username.equals("")) throw new CarbonException("Username can not be an empty String");
            password = ScriptableObject.getProperty((Scriptable)creds, (String)"password") instanceof String ? (String)ScriptableObject.getProperty((Scriptable)creds, (String)"password") : "";
            if (ScriptableObject.getProperty((Scriptable)httpClient.credentials, (String)"scope") instanceof NativeObject) {
                scope = (NativeObject)ScriptableObject.getProperty((Scriptable)httpClient.credentials, (String)"scope");
                if (ScriptableObject.getProperty((Scriptable)scope, (String)"host") instanceof String) {
                    host = (String)ScriptableObject.getProperty((Scriptable)scope, (String)"host");
                }
                if (ScriptableObject.getProperty((Scriptable)scope, (String)"port") instanceof Integer) {
                    port = (Integer)ScriptableObject.getProperty((Scriptable)scope, (String)"port");
                }
                if (ScriptableObject.getProperty((Scriptable)scope, (String)"realm") instanceof Integer) {
                    realm = (String)ScriptableObject.getProperty((Scriptable)scope, (String)"realm");
                }
                if (ScriptableObject.getProperty((Scriptable)scope, (String)"scheme") instanceof Integer) {
                    scheme = (String)ScriptableObject.getProperty((Scriptable)scope, (String)"scheme");
                }
            }
            if (authSchemes.contains("NTLM")) {
                if (!(ScriptableObject.getProperty((Scriptable)creds, (String)"host") instanceof String) || !(ScriptableObject.getProperty((Scriptable)creds, (String)"domain") instanceof String)) throw new CarbonException("Both Host and Domain should be specified if you are using NTLM Authentication Scheme");
                hostNT = (String)ScriptableObject.getProperty((Scriptable)creds, (String)"host");
                domainNT = (String)ScriptableObject.getProperty((Scriptable)creds, (String)"domain");
                httpClient.httpClient.getState().setCredentials(new AuthScope(host, port, realm, scheme), (Credentials)new NTCredentials(username, password, hostNT, domainNT));
            } else {
                httpClient.httpClient.getState().setCredentials(new AuthScope(host, port, realm, scheme), (Credentials)new UsernamePasswordCredentials(username, password));
            }
        }
        if (httpClient.proxyCredentials != null && ScriptableObject.getProperty((Scriptable)httpClient.proxyCredentials, (String)"credentials") instanceof NativeObject) {
            NativeObject creds = (NativeObject)ScriptableObject.getProperty((Scriptable)httpClient.proxyCredentials, (String)"credentials");
            if (!(ScriptableObject.getProperty((Scriptable)creds, (String)"username") instanceof String)) throw new CarbonException("Username should be a String for Proxy");
            host = AuthScope.ANY_HOST;
            port = -1;
            realm = AuthScope.ANY_REALM;
            scheme = AuthScope.ANY_SCHEME;
            username = (String)ScriptableObject.getProperty((Scriptable)creds, (String)"username");
            if (username.equals("")) throw new CarbonException("Username can not be an empty String for Proxy");
            password = ScriptableObject.getProperty((Scriptable)creds, (String)"password") instanceof String ? (String)ScriptableObject.getProperty((Scriptable)creds, (String)"password") : "";
            if (ScriptableObject.getProperty((Scriptable)httpClient.proxyCredentials, (String)"scope") instanceof NativeObject) {
                scope = (NativeObject)ScriptableObject.getProperty((Scriptable)httpClient.proxyCredentials, (String)"scope");
                if (ScriptableObject.getProperty((Scriptable)scope, (String)"host") instanceof String) {
                    host = (String)ScriptableObject.getProperty((Scriptable)scope, (String)"host");
                }
                if (ScriptableObject.getProperty((Scriptable)scope, (String)"port") instanceof Integer) {
                    port = (Integer)ScriptableObject.getProperty((Scriptable)scope, (String)"port");
                }
                if (ScriptableObject.getProperty((Scriptable)scope, (String)"realm") instanceof Integer) {
                    realm = (String)ScriptableObject.getProperty((Scriptable)scope, (String)"realm");
                }
                if (ScriptableObject.getProperty((Scriptable)scope, (String)"scheme") instanceof Integer) {
                    scheme = (String)ScriptableObject.getProperty((Scriptable)scope, (String)"scheme");
                }
            }
            if (authSchemes.contains("NTLM")) {
                if (!(ScriptableObject.getProperty((Scriptable)creds, (String)"host") instanceof String) || !(ScriptableObject.getProperty((Scriptable)creds, (String)"domain") instanceof String)) throw new CarbonException("Both Host and Domain should be specified if you are using NTLM Authentication Scheme for Proxy");
                hostNT = (String)ScriptableObject.getProperty((Scriptable)creds, (String)"host");
                domainNT = (String)ScriptableObject.getProperty((Scriptable)creds, (String)"domain");
                httpClient.httpClient.getState().setProxyCredentials(new AuthScope(host, port, realm, scheme), (Credentials)new NTCredentials(username, password, hostNT, domainNT));
            } else {
                httpClient.httpClient.getState().setProxyCredentials(new AuthScope(host, port, realm, scheme), (Credentials)new UsernamePasswordCredentials(username, password));
            }
        }
        if (httpClient.cookies != null) {
            String path = PATH;
            Object age = AGE;
            boolean secure = SECURE;
            int i = 0;
            while ((long)i < httpClient.cookies.getLength()) {
                NativeObject cookie = (NativeObject)httpClient.cookies.get(i, (Scriptable)httpClient.cookies);
                if (!(ScriptableObject.getProperty((Scriptable)cookie, (String)"domain") instanceof String)) {
                    throw new CarbonException("domain property of Cookies should be a String");
                }
                String domain = (String)ScriptableObject.getProperty((Scriptable)cookie, (String)"domain");
                if (!(ScriptableObject.getProperty((Scriptable)cookie, (String)"name") instanceof String)) {
                    throw new CarbonException("name property of Cookies should be a String");
                }
                String name = (String)ScriptableObject.getProperty((Scriptable)cookie, (String)"name");
                if (!(ScriptableObject.getProperty((Scriptable)cookie, (String)"value") instanceof String)) {
                    throw new CarbonException("value property of Cookies should be a String");
                }
                String value = (String)ScriptableObject.getProperty((Scriptable)cookie, (String)"value");
                if (ScriptableObject.getProperty((Scriptable)cookie, (String)"path") instanceof String) {
                    path = (String)ScriptableObject.getProperty((Scriptable)cookie, (String)"path");
                } else if (!ScriptableObject.getProperty((Scriptable)cookie, (String)"path").equals(UniqueTag.NOT_FOUND)) {
                    throw new CarbonException("path property of Cookies should be a String");
                }
                if (ScriptableObject.getProperty((Scriptable)cookie, (String)"age") instanceof Date) {
                    age = (Date)ScriptableObject.getProperty((Scriptable)cookie, (String)"age");
                } else if (ScriptableObject.getProperty((Scriptable)cookie, (String)"age") instanceof Integer) {
                    age = (Integer)ScriptableObject.getProperty((Scriptable)cookie, (String)"age");
                } else if (!ScriptableObject.getProperty((Scriptable)cookie, (String)"age").equals(UniqueTag.NOT_FOUND)) {
                    throw new CarbonException("age property of Cookies should be an Integer or Date");
                }
                if (ScriptableObject.getProperty((Scriptable)cookie, (String)"secure") instanceof Boolean) {
                    secure = (Boolean)ScriptableObject.getProperty((Scriptable)cookie, (String)"secure");
                } else if (!ScriptableObject.getProperty((Scriptable)cookie, (String)"secure").equals(UniqueTag.NOT_FOUND)) {
                    throw new CarbonException("name property of Cookies should be a String");
                }
                if (age != null) {
                    if (age instanceof Date) {
                        httpClient.httpClient.getState().addCookie(new Cookie(domain, name, value, path, (Date)age, secure));
                    } else {
                        httpClient.httpClient.getState().addCookie(new Cookie(domain, name, value, path, ((Integer)age).intValue(), secure));
                    }
                } else {
                    httpClient.httpClient.getState().addCookie(new Cookie(domain, name, value, path, (Date)age, secure));
                }
                ++i;
            }
        }
        String methodName = null;
        String url = null;
        String content = null;
        NativeObject params = null;
        NativeArray headers = null;
        switch (args.length) {
            case 2: {
                if (!(args[0] instanceof String)) {
                    throw new CarbonException("HTTP method should be a String value");
                }
                methodName = (String)args[0];
                if (!(args[1] instanceof String)) throw new CarbonException("Url should be a String value");
                url = (String)args[1];
                break;
            }
            case 3: {
                if (!(args[0] instanceof String)) {
                    throw new CarbonException("HTTP method should be a String value");
                }
                methodName = (String)args[0];
                if (!(args[1] instanceof String)) {
                    throw new CarbonException("Url should be a String value");
                }
                url = (String)args[1];
                if (args[2] instanceof String) {
                    content = (String)args[2];
                    break;
                }
                if (args[2] instanceof NativeArray) {
                    content = (NativeArray)args[2];
                    break;
                }
                if (args[2] == null) break;
                throw new CarbonException("Content should be a String value or Array of Name-value pairs");
            }
            case 4: {
                if (!(args[0] instanceof String)) {
                    throw new CarbonException("HTTP method should be a String value");
                }
                methodName = (String)args[0];
                if (!(args[1] instanceof String)) {
                    throw new CarbonException("Url should be a String value");
                }
                url = (String)args[1];
                if (args[2] instanceof String) {
                    content = (String)args[2];
                } else if (args[2] instanceof NativeArray) {
                    content = (NativeArray)args[2];
                } else if (args[2] != null) {
                    throw new CarbonException("Content should be a String value or Array of Name-value pairs");
                }
                if (args[3] instanceof NativeObject) {
                    params = (NativeObject)args[3];
                    break;
                }
                if (args[3] == null) break;
                throw new CarbonException("Params argument should be an Object");
            }
            case 5: {
                if (!(args[0] instanceof String)) {
                    throw new CarbonException("HTTP method should be a String value");
                }
                methodName = (String)args[0];
                if (!(args[1] instanceof String)) {
                    throw new CarbonException("Url should be a String value");
                }
                url = (String)args[1];
                if (args[2] instanceof String) {
                    content = (String)args[2];
                } else if (args[2] instanceof NativeArray) {
                    content = (NativeArray)args[2];
                } else if (args[2] != null) {
                    throw new CarbonException("Content should be a String value or Array of Name-value pairs");
                }
                if (args[3] instanceof NativeObject) {
                    params = (NativeObject)args[3];
                } else if (args[3] != null) {
                    throw new CarbonException("Params argument should be an Object");
                }
                if (args[4] instanceof NativeArray) {
                    headers = (NativeArray)args[4];
                    break;
                }
                if (args[4] == null) break;
                throw new CarbonException("Headers argument should be an Object");
            }
        }
        if (url == null) throw new CarbonException("A url should be specified");
        if (methodName.equals("GET")) {
            httpClient.method = new GetMethod(url);
        } else if (methodName.equals("POST")) {
            httpClient.method = new PostMethod(url);
        } else if (methodName.equals("PUT")) {
            httpClient.method = new PutMethod(url);
        } else {
            if (!methodName.equals("DELETE")) throw new CarbonException("HTTP method you specified is not supported");
            httpClient.method = new DeleteMethod(url);
        }
        if (headers != null) {
            int i = 0;
            while ((long)i < headers.getLength()) {
                NativeObject header = (NativeObject)headers.get(i, headers);
                if (!(ScriptableObject.getProperty((Scriptable)header, (String)"name") instanceof String) || !(ScriptableObject.getProperty((Scriptable)header, (String)"value") instanceof String)) {
                    throw new CarbonException("Name-Value pairs of headers should be Strings");
                }
                String hName = (String)ScriptableObject.getProperty((Scriptable)header, (String)"name");
                String hValue = (String)ScriptableObject.getProperty((Scriptable)header, (String)"value");
                httpClient.method.setRequestHeader(hName, hValue);
                ++i;
            }
        }
        if (params != null) {
            if (ScriptableObject.getProperty(params, (String)"cookiePolicy") instanceof String) {
                httpClient.method.getParams().setCookiePolicy((String)ScriptableObject.getProperty(params, (String)"cookiePolicy"));
            } else if (!ScriptableObject.getProperty(params, (String)"cookiePolicy").equals(UniqueTag.NOT_FOUND)) {
                throw new CarbonException("Method parameters should be Strings");
            }
            if (ScriptableObject.getProperty(params, (String)"contentType") instanceof String) {
                contentType = (String)ScriptableObject.getProperty(params, (String)"contentType");
            } else if (!ScriptableObject.getProperty(params, (String)"contentType").equals(UniqueTag.NOT_FOUND)) {
                throw new CarbonException("Method parameters should be Strings");
            }
            if (ScriptableObject.getProperty(params, (String)"charset") instanceof String) {
                charset = (String)ScriptableObject.getProperty((Scriptable)params, (String)"charset");
            } else if (!ScriptableObject.getProperty((Scriptable)params, (String)"charset").equals(UniqueTag.NOT_FOUND)) {
                throw new CarbonException("Method parameters should be Strings");
            }
            if (ScriptableObject.getProperty((Scriptable)params, (String)"timeout") instanceof Integer) {
                httpClient.method.getParams().setSoTimeout(((Integer)ScriptableObject.getProperty((Scriptable)params, (String)"timeout")).intValue());
            } else if (!ScriptableObject.getProperty((Scriptable)params, (String)"timeout").equals(UniqueTag.NOT_FOUND)) {
                throw new CarbonException("Method parameters should be Strings");
            }
            if (ScriptableObject.getProperty((Scriptable)params, (String)"doAuthentication") instanceof Boolean) {
                httpClient.method.setDoAuthentication(((Boolean)ScriptableObject.getProperty((Scriptable)params, (String)"doAuthentication")).booleanValue());
            } else if (!ScriptableObject.getProperty((Scriptable)params, (String)"doAuthentication").equals(UniqueTag.NOT_FOUND)) {
                throw new CarbonException("Method parameters should be Strings");
            }
            if (ScriptableObject.getProperty((Scriptable)params, (String)"followRedirect") instanceof Boolean) {
                httpClient.method.setFollowRedirects(((Boolean)ScriptableObject.getProperty((Scriptable)params, (String)"followRedirect")).booleanValue());
            } else if (!ScriptableObject.getProperty((Scriptable)params, (String)"followRedirect").equals(UniqueTag.NOT_FOUND)) {
                throw new CarbonException("Method parameters should be Strings");
            }
            if (methodName.equals("POST")) {
                if (ScriptableObject.getProperty((Scriptable)params, (String)"contentChunked") instanceof Boolean) {
                    boolean chuncked = (Boolean)ScriptableObject.getProperty((Scriptable)params, (String)"contentChunked");
                    ((PostMethod)httpClient.method).setContentChunked(chuncked);
                    if (chuncked && content != null) {
                        if (content instanceof String) {
                            ((PostMethod)httpClient.method).setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(content.getBytes())));
                        } else {
                            ArrayList<StringPart> parts = new ArrayList<StringPart>();
                            int i = 0;
                            while ((long)i < ((NativeArray)content).getLength()) {
                                if (!(((NativeArray)content).get(i, (Scriptable)((NativeArray)content)) instanceof NativeObject)) throw new CarbonException("Invalid content definition, content array should contain Javascript Objects");
                                NativeObject element = (NativeObject)((NativeArray)content).get(i, (Scriptable)((NativeArray)content));
                                if (!(ScriptableObject.getProperty((Scriptable)element, (String)"name") instanceof String) || !(ScriptableObject.getProperty((Scriptable)element, (String)"value") instanceof String)) {
                                    throw new CarbonException("Invalid content definition, objects of the content array should consists with strings for both key/value");
                                }
                                String eName = (String)ScriptableObject.getProperty((Scriptable)element, (String)"name");
                                String eValue = (String)ScriptableObject.getProperty((Scriptable)element, (String)"value");
                                parts.add(new StringPart(eName, eValue));
                                ++i;
                            }
                            ((PostMethod)httpClient.method).setRequestEntity((RequestEntity)new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), httpClient.method.getParams()));
                        }
                    }
                } else if (ScriptableObject.getProperty((Scriptable)params, (String)"contentChunked").equals(UniqueTag.NOT_FOUND) && content != null) {
                    if (content instanceof String) {
                        try {
                            ((PostMethod)httpClient.method).setRequestEntity((RequestEntity)new StringRequestEntity(content, contentType, charset));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new CarbonException("Unsupported Charset");
                        }
                    } else {
                        pairs = new ArrayList();
                        int i = 0;
                        while ((long)i < ((NativeArray)content).getLength()) {
                            if (!(((NativeArray)content).get(i, (Scriptable)((NativeArray)content)) instanceof NativeObject)) throw new CarbonException("Invalid content definition, content array should contain Javascript Objects");
                            NativeObject element = (NativeObject)((NativeArray)content).get(i, (Scriptable)((NativeArray)content));
                            if (!(ScriptableObject.getProperty((Scriptable)element, (String)"name") instanceof String) || !(ScriptableObject.getProperty((Scriptable)element, (String)"value") instanceof String)) {
                                throw new CarbonException("Invalid content definition, objects of the content array should consists with strings for both key/value");
                            }
                            String eName = (String)ScriptableObject.getProperty((Scriptable)element, (String)"name");
                            String eValue = (String)ScriptableObject.getProperty((Scriptable)element, (String)"value");
                            pairs.add(new NameValuePair(eName, eValue));
                            ++i;
                        }
                        ((PostMethod)httpClient.method).setRequestBody(pairs.toArray(new NameValuePair[pairs.size()]));
                    }
                } else if (!ScriptableObject.getProperty((Scriptable)params, (String)"contentChunked").equals(UniqueTag.NOT_FOUND)) {
                    throw new CarbonException("Method parameters should be Strings");
                }
            } else if (methodName.equals("GET")) {
                if (content != null) {
                    if (content instanceof String) {
                        httpClient.method.setQueryString(content);
                    } else {
                        pairs = new ArrayList();
                        int i = 0;
                        while ((long)i < ((NativeArray)content).getLength()) {
                            if (!(((NativeArray)content).get(i, (Scriptable)((NativeArray)content)) instanceof NativeObject)) throw new CarbonException("Invalid content definition, content array should contain Javascript Objects");
                            NativeObject element = (NativeObject)((NativeArray)content).get(i, (Scriptable)((NativeArray)content));
                            if (!(ScriptableObject.getProperty((Scriptable)element, (String)"name") instanceof String) || !(ScriptableObject.getProperty((Scriptable)element, (String)"value") instanceof String)) {
                                throw new CarbonException("Invalid content definition, objects of the content array should consists with strings for both key/value");
                            }
                            String eName = (String)ScriptableObject.getProperty((Scriptable)element, (String)"name");
                            String eValue = (String)ScriptableObject.getProperty((Scriptable)element, (String)"value");
                            pairs.add(new NameValuePair(eName, eValue));
                            ++i;
                        }
                        httpClient.method.setQueryString(pairs.toArray(new NameValuePair[pairs.size()]));
                    }
                }
            } else if (methodName.equals("PUT")) {
                if (ScriptableObject.getProperty((Scriptable)params, (String)"contentChunked") instanceof Boolean) {
                    boolean chuncked = (Boolean)ScriptableObject.getProperty((Scriptable)params, (String)"contentChunked");
                    ((PutMethod)httpClient.method).setContentChunked(chuncked);
                    if (chuncked && content != null) {
                        if (!(content instanceof String)) throw new CarbonException("Invalid content definition, content should be a string when PUT method is used");
                        ((PostMethod)httpClient.method).setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(content.getBytes())));
                    }
                } else if (ScriptableObject.getProperty((Scriptable)params, (String)"contentChunked").equals(UniqueTag.NOT_FOUND) && content != null) {
                    if (!(content instanceof String)) throw new CarbonException("Invalid content definition, content should be a string when PUT method is used");
                    try {
                        ((PostMethod)httpClient.method).setRequestEntity((RequestEntity)new StringRequestEntity(content, contentType, charset));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new CarbonException("Unsupported Charset");
                    }
                } else if (!ScriptableObject.getProperty((Scriptable)params, (String)"contentChunked").equals(UniqueTag.NOT_FOUND)) {
                    throw new CarbonException("Method parameters should be Strings");
                }
            }
            if (ScriptableObject.getProperty((Scriptable)params, (String)"preemptiveAuth") instanceof Boolean) {
                httpClient.httpClient.getParams().setAuthenticationPreemptive(((Boolean)ScriptableObject.getProperty((Scriptable)params, (String)"preemptiveAuth")).booleanValue());
            } else if (!ScriptableObject.getProperty((Scriptable)params, (String)"preemptiveAuth").equals(UniqueTag.NOT_FOUND)) {
                throw new CarbonException("Method parameters should be Strings");
            }
        } else if (content != null) {
            if (methodName.equals("POST")) {
                if (content instanceof String) {
                    try {
                        ((PostMethod)httpClient.method).setRequestEntity((RequestEntity)new StringRequestEntity(content, contentType, charset));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new CarbonException("Unsupported Charset");
                    }
                } else {
                    pairs = new ArrayList<NameValuePair>();
                    int i = 0;
                    while ((long)i < ((NativeArray)content).getLength()) {
                        if (!(((NativeArray)content).get(i, (Scriptable)((NativeArray)content)) instanceof NativeObject)) throw new CarbonException("Invalid content definition, content array should contain Javascript Objects");
                        NativeObject element = (NativeObject)((NativeArray)content).get(i, (Scriptable)((NativeArray)content));
                        if (!(ScriptableObject.getProperty((Scriptable)element, (String)"name") instanceof String) || !(ScriptableObject.getProperty((Scriptable)element, (String)"value") instanceof String)) {
                            throw new CarbonException("Invalid content definition, objects of the content array should consists with strings for both key/value");
                        }
                        String eName = (String)ScriptableObject.getProperty((Scriptable)element, (String)"name");
                        String eValue = (String)ScriptableObject.getProperty((Scriptable)element, (String)"value");
                        pairs.add(new NameValuePair(eName, eValue));
                        ++i;
                    }
                    ((PostMethod)httpClient.method).setRequestBody(pairs.toArray(new NameValuePair[pairs.size()]));
                }
            } else if (methodName.equals("GET")) {
                if (content instanceof String) {
                    httpClient.method.setQueryString(content);
                } else {
                    pairs = new ArrayList();
                    int i = 0;
                    while ((long)i < ((NativeArray)content).getLength()) {
                        if (!(((NativeArray)content).get(i, (Scriptable)((NativeArray)content)) instanceof NativeObject)) throw new CarbonException("Invalid content definition, content array should contain Javascript Objects");
                        NativeObject element = (NativeObject)((NativeArray)content).get(i, (Scriptable)((NativeArray)content));
                        if (!(ScriptableObject.getProperty((Scriptable)element, (String)"name") instanceof String) || !(ScriptableObject.getProperty((Scriptable)element, (String)"value") instanceof String)) {
                            throw new CarbonException("Invalid content definition, objects of the content array should consists with strings for both key/value");
                        }
                        String eName = (String)ScriptableObject.getProperty((Scriptable)element, (String)"name");
                        String eValue = (String)ScriptableObject.getProperty((Scriptable)element, (String)"value");
                        pairs.add(new NameValuePair(eName, eValue));
                        ++i;
                    }
                    httpClient.method.setQueryString(pairs.toArray(new NameValuePair[pairs.size()]));
                }
            } else if (methodName.equals("PUT") && content != null) {
                if (!(content instanceof String)) throw new CarbonException("Invalid content definition, content should be a string when PUT method is used");
                try {
                    ((PutMethod)httpClient.method).setRequestEntity((RequestEntity)new StringRequestEntity(content, contentType, charset));
                }
                catch (UnsupportedEncodingException e) {
                    throw new CarbonException("Unsupported Charset");
                }
            }
        }
        if (httpClient.host != null) {
            int port2 = 80;
            String protocol = DEFAULT_HOST_PROTOCOL;
            if (!(ScriptableObject.getProperty((Scriptable)httpClient.host, (String)"host") instanceof String)) {
                throw new CarbonException("Host property should be a String");
            }
            String host2 = (String)ScriptableObject.getProperty((Scriptable)httpClient.host, (String)"host");
            if (ScriptableObject.getProperty((Scriptable)httpClient.host, (String)"port") instanceof Integer) {
                port2 = (Integer)ScriptableObject.getProperty((Scriptable)httpClient.host, (String)"port");
            }
            if (ScriptableObject.getProperty((Scriptable)httpClient.host, (String)"protocol") instanceof String) {
                protocol = (String)ScriptableObject.getProperty((Scriptable)httpClient.host, (String)"protocol");
            }
            httpClient.httpClient.getHostConfiguration().setHost(host2, port2, protocol);
        }
        try {
            return httpClient.httpClient.executeMethod(httpClient.method);
        }
        catch (IOException e) {
            throw new CarbonException("Error while executing HTTP method");
        }
    }

    public static void jsFunction_releaseConnection(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws CarbonException {
        if (args.length != 0) {
            throw new CarbonException("Invalid usage of arguments");
        }
        HttpClientHostObject httpClient = (HttpClientHostObject)thisObj;
        httpClient.method.releaseConnection();
    }

    public void jsSet_authSchemePriority(Object object) throws CarbonException {
        if (!(object instanceof NativeArray)) {
            throw new CarbonException("HttpClient Authentication Scheme Priority should be an Array");
        }
        this.authSchemePriority = (NativeArray)object;
    }

    public void jsSet_cookies(Object object) throws CarbonException {
        if (!(object instanceof NativeArray)) {
            throw new CarbonException("HttpClient Cookies should be an Array");
        }
        this.cookies = (NativeArray)object;
    }

    public Scriptable jsGet_cookies() throws CarbonException {
        return Context.toObject((Object)this.httpClient.getState().getCookies(), (Scriptable)this);
    }

    public void jsSet_credentials(Object object) throws CarbonException {
        if (!(object instanceof NativeObject)) {
            throw new CarbonException("HttpClient Credentials should be an Object");
        }
        this.credentials = (NativeObject)object;
    }

    public void jsSet_proxyCredentials(Object object) throws CarbonException {
        if (!(object instanceof NativeObject)) {
            throw new CarbonException("HttpClient Proxy Credentials should be an Object");
        }
        this.proxyCredentials = (NativeObject)object;
    }

    public void jsSet_host(Object object) throws CarbonException {
        if (!(object instanceof NativeObject)) {
            throw new CarbonException("HttpClient Host should be an Object");
        }
        this.host = (NativeObject)object;
    }

    public String jsGet_response() throws CarbonException {
        try {
            return this.method.getResponseBodyAsString();
        }
        catch (IOException e) {
            throw new CarbonException("Error getting the response");
        }
    }

    public Scriptable jsGet_responseHeaders() throws CarbonException {
        return Context.toObject((Object)this.method.getResponseHeaders(), (Scriptable)this);
    }

    public String jsGet_statusText() throws CarbonException {
        return this.method.getStatusText();
    }
}

