/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.javascript.hostobjects.email;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.mashup.javascript.hostobjects.email.internal.EmailServiceComponent;
import org.wso2.carbon.mashup.javascript.hostobjects.file.FileHostObject;
import org.wso2.carbon.mashup.javascript.hostobjects.hostobjectservice.service.HostObjectService;
import org.wso2.javascript.xmlimpl.XML;

public class EmailHostObject
extends ScriptableObject {
    private Properties properties;
    private MimeMessage message;
    private String text;
    private String html;
    Multipart multipart;

    public String getClassName() {
        return "Email";
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws CarbonException {
        String password;
        String username;
        String host;
        Properties props;
        EmailHostObject emailHostObject = new EmailHostObject();
        emailHostObject.properties = props = new Properties();
        emailHostObject.multipart = new MimeMultipart();
        String port = null;
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        int length = args.length;
        if (length == 3) {
            host = (String)args[0];
            username = (String)args[1];
            password = (String)args[2];
            port = serverConfig.getFirstProperty("EmailConfig.port");
        } else if (length == 4) {
            host = (String)args[0];
            port = (String)args[1];
            username = (String)args[2];
            password = (String)args[3];
        } else {
            throw new CarbonException("Incorrect number of arguments. Please specify host, username, password or host, port, username, password within the constructor of Email hostobject.");
        }
        if (host == null) {
            throw new CarbonException("Invalid host name. Please recheck the given details within the constructor of Email hostobject.");
        }
        emailHostObject.setProperty("mail.smtp.host", host);
        if (port != null) {
            emailHostObject.setProperty("mail.smtp.port", port);
        }
        SMTPAuthenticator smtpAuthenticator = null;
        if (username != null) {
            smtpAuthenticator = new SMTPAuthenticator(username, password);
            emailHostObject.setProperty("mail.smtp.auth", "true");
        }
        Session session = Session.getInstance((Properties)props, smtpAuthenticator);
        emailHostObject.message = new MimeMessage(session);
        emailHostObject.setProperty("mail.smtp.starttls.enable", "true");
        return emailHostObject;
    }

    private void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void jsSet_from(String from) throws CarbonException {
        try {
            this.message.setFrom((Address)new InternetAddress(from));
        }
        catch (MessagingException e) {
            throw new CarbonException((Throwable)e);
        }
    }

    public String jsGet_from() throws MessagingException {
        String from = null;
        Address[] addresses = this.message.getFrom();
        if (addresses != null && addresses.length > 0) {
            from = addresses[0].toString();
        }
        return from;
    }

    public String[] jsGet_to() throws CarbonException {
        Address[] addresses;
        try {
            addresses = this.message.getRecipients(Message.RecipientType.TO);
        }
        catch (MessagingException e) {
            throw new CarbonException((Throwable)e);
        }
        String[] to = new String[addresses.length];
        for (int i = 0; i < to.length; ++i) {
            to[i] = addresses[i].toString();
        }
        return to;
    }

    public void jsSet_to(Object toObject) throws CarbonException {
        this.addRecipients(Message.RecipientType.TO, toObject);
    }

    public String[] jsGet_cc() throws CarbonException {
        Address[] addresses;
        try {
            addresses = this.message.getRecipients(Message.RecipientType.CC);
        }
        catch (MessagingException e) {
            throw new CarbonException((Throwable)e);
        }
        String[] cc = new String[addresses.length];
        for (int i = 0; i < cc.length; ++i) {
            cc[i] = addresses[i].toString();
        }
        return cc;
    }

    public void jsSet_cc(Object ccObject) throws CarbonException {
        this.addRecipients(Message.RecipientType.CC, ccObject);
    }

    public String[] jsGet_bcc() throws CarbonException {
        Address[] addresses;
        try {
            addresses = this.message.getRecipients(Message.RecipientType.BCC);
        }
        catch (MessagingException e) {
            throw new CarbonException((Throwable)e);
        }
        String[] bcc = new String[addresses.length];
        for (int i = 0; i < bcc.length; ++i) {
            bcc[i] = addresses[i].toString();
        }
        return bcc;
    }

    public void jsSet_bcc(Object bccObject) throws CarbonException {
        this.addRecipients(Message.RecipientType.BCC, bccObject);
    }

    public void jsSet_subject(String subject) throws CarbonException {
        try {
            this.message.setSubject(subject);
        }
        catch (MessagingException e) {
            throw new CarbonException((Throwable)e);
        }
    }

    public String jsGet_subject() throws CarbonException {
        try {
            return this.message.getSubject();
        }
        catch (MessagingException e) {
            throw new CarbonException((Throwable)e);
        }
    }

    public void jsSet_text(String text) throws CarbonException {
        this.text = text;
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        try {
            messageBodyPart.setText(text);
            this.multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        catch (MessagingException e) {
            throw new CarbonException((Throwable)e);
        }
    }

    public String jsGet_text() {
        return this.text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void jsSet_html(Object html) throws CarbonException {
        if (html instanceof String) {
            this.html = (String)html;
        } else {
            if (!(html instanceof XML)) throw new CarbonException("Invalid input argument. The html function accepts either a String or an XML element.");
            OMNode node = ((XML)html).getAxiomFromXML();
            if (!(node instanceof OMElement)) throw new CarbonException("Invalid input argument. The html function accepts either a String or an XML element.");
            OMElement htmlElement = (OMElement)node;
            this.html = htmlElement.toString();
        }
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        DataHandler dataHandler = null;
        try {
            dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(this.html, "text/html"));
            messageBodyPart.setDataHandler(dataHandler);
            this.multipart.addBodyPart((BodyPart)messageBodyPart);
            return;
        }
        catch (IOException e) {
            throw new CarbonException((Throwable)e);
        }
        catch (MessagingException e) {
            throw new CarbonException((Throwable)e);
        }
    }

    public String jsGet_html() {
        return this.html;
    }

    public void jsFunction_send() throws CarbonException {
        try {
            Date currentDate = new Date();
            this.message.setSentDate(currentDate);
            this.message.setContent(this.multipart);
            Transport.send((Message)this.message);
        }
        catch (MessagingException e) {
            throw new CarbonException((Throwable)e);
        }
    }

    public static void jsFunction_addAttachement(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        EmailHostObject.jsFunction_addAttachment(cx, thisObj, arguments, funObj);
    }

    public static void jsFunction_addAttachment(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        if (!EmailHostObject.isJavaScriptFileObjectAvailable()) {
            throw new CarbonException("Cannot find the FileHostObject class. Make sure that its present in the classpath");
        }
        EmailHostObject emailHostObject = (EmailHostObject)thisObj;
        for (int i = 0; i < arguments.length; ++i) {
            FileHostObject fileHostObject;
            Object object = arguments[i];
            if (object instanceof FileHostObject) {
                fileHostObject = (FileHostObject)object;
            } else if (object instanceof String) {
                fileHostObject = (FileHostObject)cx.newObject((Scriptable)emailHostObject, "File", new Object[]{object});
            } else {
                throw new CarbonException("Invalid parameter. The attachment should be a FileHostObject or a string representing the path of a file");
            }
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            File file = fileHostObject.getFile();
            FileDataSource source = new FileDataSource(file);
            try {
                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                messageBodyPart.setFileName(file.getName());
                emailHostObject.multipart.addBodyPart((BodyPart)messageBodyPart);
                continue;
            }
            catch (MessagingException e) {
                throw new CarbonException((Throwable)e);
            }
        }
    }

    private void addRecipients(Message.RecipientType recipientType, Object recipientObject) throws CarbonException {
        block9: {
            try {
                if (recipientObject instanceof String[]) {
                    String[] to = (String[])recipientObject;
                    InternetAddress[] recipientAddresses = new InternetAddress[to.length];
                    for (int i = 0; i < to.length; ++i) {
                        recipientAddresses[i] = new InternetAddress(to[i]);
                    }
                    this.message.addRecipients(recipientType, (Address[])recipientAddresses);
                    break block9;
                }
                if (recipientObject instanceof NativeArray) {
                    NativeArray nativeArray = (NativeArray)recipientObject;
                    Object[] objects = nativeArray.getIds();
                    for (int i = 0; i < objects.length; ++i) {
                        Object o;
                        Object property;
                        Object object = objects[i];
                        if (object instanceof String) {
                            property = (String)object;
                            o = nativeArray.get((String)property, (Scriptable)nativeArray);
                        } else {
                            property = (Integer)object;
                            o = nativeArray.get(((Integer)property).intValue(), (Scriptable)nativeArray);
                        }
                        this.message.addRecipient(recipientType, (Address)new InternetAddress((String)o));
                    }
                    break block9;
                }
                if (recipientObject instanceof String) {
                    this.message.addRecipient(recipientType, (Address)new InternetAddress((String)recipientObject));
                    break block9;
                }
                throw new CarbonException("The argument to this function should be an array of email addresses or a single email address");
            }
            catch (MessagingException e) {
                throw new CarbonException((Throwable)e);
            }
        }
    }

    private static boolean isJavaScriptFileObjectAvailable() {
        HostObjectService hostObjectDetails = EmailServiceComponent.getHostObjectService();
        return hostObjectDetails != null && hostObjectDetails.getHostObjectClasses().contains("org.wso2.carbon.mashup.javascript.hostobjects.file.FileHostObject");
    }

    private static class SMTPAuthenticator
    extends Authenticator {
        private String username;
        private String password;

        private SMTPAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

