/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.javascript.hostobjects.atom;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRISyntaxException;
import org.apache.abdera.model.Category;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Person;
import org.apache.abdera.parser.stax.util.FOMHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.mashup.javascript.hostobjects.atom.AtomEntryHostObject;
import org.wso2.carbon.mashup.javascript.hostobjects.feed.IFeed;
import org.wso2.carbon.mashup.javascript.hostobjects.file.FileHostObject;
import org.wso2.javascript.xmlimpl.XML;

public class AtomFeedHostObject
extends ScriptableObject
implements IFeed {
    private Feed feed;
    private static Log log = LogFactory.getLog(AtomFeedHostObject.class);

    public Scriptable jsConstructor() {
        Abdera abdera = new Abdera();
        Factory factory = abdera.getFactory();
        this.feed = factory.newFeed();
        return this;
    }

    public String getClassName() {
        return "AtomFeed";
    }

    public void jsSet_id(Object id) {
        if (id instanceof String) {
            this.feed.setId((String)id);
        } else {
            this.feed.setId(FOMHelper.generateUuid());
        }
    }

    public String jsGet_id() {
        if (this.feed != null) {
            return this.feed.getId().toASCIIString();
        }
        return null;
    }

    public void jsSet_author(Object author) {
        this.feed.addAuthor(String.valueOf(author));
    }

    public String jsGet_author() {
        return this.feed.getAuthor().getName();
    }

    public void jsSet_updated(Object updated) throws CarbonException {
        Date date = updated instanceof Date ? (Date)updated : (Date)Context.jsToJava((Object)updated, Date.class);
        if (date == null) {
            throw new CarbonException("Invalid parameter");
        }
        this.feed.setUpdated(date);
    }

    public String jsGet_updated() {
        if (this.feed != null) {
            return this.feed.getUpdated().toString();
        }
        return null;
    }

    public void jsSet_category(Object category) {
        this.feed.addCategory(String.valueOf(category));
    }

    public String jsGet_category() {
        if (this.feed != null) {
            return ((Category)this.feed.getCategories().get(0)).toString();
        }
        return null;
    }

    public void jsSet_contributor(Object contributor) {
        this.feed.addContributor(String.valueOf(contributor));
    }

    public String jsGet_contributor() {
        if (this.feed != null) {
            return ((Person)this.feed.getContributors().get(0)).toString();
        }
        return null;
    }

    public void jsSet_link(Object link) {
        this.feed.addLink(String.valueOf(link));
    }

    public NativeArray jsGet_link() {
        if (this.feed != null) {
            NativeArray nativeArray = new NativeArray(0L);
            List list = this.feed.getLinks();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Link element = (Link)list.get(i);
                nativeArray.put(i, (Scriptable)nativeArray, (Object)element.getHref().toString());
            }
            return nativeArray;
        }
        return null;
    }

    public void jsSet_title(Object title) {
        if (title instanceof XML) {
            this.feed.setTitleAsXhtml(title.toString());
        } else {
            this.feed.setTitle(String.valueOf(title));
        }
    }

    public String jsGet_title() {
        if (this.feed != null) {
            return this.feed.getTitle();
        }
        return null;
    }

    public void jsSet_rights(Object rights) {
        if (rights instanceof XML) {
            this.feed.setRightsAsXhtml(rights.toString());
        } else {
            this.feed.setRights(String.valueOf(rights));
        }
    }

    public String jsGet_rights() {
        if (this.feed != null) {
            return this.feed.getRights();
        }
        return null;
    }

    public Scriptable jsGet_XML() {
        Context cx = Context.getCurrentContext();
        if (this.feed != null) {
            Object[] objects = new Object[]{this.feed};
            Scriptable xmlHostObject = cx.newObject((Scriptable)this, "XML", objects);
            return xmlHostObject;
        }
        return null;
    }

    public static Scriptable jsFunction_addEntry(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) {
        AtomFeedHostObject feedObject = (AtomFeedHostObject)thisObj;
        AtomEntryHostObject retScriptObject = null;
        if (arguments[0] instanceof AtomEntryHostObject) {
            AtomEntryHostObject atomEntryHostObject = (AtomEntryHostObject)((Object)arguments[0]);
            feedObject.feed.addEntry(atomEntryHostObject.getEntry());
            retScriptObject = atomEntryHostObject;
        } else if (arguments.length == 0) {
            Entry newEntry = feedObject.feed.addEntry();
            retScriptObject = (AtomEntryHostObject)cx.newObject((Scriptable)feedObject, "AtomEntry", new Object[0]);
            retScriptObject.setEntry(newEntry);
        }
        return retScriptObject;
    }

    public static Scriptable jsFunction_insertEntry(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) {
        AtomFeedHostObject feedObject = (AtomFeedHostObject)thisObj;
        AtomEntryHostObject retScriptObject = null;
        if (arguments[0] instanceof AtomEntryHostObject) {
            AtomEntryHostObject atomEntryHostObject = (AtomEntryHostObject)((Object)arguments[0]);
            feedObject.feed.insertEntry(atomEntryHostObject.getEntry());
            retScriptObject = atomEntryHostObject;
        } else if (arguments.length == 0) {
            Entry newEntry = feedObject.feed.insertEntry();
            retScriptObject = (AtomEntryHostObject)cx.newObject((Scriptable)feedObject, "AtomEntry", new Object[0]);
            retScriptObject.setEntry(newEntry);
        }
        return retScriptObject;
    }

    public static Scriptable jsFunction_getEntry(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        AtomFeedHostObject feedObject = (AtomFeedHostObject)thisObj;
        AtomEntryHostObject retScriptObject = null;
        if (arguments[0] instanceof String) {
            try {
                Entry entry = feedObject.feed.getEntry((String)arguments[0]);
                if (entry == null) {
                    throw new CarbonException("Invalid Atom Entry Id");
                }
                retScriptObject = (AtomEntryHostObject)cx.newObject((Scriptable)feedObject, "AtomEntry", new Object[0]);
                retScriptObject.setEntry(entry);
            }
            catch (IRISyntaxException e) {
                throw new CarbonException((Throwable)e);
            }
        } else {
            throw new CarbonException("Invalid parameter");
        }
        return retScriptObject;
    }

    public static AtomEntryHostObject[] jsFunction_getEntries(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) {
        AtomFeedHostObject feedObject = (AtomFeedHostObject)thisObj;
        AtomEntryHostObject[] retEntries = null;
        List tempEntries = feedObject.feed.getEntries();
        Iterator tempEntryIterator = tempEntries.iterator();
        ArrayList<AtomEntryHostObject> convertedEntries = new ArrayList<AtomEntryHostObject>();
        while (tempEntryIterator.hasNext()) {
            Entry currentEntry = (Entry)tempEntryIterator.next();
            AtomEntryHostObject newAtomEntry = (AtomEntryHostObject)cx.newObject((Scriptable)feedObject, "AtomEntry", new Object[0]);
            newAtomEntry.setEntry(currentEntry);
            convertedEntries.add(newAtomEntry);
        }
        retEntries = new AtomEntryHostObject[convertedEntries.size()];
        convertedEntries.toArray(retEntries);
        return retEntries;
    }

    public static Scriptable jsFunction_writeTo(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        AtomFeedHostObject feedObject = (AtomFeedHostObject)thisObj;
        OutputStreamWriter fileWriter = null;
        try {
            if (arguments[0] instanceof String) {
                FileHostObject fileHostObject = (FileHostObject)cx.newObject((Scriptable)feedObject, "File", arguments);
                fileWriter = new FileWriter(fileHostObject.getFile());
                feedObject.feed.writeTo((Writer)fileWriter);
                fileWriter.flush();
            } else if (arguments[0] instanceof FileHostObject) {
                FileHostObject fileHostObject = (FileHostObject)arguments[0];
                fileWriter = new FileWriter(fileHostObject.getFile());
                feedObject.feed.writeTo((Writer)fileWriter);
                fileWriter.flush();
            } else {
                throw new CarbonException("Invalid parameter");
            }
            AtomFeedHostObject atomFeedHostObject = feedObject;
            return atomFeedHostObject;
        }
        catch (IOException e) {
            throw new CarbonException((Throwable)e);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Error closing the stream", (Throwable)e);
                }
            }
        }
    }

    Feed getFeed() {
        return this.feed;
    }

    void setFeed(Feed newFeed) {
        this.feed = newFeed;
    }
}

