/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.javascript.hostobjects.atom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.client.RequestOptions;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;

public class GoogleLogin {
    private static final Log log = LogFactory.getLog(GoogleLogin.class);
    private static final String UTF8 = "UTF-8";
    private static final String URI = "https://www.google.com/accounts/ClientLogin";

    public static String getAuth(AbderaClient client, String service, String id, String pwd) {
        try {
            StringRequestEntity stringreq = new StringRequestEntity(GoogleLogin.getRequest(id, pwd, service));
            RequestOptions options = client.getDefaultRequestOptions();
            options.setContentType("application/x-www-form-urlencoded");
            ClientResponse response = client.post(URI, (RequestEntity)stringreq, options);
            String auth = GoogleLogin.read(response.getInputStream());
            response.release();
            return auth.split("\n")[2].replaceAll("Auth=", "auth=");
        }
        catch (CarbonException e) {
            log.error((Object)("Error reading content from Google Client Login for \"" + id + "\""), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Error parsing content from Google Client Login for \"" + id + "\""), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error reading getting content from Google Client Login for \"" + id + "\""), (Throwable)e);
        }
        return null;
    }

    private static String read(InputStream in) throws CarbonException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int n = -1;
        try {
            while ((n = in.read()) != -1) {
                out.write(n);
            }
            out.flush();
        }
        catch (IOException e) {
            throw new CarbonException((Throwable)e);
        }
        return new String(out.toByteArray());
    }

    private static String getRequest(String id, String pwd, String service) throws UnsupportedEncodingException {
        return "Email=" + URLEncoder.encode(id, UTF8) + "&Passwd=" + URLEncoder.encode(pwd, UTF8) + "&service=" + URLEncoder.encode(service, UTF8) + "&source=" + URLEncoder.encode("wso2-mashup-server", UTF8);
    }
}

