/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.javascript.hostobjects.atom;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.activation.MimeTypeParseException;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.iri.IRISyntaxException;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.abdera.parser.stax.util.FOMHelper;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.client.RequestOptions;
import org.apache.abdera.protocol.client.util.BaseRequestEntity;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.mashup.javascript.hostobjects.atom.AtomEntryHostObject;
import org.wso2.carbon.mashup.javascript.hostobjects.atom.AtomFeedHostObject;
import org.wso2.carbon.mashup.javascript.hostobjects.atom.GoogleLogin;
import org.wso2.javascript.xmlimpl.XML;

public class APPClientHostObject
extends ScriptableObject {
    private static final long serialVersionUID = 3210576127148634481L;
    private Abdera abdera = new Abdera();
    private String usernameString;
    private String passwordString;
    private String authenticationType = "basic";
    private String serviceString;
    private NativeObject nativeCredentials;
    private RequestOptions options;
    private AbderaClient client = new AbderaClient(this.abdera);

    public APPClientHostObject() {
        this.options = this.client.getDefaultRequestOptions();
    }

    public void jsConstructor() {
    }

    public String getClassName() {
        return "APPClient";
    }

    public void jsSet_credentials(Object object) throws CarbonException {
        Object authType;
        if (object instanceof NativeObject) {
            this.nativeCredentials = (NativeObject)object;
            Object username = ScriptableObject.getProperty((Scriptable)this.nativeCredentials, (String)"username");
            if (!(username instanceof String)) {
                throw new CarbonException("Username field needs to be a String.");
            }
            this.usernameString = (String)username;
            Object password = ScriptableObject.getProperty((Scriptable)this.nativeCredentials, (String)"password");
            if (!(password instanceof String)) {
                throw new CarbonException("Password field needs to be a String.");
            }
            this.passwordString = (String)password;
            Object service = ScriptableObject.getProperty((Scriptable)this.nativeCredentials, (String)"service");
            if (!(service instanceof String)) {
                throw new CarbonException("Service field needs to be a String.");
            }
            this.serviceString = (String)service;
            authType = ScriptableObject.getProperty((Scriptable)this.nativeCredentials, (String)"authtype");
            if (!(authType instanceof String)) {
                throw new CarbonException("Authnetication Type field needs to be a String.");
            }
        } else {
            throw new CarbonException("Invalid parameter");
        }
        this.authenticationType = (String)authType;
    }

    public Scriptable jsGet_credentials() {
        return this.nativeCredentials;
    }

    public void jsSet_options(Object object) {
    }

    public static Scriptable jsFunction_get(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        AtomEntryHostObject atomEntryHostObject;
        Entry entry;
        APPClientHostObject hostObject = (APPClientHostObject)thisObj;
        if (arguments.length == 0) {
            throw new CarbonException("Invalid parameter");
        }
        if (arguments[0] instanceof String) {
            ClientResponse clientResponse = hostObject.client.get((String)arguments[0], hostObject.options);
            Scriptable entryHostObject = cx.newObject((Scriptable)hostObject, "AtomEntry", new Object[0]);
            ((AtomEntryHostObject)entryHostObject).setEntry((Entry)clientResponse.getDocument().getRoot());
            return entryHostObject;
        }
        if (arguments[0] instanceof AtomEntryHostObject && (entry = (atomEntryHostObject = (AtomEntryHostObject)((Object)arguments[0])).getEntry()) != null) {
            IRI editUri = null;
            try {
                editUri = APPClientHostObject.getEditURI(entry);
                ClientResponse clientResponse = hostObject.client.get(editUri.toString());
                Scriptable entryHostObject = cx.newObject((Scriptable)hostObject, "AtomEntry", new Object[0]);
                ((AtomEntryHostObject)entryHostObject).setEntry((Entry)clientResponse.getDocument().getRoot());
                return entryHostObject;
            }
            catch (IRISyntaxException e) {
                throw new CarbonException((Throwable)e);
            }
        }
        return null;
    }

    public static synchronized Scriptable jsFunction_getFeed(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        AtomFeedHostObject atomFeedHostObject;
        Feed feed;
        APPClientHostObject hostObject = (APPClientHostObject)thisObj;
        if (arguments.length == 0) {
            throw new CarbonException("Invalid parameter");
        }
        if (arguments[0] instanceof String) {
            Feed feed2 = null;
            try {
                URL url = new URL((String)arguments[0]);
                feed2 = (Feed)Abdera.getNewParser().parse(url.openStream()).getRoot();
            }
            catch (IRISyntaxException e) {
                throw new CarbonException((Throwable)e);
            }
            catch (MalformedURLException e) {
                throw new CarbonException((Throwable)e);
            }
            catch (IOException e) {
                throw new CarbonException((Throwable)e);
            }
            Scriptable feedHostObject = cx.newObject((Scriptable)hostObject, "AtomFeed", new Object[0]);
            ((AtomFeedHostObject)feedHostObject).setFeed(feed2);
            return feedHostObject;
        }
        if (arguments[0] instanceof AtomFeedHostObject && (feed = (atomFeedHostObject = (AtomFeedHostObject)((Object)arguments[0])).getFeed()) != null) {
            IRI editUri = null;
            try {
                editUri = APPClientHostObject.getEditURI(feed);
                ClientResponse clientResponse = hostObject.client.get(editUri.toString());
                Scriptable feedHostObject = cx.newObject((Scriptable)hostObject, "AtomFeed", new Object[0]);
                ((AtomFeedHostObject)feedHostObject).setFeed((Feed)clientResponse.getDocument().getRoot());
                return feedHostObject;
            }
            catch (IRISyntaxException e) {
                throw new CarbonException((Throwable)e);
            }
            catch (MimeTypeParseException e) {
                throw new CarbonException((Throwable)e);
            }
        }
        return null;
    }

    public static Scriptable jsFunction_getForEdit(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        APPClientHostObject hostObject = (APPClientHostObject)thisObj;
        if (arguments.length == 0) {
            throw new CarbonException("Invalid parameter");
        }
        if (arguments[0] instanceof AtomEntryHostObject) {
            AtomEntryHostObject atomEntryHostObject = (AtomEntryHostObject)((Object)arguments[0]);
            Entry entry = atomEntryHostObject.getEntry();
            if (entry != null) {
                try {
                    IRI editUri = APPClientHostObject.getEditURI(entry);
                    ClientResponse clientResponse = hostObject.client.get(editUri.toString());
                    Scriptable entryHostObject = cx.newObject((Scriptable)hostObject, "AtomEntry", new Object[0]);
                    ((AtomEntryHostObject)entryHostObject).setEntry((Entry)clientResponse.getDocument().getRoot());
                    return entryHostObject;
                }
                catch (IRISyntaxException e) {
                    throw new CarbonException((Throwable)e);
                }
            }
            return null;
        }
        return null;
    }

    private static IRI getEditURI(Entry entry) throws CarbonException {
        IRI editUri = null;
        List editLinks = entry.getLinks("edit");
        for (Link link : editLinks) {
            if (link.getMimeType() != null) {
                try {
                    if (!link.getMimeType().match("application/atom+xml")) continue;
                    editUri = link.getResolvedHref();
                    break;
                }
                catch (MimeTypeParseException e) {
                    throw new CarbonException((Throwable)e);
                }
            }
            editUri = link.getResolvedHref();
            break;
        }
        return editUri;
    }

    private static IRI getEditURI(Feed feed) throws MimeTypeParseException, IRISyntaxException {
        IRI editUri = null;
        List editLinks = feed.getLinks("edit");
        for (Link link : editLinks) {
            if (link.getMimeType() != null) {
                if (!link.getMimeType().match("application/atom+xml")) continue;
                editUri = link.getResolvedHref();
                break;
            }
            editUri = link.getResolvedHref();
            break;
        }
        return editUri;
    }

    public static Scriptable jsFunction_post(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        APPClientHostObject hostObject = (APPClientHostObject)thisObj;
        if (arguments.length != 2) {
            throw new CarbonException("Invalid Number of Parameters");
        }
        if (arguments[1] instanceof AtomEntryHostObject) {
            AtomEntryHostObject atomEntryHostObject = (AtomEntryHostObject)((Object)arguments[1]);
            Entry entry = atomEntryHostObject.getEntry();
            Scriptable entryHostObject = APPClientHostObject.post(cx, arguments, hostObject, entry);
            return entryHostObject;
        }
        if (arguments[1] instanceof NativeObject) {
            try {
                Entry entry = hostObject.createEntry((NativeObject)arguments[1]);
                Scriptable entryHostObject = APPClientHostObject.post(cx, arguments, hostObject, entry);
                return entryHostObject;
            }
            catch (IRISyntaxException e) {
                throw new CarbonException((Throwable)e);
            }
        }
        throw new CarbonException("Invalid parameter");
    }

    private static Scriptable post(Context cx, Object[] arguments, APPClientHostObject hostObject, Entry entry) throws CarbonException {
        APPClientHostObject.performAuthentication(hostObject, (String)arguments[0]);
        ClientResponse response = hostObject.client.post((String)arguments[0], (RequestEntity)new BaseRequestEntity((Base)entry, false), hostObject.options);
        if (response.getStatus() != 201) {
            throw new CarbonException("Posting Failed." + response.getStatusText());
        }
        Scriptable entryHostObject = cx.newObject((Scriptable)hostObject, "AtomEntry", new Object[0]);
        ((AtomEntryHostObject)entryHostObject).setEntry(entry);
        return entryHostObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void jsFunction_put(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        String url;
        Entry entry;
        AtomEntryHostObject atomEntryHostObject;
        APPClientHostObject hostObject = (APPClientHostObject)thisObj;
        if (arguments.length == 2) {
            if (!(arguments[1] instanceof NativeObject)) throw new CarbonException("Invalid Parameter");
            try {
                if (arguments[1] instanceof AtomEntryHostObject) {
                    atomEntryHostObject = (AtomEntryHostObject)((Object)arguments[1]);
                    entry = atomEntryHostObject.getEntry();
                } else {
                    entry = hostObject.createEntry((NativeObject)arguments[1]);
                }
                url = (String)arguments[0];
            }
            catch (IRISyntaxException e) {
                throw new CarbonException((Throwable)e);
            }
        } else {
            if (arguments.length != 1) throw new CarbonException("Invalid Number of Parameters");
            if (!(arguments[0] instanceof AtomEntryHostObject)) throw new CarbonException("URI Parameter is Missing.");
            atomEntryHostObject = (AtomEntryHostObject)((Object)arguments[0]);
            entry = atomEntryHostObject.getEntry();
            url = APPClientHostObject.getEditURI(entry).toString();
        }
        APPClientHostObject.performAuthentication(hostObject, url);
        ClientResponse response = hostObject.client.put(url, (Base)entry, hostObject.options);
        if (response.getStatus() == 200) return;
        throw new CarbonException("Put Failed." + response.getStatusText());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void jsFunction_deleteEntry(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        String url;
        APPClientHostObject hostObject = (APPClientHostObject)thisObj;
        if (arguments.length != 1) throw new CarbonException("Invalid Number of Parameters");
        if (arguments[0] instanceof AtomEntryHostObject) {
            AtomEntryHostObject atomEntryHostObject = (AtomEntryHostObject)((Object)arguments[0]);
            Entry entry = atomEntryHostObject.getEntry();
            url = APPClientHostObject.getEditURI(entry).toString();
        } else {
            if (!(arguments[0] instanceof String)) throw new CarbonException("Invalid Parameter");
            url = (String)arguments[0];
        }
        APPClientHostObject.performAuthentication(hostObject, url);
        if (url == null) throw new CarbonException("Entry Cannot be deleted.");
        ClientResponse response = hostObject.client.delete(url, hostObject.options);
        if (response.getStatus() == 200) return;
        throw new CarbonException("Delete Failed." + response.getStatusText());
    }

    private Entry createEntry(NativeObject nativeEntry) throws CarbonException {
        Object rights;
        Object publishedProperty;
        Object linksProperty;
        Object idProperty;
        Object contributorsProperty;
        Object content;
        Object categoriesProperty;
        Object categoryProperty;
        Object authorsProperty;
        Factory factory = this.abdera.getFactory();
        Entry entry = factory.newEntry();
        Object authorProperty = ScriptableObject.getProperty((Scriptable)nativeEntry, (String)"author");
        if (authorProperty instanceof String) {
            entry.addAuthor((String)authorProperty);
        }
        if ((authorsProperty = ScriptableObject.getProperty((Scriptable)nativeEntry, (String)"authors")) instanceof String) {
            String authorsString = (String)authorProperty;
            String[] authors = authorsString.split(",");
            for (int i = 0; i < authors.length; ++i) {
                entry.addAuthor(authors[i]);
            }
        }
        if ((categoryProperty = ScriptableObject.getProperty((Scriptable)nativeEntry, (String)"category")) instanceof String) {
            entry.addCategory((String)categoryProperty);
        }
        if ((categoriesProperty = ScriptableObject.getProperty((Scriptable)nativeEntry, (String)"categories")) instanceof String) {
            String categoriesString = (String)categoriesProperty;
            String[] categories = categoriesString.split(",");
            for (int i = 0; i < categories.length; ++i) {
                entry.addCategory(categories[i]);
            }
        }
        if ((content = ScriptableObject.getProperty((Scriptable)nativeEntry, (String)"content")) instanceof XML) {
            entry.setContentAsXhtml(content.toString());
        } else if (content instanceof String) {
            entry.setContent((String)content);
        } else {
            throw new CarbonException("Unsupported Content");
        }
        Object contributorProperty = ScriptableObject.getProperty((Scriptable)nativeEntry, (String)"contributor");
        if (contributorProperty instanceof String) {
            entry.addContributor((String)contributorProperty);
        }
        if ((contributorsProperty = ScriptableObject.getProperty((Scriptable)nativeEntry, (String)"contributors")) instanceof String) {
            String contributorsString = (String)contributorsProperty;
            String[] contributors = contributorsString.split(",");
            for (int i = 0; i < contributors.length; ++i) {
                entry.addContributor(contributors[i]);
            }
        }
        if ((idProperty = ScriptableObject.getProperty((Scriptable)nativeEntry, (String)"id")) instanceof String) {
            entry.setId((String)idProperty);
        } else {
            entry.setId(FOMHelper.generateUuid());
        }
        Object linkProperty = ScriptableObject.getProperty((Scriptable)nativeEntry, (String)"link");
        if (linkProperty instanceof String) {
            entry.addLink((String)linkProperty);
        }
        if ((linksProperty = ScriptableObject.getProperty((Scriptable)nativeEntry, (String)"links")) instanceof String) {
            String linksString = (String)linksProperty;
            String[] links = linksString.split(",");
            for (int i = 0; i < links.length; ++i) {
                entry.addLink(links[i]);
            }
        }
        if ((publishedProperty = ScriptableObject.getProperty((Scriptable)nativeEntry, (String)"published")) instanceof String) {
            if (publishedProperty.equals("now")) {
                entry.setPublished(new Date(System.currentTimeMillis()));
            } else {
                entry.setPublished((String)publishedProperty);
            }
        }
        if ((rights = ScriptableObject.getProperty((Scriptable)nativeEntry, (String)"rights")) instanceof XML) {
            entry.setRightsAsXhtml(rights.toString());
        } else if (rights instanceof String) {
            entry.setRights((String)rights);
        }
        Object summary = ScriptableObject.getProperty((Scriptable)nativeEntry, (String)"summary");
        if (summary instanceof XML) {
            entry.setSummaryAsXhtml(summary.toString());
        } else if (summary instanceof String) {
            entry.setSummary((String)summary);
        }
        Object title = ScriptableObject.getProperty((Scriptable)nativeEntry, (String)"title");
        if (title instanceof XML) {
            entry.setTitleAsXhtml(title.toString());
        } else if (title instanceof String) {
            entry.setTitle((String)title);
        } else {
            throw new CarbonException("An Entry MUST have a title.");
        }
        Object updated = ScriptableObject.getProperty((Scriptable)nativeEntry, (String)"updated");
        if (updated instanceof String) {
            if (updated.equals("now")) {
                entry.setUpdated(new Date(System.currentTimeMillis()));
            } else {
                entry.setUpdated((String)updated);
            }
        }
        return entry;
    }

    private static void performAuthentication(APPClientHostObject hostObject, String uri) throws CarbonException {
        try {
            if (hostObject.authenticationType.compareToIgnoreCase("google") == 0) {
                String auth = GoogleLogin.getAuth(hostObject.client, hostObject.serviceString, hostObject.usernameString, hostObject.passwordString);
                RequestOptions options = hostObject.client.getDefaultRequestOptions();
                options.setAuthorization("GoogleLogin " + auth);
                hostObject.options = options;
            } else if (hostObject.authenticationType.compareToIgnoreCase("basic") == 0) {
                hostObject.client.addCredentials(uri, null, null, (Credentials)new UsernamePasswordCredentials(hostObject.usernameString, hostObject.passwordString));
            }
        }
        catch (URISyntaxException e) {
            throw new CarbonException((Throwable)e);
        }
    }
}

