/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.internal;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.logging.registry.RegistryManager;
import org.wso2.carbon.logging.util.LoggingUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.CarbonUtils;

public class LoggingServiceComponent {
    private static Log log = LogFactory.getLog(LoggingServiceComponent.class);
    private RegistryService registryService;
    private static RealmService realmService;

    protected void activate(ComponentContext ctxt) {
        try {
            this.initLoggingConfiguration();
            BundleContext bundleContext = ctxt.getBundleContext();
        }
        catch (Exception e) {
            log.error((Object)"Cannot  initialize logging configuration", (Throwable)e);
        }
    }

    public RealmService getRealmService() {
        return realmService;
    }

    protected void setRealmService(RealmService realmService) {
        LoggingServiceComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        this.setRealmService(null);
    }

    public static TenantManager getTenantManager() {
        return realmService.getTenantManager();
    }

    public static RealmConfiguration getBootstrapRealmConfiguration() {
        return realmService.getBootstrapRealmConfiguration();
    }

    protected void deactivate(ComponentContext ctxt) {
    }

    protected void setRegistryService(RegistryService registryService) {
        try {
            RegistryManager.setRegistry((Registry)registryService.getConfigSystemRegistry());
            this.registryService = registryService;
        }
        catch (Exception e) {
            log.error((Object)"Cannot  retrieve System Registry", (Throwable)e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        RegistryManager.setRegistry(null);
    }

    private void initLoggingConfiguration() throws Exception {
        long previousLastModified;
        File confFolder = new File(CarbonUtils.getCarbonConfigDirPath());
        String loggingPropFilePath = confFolder.getAbsolutePath() + File.separator + "log4j.properties";
        File log4jFile = new File(loggingPropFilePath);
        if (!log4jFile.isFile()) {
            LoggingUtil.removeAllLoggersAndAppenders();
            LoggingUtil.updateConfigurationProperty("log4j.file.not.found", "false");
            return;
        }
        LoggingUtil.updateConfigurationProperty("log4j.file.not.found", "true");
        long currentLastModified = log4jFile.lastModified();
        String lmStr = new RegistryManager().getConfigurationProperty("wso2carbon.system.log.last.modified");
        long l = previousLastModified = lmStr != null ? Long.parseLong(lmStr) : 0L;
        if (previousLastModified != currentLastModified) {
            LoggingUtil.updateConfigurationProperty("wso2carbon.system.log.last.modified", Long.toString(currentLastModified));
            LoggingUtil.removeAllLoggersAndAppenders();
        } else {
            LoggingUtil.loadCustomConfiguration();
        }
    }
}

