/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.logging.service.LogViewerException;
import org.wso2.carbon.utils.CarbonUtils;

public class ServiceConfigManager {
    private static final Log log = LogFactory.getLog(ServiceConfigManager.class);

    public static String[] getServiceNames() throws LogViewerException {
        String configFileName = CarbonUtils.getCarbonConfigDirPath() + File.separator + "multitenancy" + File.separator + "cloud-services-desc.xml";
        ArrayList<String> serviceNames = new ArrayList<String>();
        File configFile = new File(configFileName);
        if (configFile.exists()) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(configFile);
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                OMElement documentElement = builder.getDocumentElement();
                Iterator properties = documentElement.getChildrenWithName(new QName("cloudService"));
                while (properties.hasNext()) {
                    OMElement element = (OMElement)properties.next();
                    serviceNames.add(element.getAttributeValue(new QName("name")));
                }
            }
            catch (Exception e) {
                String msg = "Error in loading Stratos Configurations File: " + configFileName + ".";
                throw new LogViewerException(msg, e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Could not close the Configuration File " + configFileName));
                    }
                }
            }
        }
        return serviceNames.toArray(new String[serviceNames.size()]);
    }

    public static boolean isStratosService(String serviceName) throws LogViewerException {
        String[] services;
        for (String service : services = ServiceConfigManager.getServiceNames()) {
            if (!service.equals(serviceName)) continue;
            return true;
        }
        return false;
    }
}

