/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.logging.appender.CarbonMemoryAppender;
import org.wso2.carbon.logging.service.data.LogEvent;
import org.wso2.carbon.utils.logging.TenantAwareLoggingEvent;
import org.wso2.carbon.utils.logging.TenantAwarePatternLayout;

public class TenantAwareLogReader {
    private static Log log = LogFactory.getLog(TenantAwareLogReader.class);

    private boolean isCurrentTenantId(String tenantId) {
        String currTenantId = String.valueOf(CarbonContext.getCurrentContext().getTenantId());
        return currTenantId.equals(tenantId);
    }

    private boolean isCurrentProduct(String productName) {
        String currProductName = ServerConfiguration.getInstance().getFirstProperty("Name");
        return currProductName.equals(productName);
    }

    public LogEvent[] getLogs(String appName) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Just to see wether tracing works");
        }
        int DEFAULT_NO_OF_LOGS = 100;
        Appender appender = Logger.getRootLogger().getAppender("CARBON_MEMORY");
        if (appender instanceof CarbonMemoryAppender) {
            CarbonMemoryAppender memoryAppender = (CarbonMemoryAppender)appender;
            if (memoryAppender.getCircularQueue() == null) {
                return null;
            }
            int definedamount = memoryAppender.getBufferSize();
            Object[] objects = definedamount < 1 ? memoryAppender.getCircularQueue().getObjects(DEFAULT_NO_OF_LOGS) : memoryAppender.getCircularQueue().getObjects(definedamount);
            if (memoryAppender.getCircularQueue().getObjects(definedamount) == null || memoryAppender.getCircularQueue().getObjects(definedamount).length == 0) {
                return null;
            }
            ArrayList<LogEvent> resultList = new ArrayList<LogEvent>();
            for (int i = 0; i < objects.length; ++i) {
                TenantAwareLoggingEvent logEvt = (TenantAwareLoggingEvent)objects[i];
                if (logEvt == null) continue;
                TenantAwarePatternLayout tenantIdPattern = new TenantAwarePatternLayout("%T");
                TenantAwarePatternLayout productPattern = new TenantAwarePatternLayout("%S");
                String productName = productPattern.format((LoggingEvent)logEvt);
                String tenantId = tenantIdPattern.format((LoggingEvent)logEvt);
                if (!this.isCurrentTenantId(tenantId) || !this.isCurrentProduct(productName)) continue;
                if (appName == null || appName.equals("")) {
                    resultList.add(this.createLogEvent(logEvt));
                    continue;
                }
                TenantAwarePatternLayout appPattern = new TenantAwarePatternLayout("%A");
                String currAppName = appPattern.format((LoggingEvent)logEvt);
                if (!appName.equals(currAppName)) continue;
                resultList.add(this.createLogEvent(logEvt));
            }
            ArrayList<LogEvent> reverseList = this.reverseLogList(resultList);
            return reverseList.toArray(new LogEvent[reverseList.size()]);
        }
        return new LogEvent[]{new LogEvent("The log must be configured to use the org.wso2.carbon.logging.core.util.MemoryAppender to view entries on the admin console", "NA")};
    }

    public LogEvent[] searchLog(String type, String keyword, String appName) {
        if ("ALL".equalsIgnoreCase(type)) {
            return this.getLogsForKey(keyword, appName);
        }
        LogEvent[] filerByType = this.getLogsForType(type, appName);
        ArrayList<LogEvent> resultList = new ArrayList<LogEvent>();
        if (filerByType != null) {
            for (int i = 0; i < filerByType.length; ++i) {
                String logMessage = filerByType[i].getMessage();
                String logger = filerByType[i].getLogger();
                if (logMessage != null && logMessage.toLowerCase().indexOf(keyword.toLowerCase()) > -1) {
                    resultList.add(filerByType[i]);
                    continue;
                }
                if (logger == null || logger.toLowerCase().indexOf(keyword.toLowerCase()) <= -1) continue;
                resultList.add(filerByType[i]);
            }
        }
        if (resultList.isEmpty()) {
            return null;
        }
        ArrayList<LogEvent> reverseList = this.reverseLogList(resultList);
        return reverseList.toArray(new LogEvent[reverseList.size()]);
    }

    private ArrayList<LogEvent> reverseLogList(List<LogEvent> resultList) {
        ArrayList<LogEvent> reverseList = new ArrayList<LogEvent>(resultList.size());
        for (int i = resultList.size() - 1; i >= 0; --i) {
            reverseList.add(resultList.get(i));
        }
        return reverseList;
    }

    public LogEvent[] getLogsForKey(String keyword, String appName) {
        int DEFAULT_NO_OF_LOGS = 100;
        Appender appender = Logger.getRootLogger().getAppender("CARBON_MEMORY");
        if (appender instanceof CarbonMemoryAppender) {
            CarbonMemoryAppender memoryAppender = (CarbonMemoryAppender)appender;
            if (memoryAppender.getCircularQueue() == null) {
                return null;
            }
            int definedAmount = memoryAppender.getBufferSize();
            Object[] objects = definedAmount < 1 ? memoryAppender.getCircularQueue().getObjects(DEFAULT_NO_OF_LOGS) : memoryAppender.getCircularQueue().getObjects(definedAmount);
            if (memoryAppender.getCircularQueue().getObjects(definedAmount) == null || memoryAppender.getCircularQueue().getObjects(definedAmount).length == 0) {
                return null;
            }
            ArrayList<LogEvent> resultList = new ArrayList<LogEvent>();
            for (int i = 0; i < objects.length; ++i) {
                TenantAwareLoggingEvent logEvt = (TenantAwareLoggingEvent)objects[i];
                if (logEvt == null) continue;
                TenantAwarePatternLayout tenantIdPattern = new TenantAwarePatternLayout("%T");
                TenantAwarePatternLayout productPattern = new TenantAwarePatternLayout("%S");
                TenantAwarePatternLayout messagePattern = new TenantAwarePatternLayout("%m");
                String productName = productPattern.format((LoggingEvent)logEvt);
                String tenantId = tenantIdPattern.format((LoggingEvent)logEvt);
                String result = messagePattern.format((LoggingEvent)logEvt);
                if (!this.isCurrentTenantId(tenantId) || !this.isCurrentProduct(productName) || result == null || result.toLowerCase().indexOf(keyword.toLowerCase()) <= -1) continue;
                if (appName == null || appName.equals("")) {
                    resultList.add(this.createLogEvent(logEvt));
                    continue;
                }
                TenantAwarePatternLayout appPattern = new TenantAwarePatternLayout("%A");
                String currAppName = appPattern.format((LoggingEvent)logEvt);
                if (!appName.equals(currAppName)) continue;
                resultList.add(this.createLogEvent(logEvt));
            }
            if (resultList.isEmpty()) {
                return null;
            }
            ArrayList<LogEvent> reverseList = this.reverseLogList(resultList);
            return reverseList.toArray(new LogEvent[reverseList.size()]);
        }
        return new LogEvent[]{new LogEvent("The log must be configured to use the org.wso2.carbon.logging.core.util.MemoryAppender to view entries on the admin console", "NA")};
    }

    public String[] getApplicationNames() {
        LogEvent[] allLogs;
        ArrayList<String> appList = new ArrayList<String>();
        for (LogEvent event : allLogs = this.getLogs("")) {
            if (event.getAppName() == null || event.getAppName().equals("") || appList.contains(event.getAppName())) continue;
            appList.add(event.getAppName());
        }
        return appList.toArray(new String[appList.size()]);
    }

    public LogEvent[] getLogsForType(String type, String appName) {
        int DEFAULT_NO_OF_LOGS = 100;
        Appender appender = Logger.getRootLogger().getAppender("CARBON_MEMORY");
        if (appender instanceof CarbonMemoryAppender) {
            CarbonMemoryAppender memoryAppender = (CarbonMemoryAppender)appender;
            if (memoryAppender.getCircularQueue() == null) {
                return null;
            }
            int definedAmount = memoryAppender.getBufferSize();
            Object[] objects = definedAmount < 1 ? memoryAppender.getCircularQueue().getObjects(DEFAULT_NO_OF_LOGS) : memoryAppender.getCircularQueue().getObjects(definedAmount);
            if (memoryAppender.getCircularQueue().getObjects(definedAmount) == null || memoryAppender.getCircularQueue().getObjects(definedAmount).length == 0) {
                return null;
            }
            ArrayList<LogEvent> resultList = new ArrayList<LogEvent>();
            for (int i = 0; i < objects.length; ++i) {
                TenantAwareLoggingEvent logEvt = (TenantAwareLoggingEvent)objects[i];
                if (logEvt == null) continue;
                TenantAwarePatternLayout tenantIdPattern = new TenantAwarePatternLayout("%T");
                TenantAwarePatternLayout productPattern = new TenantAwarePatternLayout("%S");
                TenantAwarePatternLayout messagePattern = new TenantAwarePatternLayout("%m");
                TenantAwarePatternLayout loggerPattern = new TenantAwarePatternLayout("%c");
                String productName = productPattern.format((LoggingEvent)logEvt);
                String tenantId = tenantIdPattern.format((LoggingEvent)logEvt);
                if ((!messagePattern.toString().equals(type) || !this.isCurrentTenantId(tenantId) || !this.isCurrentProduct(productName)) && (!loggerPattern.toString().equals(type) || !this.isCurrentTenantId(tenantId) || !this.isCurrentProduct(productName))) continue;
                if (appName == null || appName.equals("")) {
                    resultList.add(this.createLogEvent(logEvt));
                    continue;
                }
                TenantAwarePatternLayout appPattern = new TenantAwarePatternLayout("%A");
                String currAppName = appPattern.format((LoggingEvent)logEvt);
                if (!appName.equals(currAppName)) continue;
                resultList.add(this.createLogEvent(logEvt));
            }
            if (resultList.isEmpty()) {
                return null;
            }
            ArrayList<LogEvent> reverseList = this.reverseLogList(resultList);
            return reverseList.toArray(new LogEvent[reverseList.size()]);
        }
        return new LogEvent[]{new LogEvent("The log must be configured to use the org.wso2.carbon.logging.core.util.MemoryAppender to view entries through the admin console", "")};
    }

    private LogEvent createLogEvent(TenantAwareLoggingEvent logEvt) {
        Appender appender = Logger.getRootLogger().getAppender("CARBON_MEMORY");
        CarbonMemoryAppender memoryAppender = (CarbonMemoryAppender)appender;
        List<String> patterns = Arrays.asList(memoryAppender.getColumnList().split(","));
        String tenantID = null;
        String serverName = null;
        String appName = null;
        String logTime = null;
        String logger = null;
        String priority = null;
        String message = null;
        String stacktrace = null;
        String ip = null;
        String instance = null;
        Iterator<String> j = patterns.iterator();
        while (j.hasNext()) {
            String currEle = j.next().replace("%", "");
            TenantAwarePatternLayout patternLayout = new TenantAwarePatternLayout("%" + currEle);
            if (currEle.equals("T")) {
                tenantID = patternLayout.format((LoggingEvent)logEvt);
                continue;
            }
            if (currEle.equals("S")) {
                serverName = patternLayout.format((LoggingEvent)logEvt);
                continue;
            }
            if (currEle.equals("A")) {
                appName = patternLayout.format((LoggingEvent)logEvt);
                continue;
            }
            if (currEle.equals("d")) {
                logTime = patternLayout.format((LoggingEvent)logEvt);
                continue;
            }
            if (currEle.equals("c")) {
                logger = patternLayout.format((LoggingEvent)logEvt);
                continue;
            }
            if (currEle.equals("p")) {
                priority = patternLayout.format((LoggingEvent)logEvt);
                continue;
            }
            if (currEle.equals("m")) {
                message = patternLayout.format((LoggingEvent)logEvt);
                continue;
            }
            if (currEle.equals("I")) {
                instance = patternLayout.format((LoggingEvent)logEvt);
                continue;
            }
            if (currEle.equals("Stacktrace")) {
                if (logEvt.getThrowableInformation() != null) {
                    stacktrace = this.getStacktrace(logEvt.getThrowableInformation().getThrowable());
                    continue;
                }
                stacktrace = "";
                continue;
            }
            if (!currEle.equals("H")) continue;
            ip = patternLayout.format((LoggingEvent)logEvt);
        }
        return new LogEvent(tenantID, serverName, appName, logTime, logger, priority, message, ip, stacktrace, instance);
    }

    private String getStacktrace(Throwable e) {
        StackTraceElement[] stackTraceElements;
        StringBuilder stackTrace = new StringBuilder();
        for (StackTraceElement ele : stackTraceElements = e.getStackTrace()) {
            stackTrace.append(ele.toString()).append("\n");
        }
        return stackTrace.toString();
    }
}

