/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.util;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.activation.DataHandler;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.net.SyslogAppender;
import org.springframework.util.Log4jConfigurer;
import org.wso2.carbon.logging.appender.CarbonMemoryAppender;
import org.wso2.carbon.logging.appenders.CircularBuffer;
import org.wso2.carbon.logging.registry.RegistryManager;
import org.wso2.carbon.logging.service.LogViewerException;
import org.wso2.carbon.logging.service.data.LogEvent;
import org.wso2.carbon.logging.service.data.LogInfo;
import org.wso2.carbon.logging.service.data.SyslogData;
import org.wso2.carbon.logging.util.LoggingReader;
import org.wso2.carbon.logging.util.TenantAwareLogReader;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.utils.Pageable;

public class LoggingUtil {
    private static RegistryManager registryManager = new RegistryManager();
    private static LoggingReader loggingReader = new LoggingReader();
    private static TenantAwareLogReader tenantAwareLogReader = new TenantAwareLogReader();
    public static final String SYSTEM_LOG_PATTERN = "[%d] %5p - %x %m {%c}%n";
    private static final int MAX_LOG_MESSAGES = 200;

    public static LogEvent[] getLogs(String appName) {
        return tenantAwareLogReader.getLogs(appName);
    }

    public static LogEvent[] searchLog(String type, String keyword, String appName) {
        return tenantAwareLogReader.searchLog(type, keyword, appName);
    }

    public static LogEvent[] getLogsForKey(String keyword, String appName) {
        return tenantAwareLogReader.getLogsForKey(keyword, appName);
    }

    public static LogEvent[] getLogsForType(String type, String appName) {
        return tenantAwareLogReader.getLogsForType(type, appName);
    }

    public static boolean isStratosService() throws Exception {
        return loggingReader.isStratosService();
    }

    public static String[] getApplicationNames() {
        return tenantAwareLogReader.getApplicationNames();
    }

    public static void setSystemLoggingParameters(String logLevel, String logPattern) throws Exception {
        registryManager.updateConfigurationProperty("wso2carbon.system.log.level", logLevel);
        registryManager.updateConfigurationProperty("wso2carbon.system.log.pattern", logPattern);
    }

    public static SyslogData getSyslogData() throws Exception {
        return registryManager.getSyslogData();
    }

    public static LogInfo[] getLogsIndex(String tenantDomain, String serviceName) throws Exception {
        return loggingReader.getLogsIndex(tenantDomain, serviceName);
    }

    public static LogInfo[] getLocalLogInfo() {
        return loggingReader.getLocalLogInfo();
    }

    public static String getSystemLogLevel() throws Exception {
        String systemLogLevel = registryManager.getConfigurationProperty("wso2carbon.system.log.level");
        if (systemLogLevel == null) {
            return Logger.getRootLogger().getLevel().toString();
        }
        return systemLogLevel;
    }

    public static String getSystemLogPattern() throws Exception {
        String systemLogPattern = registryManager.getConfigurationProperty("wso2carbon.system.log.pattern");
        if (systemLogPattern == null) {
            return SYSTEM_LOG_PATTERN;
        }
        return systemLogPattern;
    }

    public static boolean isValidTenantDomain(String tenantDomain) {
        return loggingReader.isValidTenantDomain(tenantDomain);
    }

    public static void restoreDefaults() throws Exception {
        registryManager.removeAllRegistryEntries();
        LogManager.resetConfiguration();
        try {
            Log4jConfigurer.initLogging((String)"classpath:log4j.properties");
        }
        catch (FileNotFoundException e) {
            String msg = "Cannot restore default logging configuration. log4j.properties file not found in the classpath";
            throw new Exception(msg, e);
        }
    }

    public static DataHandler downloadLogFiles(String logFile, String tenantDomain, String serviceName) throws LogViewerException {
        return loggingReader.downloadLogFiles(logFile, tenantDomain, serviceName);
    }

    public static boolean isManager() {
        return loggingReader.isManager();
    }

    public static void loadCustomConfiguration() throws Exception {
        Collection appenderCollection;
        Collection loggerCollection;
        String persistedSystemLogPattern;
        boolean systemLogLevelChanged;
        HashSet<Appender> appenderSet = new HashSet<Appender>();
        Logger rootLogger = LogManager.getRootLogger();
        String persistedSystemLoggerLevel = registryManager.getConfigurationProperty("wso2carbon.system.log.level");
        boolean bl = systemLogLevelChanged = persistedSystemLoggerLevel != null;
        if (systemLogLevelChanged) {
            rootLogger.setLevel(Level.toLevel((String)persistedSystemLoggerLevel));
        }
        boolean systemLogPatternChanged = (persistedSystemLogPattern = registryManager.getConfigurationProperty("wso2carbon.system.log.pattern")) != null;
        LoggingUtil.setSystemLoggingParameters(persistedSystemLoggerLevel, systemLogPatternChanged ? persistedSystemLogPattern : SYSTEM_LOG_PATTERN);
        LoggingUtil.addAppendersToSet(rootLogger.getAllAppenders(), appenderSet);
        if (systemLogLevelChanged) {
            Enumeration loggersEnum = LogManager.getCurrentLoggers();
            Level systemLevel = Level.toLevel((String)persistedSystemLoggerLevel);
            while (loggersEnum.hasMoreElements()) {
                Logger logger = (Logger)loggersEnum.nextElement();
                LoggingUtil.addAppendersToSet(logger.getAllAppenders(), appenderSet);
                logger.setLevel(systemLevel);
            }
            for (Appender appender : appenderSet) {
                if (!(appender instanceof AppenderSkeleton)) continue;
                AppenderSkeleton appenderSkeleton = (AppenderSkeleton)appender;
                appenderSkeleton.setThreshold((Priority)systemLevel);
                appenderSkeleton.activateOptions();
            }
        }
        if ((loggerCollection = registryManager.getLoggers()) != null) {
            String[] loggerResourcePaths;
            for (String loggerResourcePath : loggerResourcePaths = loggerCollection.getChildren()) {
                String loggerName = loggerResourcePath.substring("/repository/components/org.wso2.carbon.logging/loggers/".length());
                Logger logger = LogManager.getLogger((String)loggerName);
                Resource loggerResource = registryManager.getLogger(loggerName);
                if (loggerResource == null || logger == null) continue;
                logger.setLevel(Level.toLevel((String)loggerResource.getProperty("log.level")));
                logger.setAdditivity(Boolean.parseBoolean(loggerResource.getProperty("additivity")));
            }
        }
        if ((appenderCollection = registryManager.getAppenders()) != null) {
            String[] appenderResourcePaths;
            for (String appenderResourcePath : appenderResourcePaths = appenderCollection.getChildren()) {
                String appenderName = appenderResourcePath.substring("/repository/components/org.wso2.carbon.logging/appenders/".length());
                Appender appender = LoggingUtil.getAppenderFromSet(appenderSet, appenderName);
                Resource appenderResource = registryManager.getAppender(appenderName);
                if (appenderResource == null || appender == null) continue;
                if (appender.getLayout() != null && appender.getLayout() instanceof PatternLayout) {
                    ((PatternLayout)appender.getLayout()).setConversionPattern(appenderResource.getProperty("pattern"));
                }
                if (appender instanceof FileAppender) {
                    FileAppender fileAppender = (FileAppender)appender;
                    fileAppender.setFile(appenderResource.getProperty("log.file.name"));
                    fileAppender.activateOptions();
                }
                if (appender instanceof CarbonMemoryAppender) {
                    CarbonMemoryAppender memoryAppender = (CarbonMemoryAppender)appender;
                    memoryAppender.setCircularBuffer(new CircularBuffer(200));
                    memoryAppender.activateOptions();
                }
                if (appender instanceof SyslogAppender) {
                    SyslogAppender syslogAppender = (SyslogAppender)appender;
                    syslogAppender.setSyslogHost(appenderResource.getProperty("sys.log.host"));
                    syslogAppender.setFacility(appenderResource.getProperty("facility"));
                }
                if (!(appender instanceof AppenderSkeleton)) continue;
                AppenderSkeleton appenderSkeleton = (AppenderSkeleton)appender;
                appenderSkeleton.setThreshold((Priority)Level.toLevel((String)appenderResource.getProperty("threshold")));
                appenderSkeleton.activateOptions();
            }
        }
    }

    private static void addAppendersToSet(Enumeration appenders, Set<Appender> appenderSet) {
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            appenderSet.add(appender);
        }
    }

    public static Appender getAppenderFromSet(Set<Appender> appenderSet, String name) {
        for (Appender appender : appenderSet) {
            if (!appender.getName().equals(name)) continue;
            return appender;
        }
        return null;
    }

    public static void updateConfigurationProperty(String key, String value) throws RegistryException {
        registryManager.updateConfigurationProperty(key, value);
    }

    public static String getConfigurationProperty(String key) throws RegistryException {
        return registryManager.getConfigurationProperty(key);
    }

    public static void removeAllLoggersAndAppenders() throws Exception {
        registryManager.removeAllRegistryEntries();
    }

    public static boolean isSysLogAppender(String tenantDomain) throws Exception {
        int tenantId = loggingReader.getTenantIdForDomain(tenantDomain);
        return loggingReader.isSysLogAppender(tenantId);
    }

    public static boolean isSyslogConfigured() throws Exception {
        return registryManager.getSyslogConfig() != null;
    }

    public static int getLineNumbers(String logFile, String tenantDomain, String serviceName) throws Exception {
        return loggingReader.getLineNumbers(logFile, tenantDomain, serviceName);
    }

    public static String[] getLogLinesFromFile(String logFile, int maxLogs, int start, int end, String tenantId, String serviceName) throws LogViewerException {
        return loggingReader.getLogLinesFromFile(logFile, maxLogs, start, end, tenantId, serviceName);
    }

    public static <C> List<C> doPaging(int pageNumber, List<C> sourceList, int maxLines, Pageable pageable) {
        if (pageNumber < 0 || pageNumber == Integer.MAX_VALUE) {
            pageNumber = 0;
        }
        if (sourceList.size() == 0) {
            return sourceList;
        }
        if (pageNumber < 0) {
            throw new RuntimeException("Page number should be a positive integer. Page numbers begin at 0.");
        }
        int itemsPerPageInt = 200;
        int numberOfPages = (int)Math.ceil((double)maxLines / (double)itemsPerPageInt);
        if (pageNumber > numberOfPages - 1) {
            pageNumber = numberOfPages - 1;
        }
        ArrayList<C> returnList = new ArrayList<C>();
        for (int i = 0; i < sourceList.size(); ++i) {
            returnList.add(sourceList.get(i));
        }
        int pages = LoggingUtil.calculatePageLevel(pageNumber + 1);
        if (pages > numberOfPages) {
            pages = numberOfPages;
        }
        pageable.setNumberOfPages(pages);
        pageable.set(returnList);
        return returnList;
    }

    private static int calculatePageLevel(int x) {
        int p = x / 5;
        int q = x % 5;
        int t = (p + 1) * 5;
        int s = p * 5 + 1;
        int y = q > 0 ? t : s;
        return y;
    }
}

