/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.appender;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.carbon.context.ApplicationContext;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.logging.appenders.CircularBuffer;
import org.wso2.carbon.utils.logging.TenantAwareLoggingEvent;

public class CarbonMemoryAppender
extends AppenderSkeleton {
    private CircularBuffer circularBuffer;
    private int bufferSize = -1;
    private String columnList;

    public String getColumnList() {
        return this.columnList;
    }

    public void setColumnList(String columnList) {
        this.columnList = columnList;
    }

    public CarbonMemoryAppender() {
    }

    public CarbonMemoryAppender(CircularBuffer circularBuffer) {
        this.circularBuffer = circularBuffer;
    }

    protected void append(LoggingEvent loggingEvent) {
        Logger logger = Logger.getLogger((String)loggingEvent.getLoggerName());
        TenantAwareLoggingEvent tenantEvent = loggingEvent.getThrowableInformation() != null ? new TenantAwareLoggingEvent(loggingEvent.fqnOfCategoryClass, (Category)logger, loggingEvent.timeStamp, (Priority)loggingEvent.getLevel(), loggingEvent.getMessage(), loggingEvent.getThrowableInformation().getThrowable()) : new TenantAwareLoggingEvent(loggingEvent.fqnOfCategoryClass, (Category)logger, loggingEvent.timeStamp, (Priority)loggingEvent.getLevel(), loggingEvent.getMessage(), null);
        tenantEvent.setTenantId(Integer.toString(CarbonContext.getCurrentContext().getTenantId()));
        tenantEvent.setServiceName(ApplicationContext.getCurrentApplicationContext().getApplicationName());
        if (this.circularBuffer != null) {
            this.circularBuffer.append((Object)tenantEvent);
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    public CircularBuffer getCircularQueue() {
        return this.circularBuffer;
    }

    public void setCircularBuffer(CircularBuffer circularBuffer) {
        this.circularBuffer = circularBuffer;
    }

    public void activateOptions() {
        if (this.bufferSize < 0) {
            if (this.circularBuffer == null) {
                this.circularBuffer = new CircularBuffer();
            }
        } else {
            this.circularBuffer = new CircularBuffer(this.bufferSize);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

