/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import me.prettyprint.cassandra.serializers.StringSerializer;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.logging.config.ServiceConfigManager;
import org.wso2.carbon.logging.config.SyslogConfigManager;
import org.wso2.carbon.logging.config.SyslogConfiguration;
import org.wso2.carbon.logging.internal.LoggingServiceComponent;
import org.wso2.carbon.logging.service.LogViewerException;
import org.wso2.carbon.logging.service.data.LogInfo;
import org.wso2.carbon.logging.service.data.LogMessage;
import org.wso2.carbon.logging.service.data.SyslogData;
import org.wso2.carbon.logging.util.LoggingUtil;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.CarbonUtils;

public class LoggingReader {
    private static Log log = LogFactory.getLog(LoggingReader.class);
    private static final StringSerializer stringSerializer = StringSerializer.get();
    private static final LogMessage[] NO_LOGS_MESSAGE = new LogMessage[]{new LogMessage("NO_LOGS", "INFO")};
    private static final LogInfo[] NO_LOGS_INFO = new LogInfo[]{new LogInfo("NO_LOG_FILES", "---", "---")};

    public LogInfo[] getLogsIndex(String tenantDomain, String serviceName) throws LogViewerException {
        LogInfo[] logIndex;
        int tenantId = this.getTenantIdForDomain(tenantDomain);
        if (this.isSyslogOn()) {
            logIndex = this.getLogInfo(tenantId, serviceName);
        } else if (this.isSuperTenantUser()) {
            logIndex = this.getLocalLogInfo();
        } else {
            return null;
        }
        return logIndex;
    }

    public LogMessage[] getTenantLogs(String type, String keyword, String logFile, String logIndex, int maxLines, int start, int end, String tenantDomain, String serviceName) throws LogViewerException {
        int tenantId = this.getTenantIdForDomain(tenantDomain);
        if (keyword == null || keyword.equals("")) {
            if (type == null || type.equals("") || type.equalsIgnoreCase("ALL")) {
                return this.getHeadLogs(logIndex, this.getTenantLogMessages(logFile, maxLines, start - 1, end, tenantId, serviceName));
            }
            return this.getTenantLogsForType(type, logFile, logIndex, maxLines, start, end, tenantId, serviceName);
        }
        if (type == null || type.equals("")) {
            return this.getTenantLogsForKey(keyword, logFile, logIndex, maxLines, start, end, tenantId, serviceName);
        }
        return this.searchTenantLog(type, keyword, logFile, logIndex, maxLines, start, end, tenantId, serviceName);
    }

    public LogMessage[] getBottomUpTenantLogs(String type, String keyword, String logFile, int maxLines, int start, int end, String tenantDomain, String serviceName) throws LogViewerException {
        int tenantId = this.getTenantIdForDomain(tenantDomain);
        if (keyword == null || keyword.equals("")) {
            if (type == null || type.equals("") || type.equalsIgnoreCase("ALL")) {
                return this.getBottomUpLogMessages(logFile, maxLines, start, end, tenantId, serviceName);
            }
            return this.getBottomUpLogsForType(type, logFile, maxLines, start, end, tenantId, serviceName);
        }
        if (type == null || type.equals("")) {
            return this.getBottomUpLogsForKey(keyword, logFile, maxLines, start, end, tenantId, serviceName);
        }
        return this.searchBottomUpLogsTenantLog(type, keyword, logFile, maxLines, start, end, tenantId, serviceName);
    }

    public DataHandler downloadLogFiles(String logFile, String tenantDomain, String serviceName) throws LogViewerException {
        InputStream is;
        int tenantId = this.getTenantIdForDomain(tenantDomain);
        try {
            is = this.getInputStream(logFile, tenantId, serviceName);
        }
        catch (LogViewerException e) {
            throw new LogViewerException("Cannot read InputStream from the file " + logFile, e);
        }
        try {
            DataHandler dataHandler;
            ByteArrayDataSource bytArrayDS = new ByteArrayDataSource(is, "application/zip");
            DataHandler dataHandler2 = dataHandler = new DataHandler((DataSource)bytArrayDS);
            return dataHandler2;
        }
        catch (IOException e) {
            throw new LogViewerException("Cannot read file size from the " + logFile, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new LogViewerException("Cannot close the input stream " + logFile, e);
            }
        }
    }

    public String[] getLogLinesFromFile(String logFile, int maxLogs, int start, int end, String tenantDomain, String serviceName) throws LogViewerException {
        InputStream logStream;
        int tenantId = this.getTenantIdForDomain(tenantDomain);
        ArrayList<String> logsList = new ArrayList<String>();
        if (end > maxLogs) {
            end = maxLogs;
        }
        try {
            logStream = this.getInputStream(logFile, tenantId, serviceName);
        }
        catch (Exception e) {
            throw new LogViewerException("Cannot find the specified file location to the log file", e);
        }
        BufferedReader dataInput = new BufferedReader(new InputStreamReader(logStream));
        int index = 1;
        try {
            String line;
            while ((line = dataInput.readLine()) != null) {
                if (index <= end && index > start) {
                    logsList.add(line);
                }
                ++index;
            }
            dataInput.close();
        }
        catch (IOException e) {
            throw new LogViewerException("Cannot read the log file", e);
        }
        return logsList.toArray(new String[logsList.size()]);
    }

    public int getLineNumbers(String logFile, String tenantDomain, String serviceName) throws Exception {
        InputStream is;
        int tenantId = this.getTenantIdForDomain(tenantDomain);
        try {
            is = this.getInputStream(logFile, tenantId, serviceName);
        }
        catch (LogViewerException e) {
            throw new LogViewerException("Cannot read InputStream from the file " + logFile, e);
        }
        try {
            byte[] c = new byte[1024];
            int count = 0;
            int readChars = 0;
            while ((readChars = is.read(c)) != -1) {
                for (int i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
            }
            int n = count;
            return n;
        }
        catch (IOException e) {
            throw new LogViewerException("Cannot read file size from the " + logFile, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new LogViewerException("Cannot close the input stream " + logFile, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogLine(String logFile, int lineNo, String tenantDomain, String serviceName) throws LogViewerException {
        InputStream is;
        try {
            int tenantId = this.getTenantIdForDomain(tenantDomain);
            is = this.getInputStream(logFile, tenantId, serviceName);
        }
        catch (Exception e) {
            throw new LogViewerException("Cannot read InputStream from the file " + logFile, e);
        }
        BufferedReader dataInput = new BufferedReader(new InputStreamReader(is));
        try {
            int count = 1;
            while (true) {
                try {
                    String line = dataInput.readLine();
                    if (line == null) return null;
                    if (count == lineNo) {
                        String string = line;
                        return string;
                    }
                }
                catch (IOException e) {
                    throw new LogViewerException("Cannot read line number from the " + logFile, e);
                }
                {
                    ++count;
                    continue;
                }
                break;
            }
        }
        finally {
            try {
                dataInput.close();
                is.close();
            }
            catch (IOException e) {
                throw new LogViewerException("Cannot close the input stream " + logFile, e);
            }
        }
    }

    public boolean isSysLogAppender(int tenantId) throws LogViewerException {
        return this.isSyslogOn();
    }

    public boolean isValidTenantDomain(String tenantDomain) {
        try {
            this.getTenantIdForDomain(tenantDomain);
            return true;
        }
        catch (LogViewerException e) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String getLogsServerURLforTenantService(String syslogServerURL, String logFile, int tenantId, String serviceName) throws LogViewerException {
        serverurl = "";
        lastChar = String.valueOf(syslogServerURL.charAt(syslogServerURL.length() - 1));
        if (lastChar.equals("/")) {
            syslogServerURL = syslogServerURL.substring(0, syslogServerURL.length() - 1);
        }
        if (this.isSuperTenantUser()) {
            if (this.isManager()) {
                serverurl = serviceName != null && serviceName.length() > 0 ? syslogServerURL + "/" + tenantId + "/" + serviceName + "/" : syslogServerURL + "/" + tenantId + "/" + "WSO2 Stratos Manager" + "/";
                try {
                    if (this.isStratosService()) ** GOTO lbl17
                    serverurl = syslogServerURL + "/" + tenantId + "/" + ServerConfiguration.getInstance().getFirstProperty("Name") + "/";
                }
                catch (LogViewerException e) {
                    throw new LogViewerException("Cannot get log ServerURL for Tenant Service", e);
                }
            } else {
                serverurl = syslogServerURL + "/" + tenantId + "/" + ServerConfiguration.getInstance().getFirstProperty("Name") + "/";
            }
        } else {
            serverurl = this.isManager() ? (serviceName != null && serviceName.length() > 0 ? syslogServerURL + "/" + CarbonContext.getCurrentContext().getTenantId() + "/" + serviceName + "/" : syslogServerURL + "/" + CarbonContext.getCurrentContext().getTenantId() + "/" + "WSO2 Stratos Manager" + "/") : syslogServerURL + "/" + CarbonContext.getCurrentContext().getTenantId() + "/" + ServerConfiguration.getInstance().getFirstProperty("Name") + "/";
        }
lbl17:
        // 4 sources

        serverurl = serverurl.replaceAll("\\s", "%20");
        logFile = logFile.replaceAll("\\s", "%20");
        return serverurl + logFile;
    }

    public boolean isStratosService() throws LogViewerException {
        String serviceName = ServerConfiguration.getInstance().getFirstProperty("Name");
        return ServiceConfigManager.isStratosService(serviceName);
    }

    public boolean isManager() {
        return "WSO2 Stratos Manager".equals(ServerConfiguration.getInstance().getFirstProperty("Name"));
    }

    private InputStream getLogDataStream(String logFile, int tenantId, String productName) throws Exception {
        SyslogData syslogData = this.getSyslogData();
        String url = "";
        url = this.getLogsServerURLforTenantService(syslogData.getUrl(), logFile, tenantId, productName);
        String password = syslogData.getPassword();
        String userName = syslogData.getUserName();
        int port = Integer.parseInt(syslogData.getPort());
        String realm = syslogData.getRealm();
        URI uri = new URI(url);
        String host = uri.getHost();
        HttpClient client = new HttpClient();
        client.getState().setCredentials(new AuthScope(host, port, realm), (Credentials)new UsernamePasswordCredentials(userName, password));
        GetMethod get = new GetMethod(url);
        get.setDoAuthentication(true);
        client.executeMethod((HttpMethod)get);
        return get.getResponseBodyAsStream();
    }

    private LogMessage[] getHeadLogs(String logIndex, LogMessage[] allLogs) throws LogViewerException {
        try {
            int index = Integer.parseInt(logIndex) + 1;
            int maxLen = index > allLogs.length || index == -1 ? allLogs.length : index;
            LogMessage[] headLogs = new LogMessage[maxLen];
            for (int i = 0; i < maxLen; ++i) {
                headLogs[i] = allLogs[i];
            }
            return headLogs;
        }
        catch (Exception e) {
            throw new LogViewerException("Cannot retrieve logs for bottom up", e);
        }
    }

    private LogInfo[] getSortedLogInfo(LogInfo[] logs) {
        int maxLen = logs.length;
        if (maxLen > 0) {
            List<LogInfo> logInfoList = Arrays.asList(logs);
            Collections.sort(logInfoList, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    LogInfo log1 = (LogInfo)o1;
                    LogInfo log2 = (LogInfo)o2;
                    return log1.getLogName().compareToIgnoreCase(log2.getLogName());
                }
            });
            return logInfoList.toArray(new LogInfo[logInfoList.size()]);
        }
        return NO_LOGS_INFO;
    }

    private LogMessage[] getBottomUpLogsForType(String type, String logFile, int maxLogs, int start, int end, int tenantId, String serviceName) throws LogViewerException {
        ArrayList<LogMessage> resultList = new ArrayList<LogMessage>();
        LogMessage[] allLogs = this.getBottomUpLogMessages(logFile, maxLogs, start, end, tenantId, serviceName);
        for (int i = 0; i < allLogs.length; ++i) {
            LogMessage tempLog = allLogs[i];
            if (tempLog == null || !type.equals(tempLog.getType().trim())) continue;
            resultList.add(tempLog);
        }
        if (resultList.size() > 0) {
            return resultList.toArray(new LogMessage[resultList.size()]);
        }
        return NO_LOGS_MESSAGE;
    }

    private LogMessage[] getBottomUpLogsForKey(String keyword, String logFile, int maxLines, int start, int end, int tenantId, String serviceName) throws LogViewerException {
        ArrayList<LogMessage> resultList = new ArrayList<LogMessage>();
        LogMessage[] allLogs = this.getBottomUpLogMessages(logFile, maxLines, start, end, tenantId, serviceName);
        for (int i = 0; i < allLogs.length; ++i) {
            String message;
            LogMessage tempLog = allLogs[i];
            if (tempLog == null || (message = tempLog.getLogMessage()) == null || message.toLowerCase().indexOf(keyword.toLowerCase()) <= -1) continue;
            resultList.add(tempLog);
        }
        if (resultList.size() > 0) {
            return resultList.toArray(new LogMessage[resultList.size()]);
        }
        return NO_LOGS_MESSAGE;
    }

    public boolean isSuperTenantUser() {
        CarbonContext carbonContext = CarbonContext.getCurrentContext();
        int tenantId = carbonContext.getTenantId();
        return tenantId == -1234;
    }

    private SyslogData getSyslogData() throws Exception {
        return LoggingUtil.getSyslogData();
    }

    private boolean isSyslogOn() {
        SyslogConfiguration syslogConfig = SyslogConfigManager.loadSyslogConfiguration();
        return syslogConfig.isSyslogOn();
    }

    private LogMessage[] getTenantLogsForType(String type, String logFile, String logIndex, int maxLines, int start, int end, int tenantId, String serviceName) throws LogViewerException {
        ArrayList<LogMessage> resultList = new ArrayList<LogMessage>();
        LogMessage[] allLogs = this.getHeadLogs(logIndex, this.getTenantLogMessages(logFile, maxLines, start - 1, end, tenantId, serviceName));
        for (int i = 0; i < allLogs.length; ++i) {
            LogMessage tempLog = allLogs[i];
            if (!type.equals(tempLog.getType().trim())) continue;
            resultList.add(tempLog);
        }
        if (resultList.size() > 0) {
            return resultList.toArray(new LogMessage[resultList.size()]);
        }
        return NO_LOGS_MESSAGE;
    }

    private LogMessage[] getTenantLogsForKey(String keyword, String logFile, String logIndex, int maxLines, int start, int end, int tenantId, String serviceName) throws LogViewerException {
        ArrayList<LogMessage> resultList = new ArrayList<LogMessage>();
        LogMessage[] allLogs = this.getHeadLogs(logIndex, this.getTenantLogMessages(logFile, maxLines, start - 1, end, tenantId, serviceName));
        for (int i = 0; i < allLogs.length; ++i) {
            LogMessage tempLog = allLogs[i];
            String message = tempLog.getLogMessage();
            if (message == null || message.toLowerCase().indexOf(keyword.toLowerCase()) <= -1) continue;
            resultList.add(tempLog);
        }
        if (resultList.size() > 0) {
            return resultList.toArray(new LogMessage[resultList.size()]);
        }
        return NO_LOGS_MESSAGE;
    }

    private String removeSyslogHeader(String line) {
        if (this.isValidPattern("\\d{1,2}\\s\\d{2}:\\d{2}:\\d{2}\\s\\d{1,6}\\.\\d{1,6}\\.\\d{1,6}\\.\\d{1,6}", line)) {
            String[] lines = line.split("\\d{1,2}\\s\\d{2}:\\d{2}:\\d{2}\\s\\d{1,6}\\.\\d{1,6}\\.\\d{1,6}\\.\\d{1,6}");
            if (lines.length > 1) {
                return lines[1];
            }
            return line;
        }
        return line;
    }

    private String cleanLogHeader(String line, int tenantId) {
        String tenantPattern = "";
        tenantPattern = this.isSuperTenantUser() ? SyslogConfigManager.getSyslogPattern().replace("%T", String.valueOf(tenantId)) : SyslogConfigManager.getSyslogPattern().replace("%T", String.valueOf(CarbonContext.getCurrentContext().getTenantId()));
        return line.replace(tenantPattern.trim(), "");
    }

    private LogMessage getLogMessageForType(String log) {
        LogMessage logMessage = null;
        if (this.isTraceHeader(log)) {
            logMessage = new LogMessage(log, "TRACE");
        } else if (this.isDebugHeader(log)) {
            logMessage = new LogMessage(log, "DEBUG");
        } else if (this.isInfoHeader(log)) {
            logMessage = new LogMessage(log, "INFO");
        } else if (this.isWarnHeader(log)) {
            logMessage = new LogMessage(log, "WARN");
        } else if (this.isErrorHeader(log)) {
            logMessage = new LogMessage(log, "ERROR");
        } else if (this.isFatalHeader(log)) {
            logMessage = new LogMessage(log, "FATAL");
        }
        return logMessage;
    }

    private LogMessage[] getTenantLogMessages(String logFile, int maxLogs, int start, int end, int tenantId, String serviceName) throws LogViewerException {
        boolean isSyslogFile;
        InputStream logStream;
        ArrayList<LogMessage> logsList = new ArrayList<LogMessage>();
        String errorLine = "";
        if (end > maxLogs) {
            end = maxLogs;
        }
        try {
            logStream = this.getInputStream(logFile, tenantId, serviceName);
        }
        catch (Exception e) {
            throw new LogViewerException("Cannot find the specified file location to the log file", e);
        }
        BufferedReader dataInput = new BufferedReader(new InputStreamReader(logStream));
        int index = 1;
        try {
            isSyslogFile = this.isSyslogOn();
        }
        catch (Exception e1) {
            throw new LogViewerException("Cannot validate syslog appender", e1);
        }
        try {
            LogMessage logMessage;
            String line;
            while ((line = dataInput.readLine()) != null) {
                if (isSyslogFile) {
                    line = this.removeSyslogHeader(line);
                }
                line = this.cleanLogHeader(line, tenantId);
                if (index <= end && index > start) {
                    logMessage = null;
                    if (this.isErrorHeader(line)) {
                        if (!errorLine.equals("")) {
                            logMessage = this.getLogMessageForType(errorLine = (String)errorLine.subSequence(0, errorLine.length() - 1));
                            if (logMessage != null) {
                                logsList.add(logMessage);
                            }
                            errorLine = "";
                        }
                        errorLine = line;
                    } else if (this.isFatalHeader(line)) {
                        if (!errorLine.equals("")) {
                            logMessage = this.getLogMessageForType(errorLine = (String)errorLine.subSequence(0, errorLine.length() - 1));
                            if (logMessage != null) {
                                logsList.add(logMessage);
                            }
                            errorLine = "";
                        }
                        errorLine = line;
                    } else if (this.isTraceHeader(line)) {
                        if (!errorLine.equals("")) {
                            logMessage = this.getLogMessageForType(errorLine = (String)errorLine.subSequence(0, errorLine.length() - 1));
                            if (logMessage != null) {
                                logsList.add(logMessage);
                            }
                            errorLine = "";
                        }
                        errorLine = line;
                    } else if (this.isInfoHeader(line)) {
                        if (!errorLine.equals("")) {
                            logMessage = this.getLogMessageForType(errorLine = (String)errorLine.subSequence(0, errorLine.length() - 1));
                            if (logMessage != null) {
                                logsList.add(logMessage);
                            }
                            errorLine = "";
                        }
                        errorLine = line;
                    } else if (this.isWarnHeader(line)) {
                        if (!errorLine.equals("")) {
                            logMessage = this.getLogMessageForType(errorLine = (String)errorLine.subSequence(0, errorLine.length() - 1));
                            if (logMessage != null) {
                                logsList.add(logMessage);
                            }
                            errorLine = "";
                        }
                        errorLine = line;
                    } else if (this.isDebugHeader(line)) {
                        if (!errorLine.equals("")) {
                            logMessage = this.getLogMessageForType(errorLine = (String)errorLine.subSequence(0, errorLine.length() - 1));
                            if (logMessage != null) {
                                logsList.add(logMessage);
                            }
                            errorLine = "";
                        }
                        errorLine = line;
                    } else if (!this.isLogHeader(line)) {
                        errorLine = errorLine + line + "\n";
                    } else if (this.isLogHeader(line)) {
                        if (!errorLine.equals("")) {
                            logMessage = this.getLogMessageForType(errorLine = (String)errorLine.subSequence(0, errorLine.length() - 1));
                            if (logMessage != null) {
                                logsList.add(logMessage);
                            }
                            errorLine = "";
                        }
                        if ((logMessage = this.getLogMessageForType(line)) != null) {
                            logsList.add(logMessage);
                        }
                    } else {
                        log.warn((Object)("The log message  " + line + " is ignored."));
                    }
                }
                ++index;
            }
            if (!errorLine.equals("")) {
                logMessage = this.getLogMessageForType(errorLine);
                if (logMessage != null) {
                    logsList.add(logMessage);
                } else {
                    log.warn((Object)("The log message " + errorLine + " is ignored."));
                }
            }
            dataInput.close();
        }
        catch (IOException e) {
            throw new LogViewerException("Cannot read the log file", e);
        }
        return logsList.toArray(new LogMessage[logsList.size()]);
    }

    private LogMessage[] getBottomUpLogMessages(String logFile, int maxLogs, int start, int end, int tenantId, String serviceName) throws LogViewerException {
        start = maxLogs - start + 1;
        end = start - 200;
        if (start > maxLogs) {
            start = maxLogs;
        }
        if (end > maxLogs) {
            end = maxLogs;
        }
        if (end < 0) {
            end = 0;
        }
        LogMessage[] logs = this.getTenantLogMessages(logFile, maxLogs, end, start, tenantId, serviceName);
        int maxLen = logs.length;
        LogMessage[] botomupLogs = new LogMessage[maxLen];
        int i = 0;
        int j = maxLen - 1;
        while (i < maxLen) {
            botomupLogs[i] = logs[j];
            ++i;
            --j;
        }
        return botomupLogs;
    }

    private InputStream getLocalInputStream(String logFile) throws FileNotFoundException {
        String fileName = CarbonUtils.getCarbonLogsPath() + "/" + logFile;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileName));
        return is;
    }

    private InputStream getInputStream(String logFile, int tenantId, String serviceName) throws LogViewerException {
        try {
            InputStream inputStream;
            if (this.isSyslogOn()) {
                inputStream = this.getLogDataStream(logFile, tenantId, serviceName);
            } else if (this.isSuperTenantUser()) {
                inputStream = this.getLocalInputStream(logFile);
            } else {
                throw new LogViewerException("Syslog Properties are not properly configured");
            }
            return inputStream;
        }
        catch (Exception e) {
            throw new LogViewerException("Error getting the file inputstream", e);
        }
    }

    private LogInfo[] getLocalLogInfo() {
        File[] listOfFiles;
        String folderPath = CarbonUtils.getCarbonLogsPath();
        LogInfo log = null;
        ArrayList<LogInfo> logs = new ArrayList<LogInfo>();
        File folder = new File(folderPath);
        WildcardFileFilter fileFilter = new WildcardFileFilter("wso2carbon.log*");
        for (File file : listOfFiles = folder.listFiles((FileFilter)fileFilter)) {
            String filename = file.getName();
            String[] fileDates = filename.split("log.");
            String filePath = CarbonUtils.getCarbonLogsPath() + "/" + filename;
            File logfile = new File(filePath);
            log = fileDates.length == 2 ? new LogInfo(filename, fileDates[1], this.getFileSize(logfile)) : new LogInfo(filename, "0_Current Log", this.getFileSize(logfile));
            if (log == null) continue;
            logs.add(log);
        }
        return this.getSortedLogInfo(logs.toArray(new LogInfo[logs.size()]));
    }

    private String getFileSize(File file) {
        int unit;
        long bytes = file.length();
        if (bytes < (long)(unit = 1024)) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), Character.valueOf(pre));
    }

    private LogInfo[] getLogInfo(int tenantId, String serviceName) throws LogViewerException {
        InputStream logStream;
        try {
            logStream = this.getLogDataStream("", tenantId, serviceName);
        }
        catch (HttpException e) {
            throw new LogViewerException("Cannot establish the connection to the syslog server", e);
        }
        catch (IOException e) {
            throw new LogViewerException("Cannot find the specified file location to the log file", e);
        }
        catch (Exception e) {
            throw new LogViewerException("Cannot find the specified file location to the log file", e);
        }
        BufferedReader dataInput = new BufferedReader(new InputStreamReader(logStream));
        ArrayList<LogInfo> logs = new ArrayList<LogInfo>();
        Pattern pattern = Pattern.compile("[a-zA-Z]*\\.log[\\s\\S.*]*");
        try {
            String line;
            while ((line = dataInput.readLine()) != null) {
                String[] logFileName;
                Matcher matcher;
                String[] fileNameLinks = line.split("a href=");
                String[] fileDates = line.split("<td align=\"right\">");
                String[] dates = null;
                String[] sizes = null;
                if (fileDates.length == 3) {
                    dates = fileDates[1].split("</td>");
                    sizes = fileDates[2].split("</td>");
                }
                if (fileNameLinks.length != 2 || !(matcher = pattern.matcher((logFileName = fileNameLinks[1].split(">"))[0])).find() || logFileName == null || dates == null || sizes == null) continue;
                String logName = logFileName[0].replace("\"", "");
                logName = logName.replaceAll("%20", " ");
                LogInfo log = new LogInfo(logName, dates[0], sizes[0]);
                logs.add(log);
            }
            dataInput.close();
        }
        catch (IOException e) {
            throw new LogViewerException("Cannot find the specified file location to the log file", e);
        }
        return this.getSortedLogInfo(logs.toArray(new LogInfo[logs.size()]));
    }

    private LogMessage[] searchTenantLog(String type, String keyword, String logFile, String logIndex, int maxLines, int start, int end, int tenantId, String serviceName) throws LogViewerException {
        if ("ALL".equalsIgnoreCase(type)) {
            return this.getTenantLogsForKey(keyword, logFile, logIndex, maxLines, start, end, tenantId, serviceName);
        }
        LogMessage[] filerByType = this.getTenantLogsForType(type, logFile, logIndex, maxLines, start, end, tenantId, serviceName);
        ArrayList<LogMessage> resultList = new ArrayList<LogMessage>();
        for (int i = 0; i < filerByType.length; ++i) {
            String logMessage = filerByType[i].getLogMessage();
            if (logMessage == null || logMessage.toLowerCase().indexOf(keyword.toLowerCase()) <= -1) continue;
            resultList.add(filerByType[i]);
        }
        if (resultList.isEmpty()) {
            return NO_LOGS_MESSAGE;
        }
        return resultList.toArray(new LogMessage[resultList.size()]);
    }

    private LogMessage[] searchBottomUpLogsTenantLog(String type, String keyword, String logFile, int maxLines, int start, int end, int tenantId, String serviceName) throws LogViewerException {
        if ("ALL".equalsIgnoreCase(type)) {
            return this.getBottomUpLogsForKey(keyword, logFile, maxLines, start, end, tenantId, serviceName);
        }
        LogMessage[] filerByType = this.getBottomUpLogsForType(type, logFile, maxLines, start, end, tenantId, serviceName);
        ArrayList<LogMessage> resultList = new ArrayList<LogMessage>();
        for (int i = 0; i < filerByType.length; ++i) {
            String logMessage = filerByType[i].getLogMessage();
            if (logMessage == null || logMessage.toLowerCase().indexOf(keyword.toLowerCase()) <= -1) continue;
            resultList.add(filerByType[i]);
        }
        if (resultList.isEmpty()) {
            return NO_LOGS_MESSAGE;
        }
        return resultList.toArray(new LogMessage[resultList.size()]);
    }

    private boolean isValidPattern(String expression, String str) {
        String inputStr = str;
        Pattern pattern = Pattern.compile(expression);
        Matcher matcher = pattern.matcher(inputStr);
        return matcher.find();
    }

    private boolean isErrorHeader(String line) {
        return this.isValidPattern("\\[\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2},\\d{2,6}][\\s\\S.*]*\\s{0,2}ERROR", line);
    }

    private boolean isInfoHeader(String line) {
        return this.isValidPattern("\\[\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2},\\d{2,6}][\\s\\S.*]*\\s{0,2}INFO", line);
    }

    private boolean isDebugHeader(String line) {
        return this.isValidPattern("\\[\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2},\\d{2,6}][\\s\\S.*]*\\s{0,2}DEBUG", line);
    }

    private boolean isWarnHeader(String line) {
        return this.isValidPattern("\\[\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2},\\d{2,6}][\\s\\S.*]*\\s{0,2}WARN", line);
    }

    private boolean isTraceHeader(String line) {
        return this.isValidPattern("\\[\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2},\\d{2,6}][\\s\\S.*]*\\s{0,2}TRACE", line);
    }

    private boolean isFatalHeader(String line) {
        return this.isValidPattern("\\[\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2},\\d{2,6}][\\s\\S.*]*\\s{0,2}FATAL", line);
    }

    private boolean isLogHeader(String line) {
        return this.isValidPattern("\\[\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2},\\d{2,6}]", line);
    }

    public int getTenantIdForDomain(String tenantDomain) throws LogViewerException {
        int tenantId;
        TenantManager tenantManager = LoggingServiceComponent.getTenantManager();
        if (tenantDomain == null || tenantDomain.equals("")) {
            tenantId = -1234;
        } else {
            try {
                tenantId = tenantManager.getTenantId(tenantDomain);
            }
            catch (UserStoreException e) {
                throw new LogViewerException("Cannot find tenant id for the given tenant domain.");
            }
        }
        return tenantId;
    }
}

