/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import me.prettyprint.cassandra.model.IndexedSlicesQuery;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.OrderedRows;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.query.QueryResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.logging.internal.LoggingServiceComponent;
import org.wso2.carbon.logging.service.LogViewerException;
import org.wso2.carbon.logging.service.data.CassandraConfig;
import org.wso2.carbon.logging.service.data.LogEvent;
import org.wso2.carbon.logging.util.LoggingUtil;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class CassandraLogReader {
    private static Log log = LogFactory.getLog(CassandraLogReader.class);
    private static final StringSerializer stringSerializer = StringSerializer.get();

    private int getCurrentTenantId(String tenantDomain) throws LogViewerException {
        int tenantId = this.getTenantIdForDomain(tenantDomain);
        if (this.isSuperTenantUser()) {
            return tenantId;
        }
        return CarbonContext.getCurrentContext().getTenantId();
    }

    private String getCurrentServerName(String serverName) {
        if (this.isManager() && serverName != null && serverName.length() > 0) {
            return serverName;
        }
        return ServerConfiguration.getInstance().getFirstProperty("Name");
    }

    private boolean isManager() {
        return "WSO2 Stratos Manager".equals(ServerConfiguration.getInstance().getFirstProperty("Name"));
    }

    private Keyspace getCurrentCassandraKeyspace() throws LogViewerException {
        CassandraConfig config;
        try {
            config = LoggingUtil.getCassandraConfig();
        }
        catch (Exception e) {
            throw new LogViewerException("Cannot read the log config file", e);
        }
        String connectionURL = config.getUrl();
        String userName = config.getUser();
        String password = config.getPassword();
        String keyspaceName = config.getKeyspace();
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("username", userName);
        credentials.put("password", password);
        Cluster cluster = HFactory.createCluster((String)"TestCluster", (CassandraHostConfigurator)new CassandraHostConfigurator(connectionURL), credentials);
        return HFactory.createKeyspace((String)keyspaceName, (Cluster)cluster);
    }

    private boolean isSuperTenantUser() {
        CarbonContext carbonContext = CarbonContext.getCurrentContext();
        int tenantId = carbonContext.getTenantId();
        return tenantId == -1234;
    }

    private byte[] longToByteArray(long data) {
        return new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    private String convertByteToString(byte[] array) {
        return new String(array);
    }

    private String convertLongToString(Long longval) {
        Date date = new Date(longval);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss,SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String formattedDate = formatter.format(date);
        return formattedDate;
    }

    private long convertByteToLong(byte[] array, int offset) {
        return (long)(array[offset] & 0xFF) << 56 | (long)(array[offset + 1] & 0xFF) << 48 | (long)(array[offset + 2] & 0xFF) << 40 | (long)(array[offset + 3] & 0xFF) << 32 | (long)(array[offset + 4] & 0xFF) << 24 | (long)(array[offset + 5] & 0xFF) << 16 | (long)(array[offset + 6] & 0xFF) << 8 | (long)(array[offset + 7] & 0xFF);
    }

    private List<LogEvent> getLoggingResultList(IndexedSlicesQuery<String, String, byte[]> indexedSlicesQuery) {
        ArrayList<LogEvent> resultList = new ArrayList<LogEvent>();
        QueryResult result = indexedSlicesQuery.execute();
        for (Row row : ((OrderedRows)result.get()).getList()) {
            LogEvent event = new LogEvent();
            event.setKey((String)row.getKey());
            for (HColumn hc : row.getColumnSlice().getColumns()) {
                if (((String)hc.getName()).equals("tenantID")) {
                    event.setTenantId(this.convertByteToString((byte[])hc.getValue()));
                    continue;
                }
                if (((String)hc.getName()).equals("serverName")) {
                    event.setServerName(this.convertByteToString((byte[])hc.getValue()));
                    continue;
                }
                if (((String)hc.getName()).equals("appName")) {
                    event.setAppName(this.convertByteToString((byte[])hc.getValue()));
                    continue;
                }
                if (((String)hc.getName()).equals("logTime")) {
                    event.setLogTime(this.convertLongToString(this.convertByteToLong((byte[])hc.getValue(), 0)));
                    continue;
                }
                if (((String)hc.getName()).equals("logger")) {
                    event.setLogger(this.convertByteToString((byte[])hc.getValue()));
                    continue;
                }
                if (((String)hc.getName()).equals("priority")) {
                    event.setPriority(this.convertByteToString((byte[])hc.getValue()));
                    continue;
                }
                if (((String)hc.getName()).equals("message")) {
                    event.setMessage(this.convertByteToString((byte[])hc.getValue()));
                    continue;
                }
                if (((String)hc.getName()).equals("ip")) {
                    event.setIp(this.convertByteToString((byte[])hc.getValue()));
                    continue;
                }
                if (((String)hc.getName()).equals("stacktrace")) {
                    event.setStacktrace(this.convertByteToString((byte[])hc.getValue()));
                    continue;
                }
                if (!((String)hc.getName()).equals("instance")) continue;
                event.setIp(this.convertByteToString((byte[])hc.getValue()));
            }
            resultList.add(event);
        }
        return resultList;
    }

    public LogEvent[] getSystemLogs(String start, String end, String logger, String priority, String keyword, String serviceName, String tenantDomain, int logIndex) throws LogViewerException {
        CassandraConfig config;
        int tenantId = this.getCurrentTenantId(tenantDomain);
        serviceName = this.getCurrentServerName(serviceName);
        Keyspace currKeyspace = this.getCurrentCassandraKeyspace();
        try {
            config = LoggingUtil.getCassandraConfig();
        }
        catch (Exception e) {
            throw new LogViewerException("Cannot load cassandra configuration", e);
        }
        String colFamily = config.getColFamily();
        IndexedSlicesQuery indexedSlicesQuery = HFactory.createIndexedSlicesQuery((Keyspace)currKeyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)BytesArraySerializer.get());
        indexedSlicesQuery.setColumnNames((Object[])new String[]{"tenantID", "serverName", "appName", "logTime", "logger", "priority", "message", "ip", "stacktrace"});
        indexedSlicesQuery.addEqualsExpression((Object)"tenantID", (Object)String.valueOf(tenantId).getBytes());
        indexedSlicesQuery.addEqualsExpression((Object)"serverName", (Object)serviceName.getBytes());
        if (!logger.equals("")) {
            indexedSlicesQuery.addEqualsExpression((Object)"logger", (Object)logger.getBytes());
        }
        if (!priority.equals("ALL")) {
            indexedSlicesQuery.addEqualsExpression((Object)"priority", (Object)priority.getBytes());
        }
        if (start.equals("now") || start.equals("")) {
            Calendar newTime = Calendar.getInstance();
            Long mills = new Long(newTime.getTimeInMillis() - 1800000L);
            newTime.setTimeInMillis(mills);
            indexedSlicesQuery.addGteExpression((Object)"logTime", (Object)this.longToByteArray(newTime.getTime().getTime()));
        } else {
            Date startDate = this.getDateForCurrFormat(start);
            Date endDate = this.getDateForCurrFormat(end);
            indexedSlicesQuery.addLteExpression((Object)"logTime", (Object)this.longToByteArray(endDate.getTime()));
            indexedSlicesQuery.addGtExpression((Object)"logTime", (Object)this.longToByteArray(startDate.getTime()));
        }
        indexedSlicesQuery.setColumnFamily(colFamily);
        indexedSlicesQuery.setStartKey((Object)"");
        indexedSlicesQuery.setRowCount(logIndex);
        List<LogEvent> resultList = this.getLoggingResultList((IndexedSlicesQuery<String, String, byte[]>)indexedSlicesQuery);
        this.getSortedLogInfo(resultList.toArray(new LogEvent[resultList.size()]));
        return this.getSortedLogInfo(resultList.toArray(new LogEvent[resultList.size()]));
    }

    public String[] getTenantApplicationNames() throws LogViewerException {
        CassandraConfig config;
        int tenantId = this.getCurrentTenantId("");
        String serviceName = this.getCurrentServerName("");
        Keyspace currKeyspace = this.getCurrentCassandraKeyspace();
        try {
            config = LoggingUtil.getCassandraConfig();
        }
        catch (Exception e) {
            throw new LogViewerException("Cannot load cassandra configuration", e);
        }
        String colFamily = config.getColFamily();
        IndexedSlicesQuery indexedSlicesQuery = HFactory.createIndexedSlicesQuery((Keyspace)currKeyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)BytesArraySerializer.get());
        indexedSlicesQuery.setColumnNames((Object[])new String[]{"appName"});
        indexedSlicesQuery.addEqualsExpression((Object)"tenantID", (Object)String.valueOf(tenantId).getBytes());
        indexedSlicesQuery.addEqualsExpression((Object)"serverName", (Object)serviceName.getBytes());
        indexedSlicesQuery.setColumnFamily(colFamily);
        indexedSlicesQuery.setStartKey((Object)"");
        QueryResult result = indexedSlicesQuery.execute();
        ArrayList<String> appList = new ArrayList<String>();
        for (Row row : ((OrderedRows)result.get()).getList()) {
            for (HColumn hc : row.getColumnSlice().getColumns()) {
                if (!((String)hc.getName()).equals("appName") || appList.contains(this.convertByteToString((byte[])hc.getValue()))) continue;
                appList.add(this.convertByteToString((byte[])hc.getValue()));
            }
        }
        return appList.toArray(new String[appList.size()]);
    }

    public Date getDateForCurrFormat(String dateString) throws LogViewerException {
        Date date;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss,SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateString = dateString.length() == 16 ? dateString + ":00,000" : dateString;
        dateString = dateString.length() == 19 ? dateString + ",000" : dateString;
        try {
            date = formatter.parse(dateString);
        }
        catch (ParseException e) {
            log.error((Object)"Illegal Date Format", (Throwable)e);
            throw new LogViewerException("Illegal Date Format", e);
        }
        return date;
    }

    public LogEvent[] getApplicationLogs(String appName, String start, String end, String logger, String priority, String keyword, int logIndex) throws LogViewerException {
        CassandraConfig config;
        int tenantId = this.getCurrentTenantId("");
        String serviceName = this.getCurrentServerName("");
        Keyspace currKeyspace = this.getCurrentCassandraKeyspace();
        try {
            config = LoggingUtil.getCassandraConfig();
        }
        catch (Exception e) {
            throw new LogViewerException("Cannot load cassandra configuration", e);
        }
        String colFamily = config.getColFamily();
        IndexedSlicesQuery indexedSlicesQuery = HFactory.createIndexedSlicesQuery((Keyspace)currKeyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)BytesArraySerializer.get());
        indexedSlicesQuery.setColumnNames((Object[])new String[]{"tenantID", "serverName", "appName", "logTime", "logger", "priority", "message", "ip", "stacktrace"});
        indexedSlicesQuery.addEqualsExpression((Object)"tenantID", (Object)String.valueOf(tenantId).getBytes());
        indexedSlicesQuery.addEqualsExpression((Object)"serverName", (Object)serviceName.getBytes());
        indexedSlicesQuery.addEqualsExpression((Object)"appName", (Object)appName.getBytes());
        if (!logger.equals("")) {
            indexedSlicesQuery.addEqualsExpression((Object)"logger", (Object)logger.getBytes());
        }
        if (!priority.equals("ALL")) {
            indexedSlicesQuery.addEqualsExpression((Object)"priority", (Object)priority.getBytes());
        }
        if (!start.equals("now") && !start.equals("")) {
            Date startDate = this.getDateForCurrFormat(start);
            Date endDate = this.getDateForCurrFormat(end);
            indexedSlicesQuery.addLteExpression((Object)"logTime", (Object)this.longToByteArray(endDate.getTime()));
            indexedSlicesQuery.addGtExpression((Object)"logTime", (Object)this.longToByteArray(startDate.getTime()));
        }
        indexedSlicesQuery.setColumnFamily(colFamily);
        indexedSlicesQuery.setStartKey((Object)"");
        indexedSlicesQuery.setRowCount(logIndex);
        List<LogEvent> resultList = this.getLoggingResultList((IndexedSlicesQuery<String, String, byte[]>)indexedSlicesQuery);
        return this.getSortedLogInfo(resultList.toArray(new LogEvent[resultList.size()]));
    }

    private LogEvent[] getSortedLogInfo(LogEvent[] logs) {
        int maxLen = logs.length;
        final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss,SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (maxLen > 0) {
            List<LogEvent> logInfoList = Arrays.asList(logs);
            Collections.sort(logInfoList, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    LogEvent log1 = (LogEvent)o1;
                    LogEvent log2 = (LogEvent)o2;
                    Date d1 = null;
                    Date d2 = null;
                    try {
                        d1 = formatter.parse(log1.getLogTime());
                        d2 = formatter.parse(log2.getLogTime());
                    }
                    catch (ParseException e1) {
                        log.error((Object)e1.getStackTrace());
                    }
                    return -d1.compareTo(d2);
                }
            });
            return logInfoList.toArray(new LogEvent[logInfoList.size()]);
        }
        return null;
    }

    public int getTenantIdForDomain(String tenantDomain) throws LogViewerException {
        int tenantId;
        TenantManager tenantManager = LoggingServiceComponent.getTenantManager();
        if (tenantDomain == null || tenantDomain.equals("")) {
            tenantId = -1234;
        } else {
            try {
                tenantId = tenantManager.getTenantId(tenantDomain);
            }
            catch (UserStoreException e) {
                throw new LogViewerException("Cannot find tenant id for the given tenant domain.");
            }
        }
        return tenantId;
    }
}

