/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.net.SyslogAppender;
import org.wso2.carbon.logging.config.SyslogConfigManager;
import org.wso2.carbon.logging.registry.RegistryManager;
import org.wso2.carbon.logging.service.LoggingAdminException;
import org.wso2.carbon.logging.service.data.AppenderData;
import org.wso2.carbon.logging.service.data.LogData;
import org.wso2.carbon.logging.service.data.LoggerData;
import org.wso2.carbon.logging.service.data.SyslogData;
import org.wso2.carbon.logging.util.LoggingUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;

public class LoggingAdmin {
    private static final Log log = LogFactory.getLog(LoggingAdmin.class);
    private static String[] logLevels = new String[]{"OFF", "TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL"};
    private RegistryManager registryManager = new RegistryManager();

    public LogData getSystemLog() throws Exception {
        boolean isLogFileFound = Boolean.valueOf(LoggingUtil.getConfigurationProperty("log4j.file.not.found"));
        if (!isLogFileFound) {
            throw new Exception("Log4j.properties file not found, please put a log4j.properties file to the classpath");
        }
        LogData logData = new LogData();
        logData.setLogLevel(LoggingUtil.getSystemLogLevel());
        logData.setLogPattern(LoggingUtil.getSystemLogPattern());
        AppenderData[] appenderData = this.getAllAppenderData();
        if (appenderData.length > 0) {
            logData.setAppenderData(appenderData);
            logData.setSelectedAppenderData(appenderData[0]);
        }
        return logData;
    }

    public LoggerData[] getAllLoggerData(String logNameFilter, boolean beginsWith) {
        if (logNameFilter != null) {
            logNameFilter = logNameFilter.trim();
        }
        Enumeration loggers = LogManager.getCurrentLoggers();
        ArrayList<LoggerData> list = new ArrayList<LoggerData>();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (!(logNameFilter != null && beginsWith && logger.getName().startsWith(logNameFilter) || logNameFilter != null && !beginsWith && logger.getName().indexOf(logNameFilter) != -1 || logNameFilter == null) && logNameFilter.trim().length() != 0) continue;
            String parentName = logger.getParent() == null ? "-" : logger.getParent().getName();
            LoggerData loggerData = new LoggerData(logger.getName(), logger.getEffectiveLevel().toString(), logger.getAdditivity(), parentName);
            list.add(loggerData);
        }
        Collections.sort(list, new Comparator<LoggerData>(){

            @Override
            public int compare(LoggerData arg0, LoggerData arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        Logger rootLogger = LogManager.getRootLogger();
        if (logNameFilter != null && beginsWith && rootLogger.getName().startsWith(logNameFilter) || logNameFilter != null && !beginsWith && rootLogger.getName().indexOf(logNameFilter) != -1 || logNameFilter == null || logNameFilter.trim().length() == 0) {
            LoggerData loggerData = new LoggerData(rootLogger.getName(), rootLogger.getEffectiveLevel().toString(), rootLogger.getAdditivity(), "-");
            list.add(0, loggerData);
        }
        return list.toArray(new LoggerData[list.size()]);
    }

    public AppenderData getAppenderData(String appenderName) {
        Appender targetAppender;
        block1: {
            Logger logger;
            Logger rootLogger = Logger.getRootLogger();
            targetAppender = appenderName == null || appenderName.length() == 0 ? this.getTheFirstAppenderInLogger(rootLogger) : this.getAppenderInLoggerWithName(rootLogger, appenderName);
            if (targetAppender != null) break block1;
            Enumeration loggers = LogManager.getCurrentLoggers();
            while (loggers.hasMoreElements() && (targetAppender = this.getAppenderInLoggerWithName(logger = (Logger)loggers.nextElement(), appenderName)) == null) {
            }
        }
        return this.toAppenderData(targetAppender);
    }

    public LoggerData getLoggerData(String loggerName) {
        Logger logger = LogManager.getLogger((String)loggerName);
        String parentName = logger.getParent() == null ? "empty" : logger.getParent().getName();
        return new LoggerData(logger.getName(), logger.getEffectiveLevel().toString(), logger.getAdditivity(), parentName);
    }

    public void updateSyslogConfig(String url, String port, String realm, String userName, String password) throws LoggingAdminException {
        try {
            this.registryManager.updateSyslogConfig(url, port, realm, userName, password);
        }
        catch (Exception e) {
            throw new LoggingAdminException("Cannot update the syslog config", e);
        }
    }

    public SyslogData getSyslogData() throws LoggingAdminException {
        try {
            return this.registryManager.getSyslogData();
        }
        catch (Exception e) {
            throw new LoggingAdminException("Cannot retretrieve syslog configuration", e);
        }
    }

    public String removeSyslogPattern(String appenderPattern) {
        return appenderPattern.replace(SyslogConfigManager.getSyslogPattern().trim(), "");
    }

    private String addSyslogPattern(String appenderPattern) {
        return SyslogConfigManager.getSyslogPattern() + " " + appenderPattern;
    }

    public void updateAllAppenderData(String appenderName, String appenderPattern, String threshold, String logFileName, String sysLogHost, String facility, boolean persist) throws Exception {
        boolean isFileAppender = false;
        boolean isSysLogAppender = false;
        HashSet<Appender> appenderSet = new HashSet<Appender>();
        Logger rootLogger = Logger.getRootLogger();
        this.addAppendersToSet(rootLogger.getAllAppenders(), appenderSet);
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (logger.getLevel() == null) continue;
            this.addAppendersToSet(logger.getAllAppenders(), appenderSet);
        }
        Appender appender = null;
        Iterator iter = appenderSet.iterator();
        while (iter.hasNext() && !(appender = (Appender)iter.next()).getName().equals(appenderName)) {
        }
        if (appender != null) {
            if (appender instanceof FileAppender) {
                isFileAppender = true;
            } else if (appender instanceof SyslogAppender) {
                isSysLogAppender = true;
            }
            if (isFileAppender) {
                appenderPattern = this.addSyslogPattern(appenderPattern);
                File logFile = new File(logFileName = logFileName.replace('\\', '/'));
                if (!logFile.isAbsolute()) {
                    if (logFileName.startsWith("./")) {
                        logFileName = logFileName.substring(2);
                    }
                    logFileName = (System.getProperty("carbon.home") + "/" + logFileName).replace('\\', '/');
                    logFile = new File(logFileName);
                }
                if (!logFile.exists()) {
                    String dirName;
                    File dir;
                    int lastIndex = logFileName.lastIndexOf("/");
                    String msg = "Cannot create logfile " + logFileName + ". Please verify that the logging directory exists, log file name is " + "valid and that you have read-write access to this file.";
                    if (lastIndex != -1 && !(dir = new File(dirName = logFileName.substring(0, lastIndex))).exists() && !dir.mkdirs()) {
                        throw new Exception(msg);
                    }
                    try {
                        if (!logFile.createNewFile()) {
                            throw new Exception(msg);
                        }
                    }
                    catch (IOException e) {
                        throw new Exception(msg);
                    }
                }
                if (persist) {
                    this.registryManager.updateAppender(appender, appenderName, appenderPattern, threshold, logFileName, null, null, true, false);
                }
            } else if (isSysLogAppender) {
                if (persist) {
                    this.registryManager.updateAppender(appender, appenderName, appenderPattern, threshold, null, sysLogHost, facility, false, true);
                }
            } else if (persist) {
                this.registryManager.updateAppender(appender, appenderName, appenderPattern, threshold, null, null, null, false, false);
            }
            if (appender.getLayout() != null && appender.getLayout() instanceof PatternLayout) {
                ((PatternLayout)appender.getLayout()).setConversionPattern(appenderPattern);
            }
            if (appender instanceof FileAppender) {
                ((FileAppender)appender).setFile(logFileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("change the logfile of the appender ==> " + appender.getName() + " to " + logFileName));
                }
                ((FileAppender)appender).activateOptions();
            }
            if (appender instanceof SyslogAppender) {
                SyslogAppender syslogAppender = (SyslogAppender)appender;
                syslogAppender.setSyslogHost(sysLogHost);
                syslogAppender.setFacility(facility);
            }
            if (appender instanceof AppenderSkeleton) {
                AppenderSkeleton appenderSkeleton = (AppenderSkeleton)appender;
                appenderSkeleton.setThreshold((Priority)Level.toLevel((String)threshold));
                appenderSkeleton.activateOptions();
            }
        }
    }

    public boolean isStratosService() throws Exception {
        return LoggingUtil.isStratosService();
    }

    public void updateSystemLog(String logLevel, String logPattern, boolean persist) throws Exception {
        if (logPattern == null || logPattern.trim().length() == 0) {
            throw new Exception("Invalid Log Pattern");
        }
        if (!this.isALogLevel(logLevel)) {
            throw new Exception("Invalid Log Level");
        }
        HashSet<Appender> appenderSet = new HashSet<Appender>();
        if (persist) {
            this.registryManager.updateConfigurationProperty("wso2carbon.system.log.level", logLevel);
            this.registryManager.updateConfigurationProperty("wso2carbon.system.log.pattern", logPattern);
        }
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.setLevel(Level.toLevel((String)logLevel));
        this.addAppendersToSet(rootLogger.getAllAppenders(), appenderSet);
        Enumeration loggersEnum = LogManager.getCurrentLoggers();
        Level systemLevel = Level.toLevel((String)logLevel);
        while (loggersEnum.hasMoreElements()) {
            Logger logger = (Logger)loggersEnum.nextElement();
            this.addAppendersToSet(logger.getAllAppenders(), appenderSet);
            logger.setLevel(systemLevel);
        }
        Collection loggerCollection = this.registryManager.getLoggers();
        if (loggerCollection != null) {
            String[] loggerResourcePaths;
            for (String loggerResourcePath : loggerResourcePaths = loggerCollection.getChildren()) {
                Logger logger = LogManager.getLogger((String)loggerResourcePath.substring("/repository/components/org.wso2.carbon.logging/loggers/".length()));
                Resource loggerResource = this.registryManager.getLogger(loggerResourcePath);
                if (loggerResource == null || logger == null) continue;
                loggerResource.setProperty("log.level", logLevel);
            }
        }
        PatternLayout patternLayout = new PatternLayout(logPattern);
        for (Appender appender : appenderSet) {
            if (!(appender instanceof AppenderSkeleton)) continue;
            AppenderSkeleton appenderSkeleton = (AppenderSkeleton)appender;
            appenderSkeleton.setThreshold((Priority)systemLevel);
            appenderSkeleton.setLayout((Layout)patternLayout);
            appenderSkeleton.activateOptions();
        }
        Collection appenderCollection = this.registryManager.getAppenders();
        if (appenderCollection != null) {
            String[] appenderResourcePaths;
            for (String appenderResourcePath : appenderResourcePaths = appenderCollection.getChildren()) {
                Appender appender = LoggingUtil.getAppenderFromSet(appenderSet, appenderResourcePath.substring("/repository/components/org.wso2.carbon.logging/appenders/".length()));
                Resource appenderResource = this.registryManager.getAppender(appenderResourcePath);
                if (appenderResource == null || appender == null || !(appender instanceof AppenderSkeleton)) continue;
                appenderResource.setProperty("threshold", logLevel);
                appenderResource.setProperty("pattern", logPattern);
            }
        }
    }

    public void updateLoggerData(String loggerName, String loggerLevel, boolean additivity, boolean persist) throws Exception {
        Logger logger = LogManager.getLogger((String)loggerName);
        if (logger != null) {
            if (persist) {
                this.registryManager.updateLogger(loggerName, loggerLevel, additivity);
            }
            logger.setLevel(Level.toLevel((String)loggerLevel));
            logger.setAdditivity(additivity);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set the log level of logger ==>" + logger.getName() + " to " + logger.getLevel().toString()));
            }
        }
    }

    public void restoreDefaults() throws Exception {
        LoggingUtil.restoreDefaults();
    }

    private AppenderData[] getAllAppenderData() {
        HashSet<Appender> appenderSet = new HashSet<Appender>();
        Logger rootLogger = Logger.getRootLogger();
        Enumeration appenders = rootLogger.getAllAppenders();
        this.addAppendersToSet(appenders, appenderSet);
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            this.addAppendersToSet(logger.getAllAppenders(), appenderSet);
        }
        AppenderData[] appenderDataArray = new AppenderData[appenderSet.size()];
        int i = 0;
        Iterator iterator = appenderSet.iterator();
        while (iterator.hasNext()) {
            appenderDataArray[i] = this.toAppenderData((Appender)iterator.next());
            ++i;
        }
        Arrays.sort(appenderDataArray, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                AppenderData a = (AppenderData)arg0;
                AppenderData b = (AppenderData)arg1;
                return a.getName().compareTo(b.getName());
            }
        });
        return appenderDataArray;
    }

    private void addAppendersToSet(Enumeration appenders, Set<Appender> appenderSet) {
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            appenderSet.add(appender);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Add appender ==> " + appender.getName() + " to appender set"));
        }
    }

    private AppenderData toAppenderData(Appender targetAppender) {
        AppenderData appenderData = null;
        if (targetAppender != null) {
            AppenderSkeleton appender;
            appenderData = new AppenderData();
            appenderData.setName(targetAppender.getName());
            Layout layout = targetAppender.getLayout();
            if (layout instanceof PatternLayout) {
                appenderData.setPattern(((PatternLayout)layout).getConversionPattern());
            }
            if (targetAppender instanceof AppenderSkeleton) {
                appender = (AppenderSkeleton)targetAppender;
                Priority priority = appender.getThreshold();
                if (priority != null) {
                    appenderData.setThreshold(priority.toString());
                } else {
                    appender.setThreshold((Priority)Level.toLevel((int)10000));
                    appenderData.setThreshold("DEBUG");
                }
            }
            if (targetAppender instanceof SyslogAppender) {
                appender = (SyslogAppender)targetAppender;
                appenderData.setIsSysLogAppender(true);
                appenderData.setFacility(appender.getFacility());
                appenderData.setSysLogHost(appender.getSyslogHost());
            } else if (targetAppender instanceof FileAppender) {
                appenderData.setIsFileAppender(true);
                appenderData.setLogFile(((FileAppender)targetAppender).getFile());
            }
        }
        return appenderData;
    }

    private Appender getAppenderInLoggerWithName(Logger logger, String appenderName) {
        Enumeration appenders = logger.getAllAppenders();
        Appender targetAppender = null;
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!appender.getName().equals(appenderName)) continue;
            targetAppender = appender;
            break;
        }
        return targetAppender;
    }

    private Appender getTheFirstAppenderInLogger(Logger logger) {
        Enumeration appenders = logger.getAllAppenders();
        Appender targetAppender = null;
        if (appenders.hasMoreElements()) {
            targetAppender = (Appender)appenders.nextElement();
        }
        return targetAppender;
    }

    private boolean isALogLevel(String logLevelToTest) {
        boolean returnValue = false;
        for (String logLevel : logLevels) {
            if (!logLevel.equalsIgnoreCase(logLevelToTest)) continue;
            returnValue = true;
        }
        return returnValue;
    }
}

