/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.registry;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.net.SyslogAppender;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.logging.appender.CassandraAppender;
import org.wso2.carbon.logging.appenders.CircularBuffer;
import org.wso2.carbon.logging.appenders.MemoryAppender;
import org.wso2.carbon.logging.config.SyslogConfigManager;
import org.wso2.carbon.logging.config.SyslogConfiguration;
import org.wso2.carbon.logging.service.data.CassandraConfig;
import org.wso2.carbon.logging.service.data.SyslogData;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class RegistryManager {
    private static Log log = LogFactory.getLog(RegistryManager.class);
    private static Registry registry;

    public static void setRegistry(Registry registryParam) {
        registry = registryParam;
    }

    public String getConfigurationProperty(String propertyName) throws RegistryException {
        String resourcePath = "/repository/components/org.wso2.carbon.logging/" + propertyName;
        String value = null;
        if (registry.resourceExists(resourcePath)) {
            Resource resource = registry.get(resourcePath);
            value = resource.getProperty(propertyName);
        }
        return value;
    }

    public void updateConfigurationProperty(String propertyName, String value) throws RegistryException {
        if (propertyName == null || value == null) {
            return;
        }
        String resourcePath = "/repository/components/org.wso2.carbon.logging/" + propertyName;
        if (!registry.resourceExists(resourcePath)) {
            Resource resource = registry.newResource();
            resource.addProperty(propertyName, value);
            registry.put(resourcePath, resource);
        } else {
            Resource resource = registry.get(resourcePath);
            String existingValue = resource.getProperty(propertyName);
            if (existingValue == null || !existingValue.equals(value)) {
                resource.setProperty(propertyName, value);
                registry.put(resourcePath, resource);
            }
        }
    }

    public void addLogger(Logger logger) throws Exception {
        try {
            registry.beginTransaction();
            Resource loggerResource = registry.newResource();
            loggerResource.addProperty("name", logger.getName());
            loggerResource.addProperty("log.level", logger.getEffectiveLevel().toString());
            loggerResource.addProperty("additivity", Boolean.toString(logger.getAdditivity()));
            registry.put("/repository/components/org.wso2.carbon.logging/loggers/" + logger.getName(), loggerResource);
            registry.commitTransaction();
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            log.error((Object)"Unable to add the logger", (Throwable)e);
            throw e;
        }
    }

    public Resource getLogger(String loggerName) throws Exception {
        String loggerResourcePath = "/repository/components/org.wso2.carbon.logging/loggers/" + loggerName;
        if (registry.resourceExists(loggerResourcePath)) {
            return registry.get(loggerResourcePath);
        }
        return null;
    }

    public Collection getLoggers() throws Exception {
        if (registry.resourceExists("/repository/components/org.wso2.carbon.logging/loggers/")) {
            return (Collection)registry.get("/repository/components/org.wso2.carbon.logging/loggers/");
        }
        return null;
    }

    public void updateLogger(String loggerName, String loggerLevel, boolean aditivity) throws Exception {
        try {
            registry.beginTransaction();
            String loggerResourcePath = "/repository/components/org.wso2.carbon.logging/loggers/" + loggerName;
            if (registry.resourceExists(loggerResourcePath)) {
                Resource loggerResource = registry.get(loggerResourcePath);
                loggerResource.setProperty("log.level", loggerLevel);
                loggerResource.setProperty("additivity", Boolean.toString(aditivity));
                registry.put(loggerResourcePath, loggerResource);
            } else {
                Resource loggerResource = registry.newResource();
                loggerResource.addProperty("name", loggerName);
                loggerResource.addProperty("log.level", loggerLevel);
                loggerResource.addProperty("additivity", Boolean.toString(aditivity));
                registry.put(loggerResourcePath, loggerResource);
            }
            registry.commitTransaction();
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            log.error((Object)"Unable to update the logger", (Throwable)e);
            throw e;
        }
    }

    private String encriptSyslogPassword(String password) throws CryptoException {
        return CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(password.getBytes());
    }

    private String decriptPassword(String encriptedPassword) throws CryptoException, IOException {
        return new String(CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(encriptedPassword));
    }

    public void addCassandraConfig(CassandraConfig cassandraconfig) throws Exception {
        try {
            registry.beginTransaction();
            Resource cassandraResource = registry.newResource();
            cassandraResource.addProperty("cassandra.host.url", cassandraconfig.getUrl());
            cassandraResource.addProperty("cassandra.keyspace", cassandraconfig.getKeyspace());
            cassandraResource.addProperty("cassandra.keyspace.column.family", cassandraconfig.getColFamily());
            cassandraResource.addProperty("user.name", cassandraconfig.getUser());
            cassandraResource.addProperty("password", this.encriptSyslogPassword(cassandraconfig.getPassword()));
            registry.put("/repository/components/org.wso2.carbon.logging/loggers/syslog/SYSLOG_PROPERTIES", cassandraResource);
            registry.commitTransaction();
        }
        catch (RegistryException e) {
            registry.rollbackTransaction();
            log.error((Object)"Cannot add cassandra properties ", (Throwable)e);
        }
    }

    public void addSyslogConfig(SyslogData syslogData) throws Exception {
        try {
            registry.beginTransaction();
            Resource syslogResource = registry.newResource();
            syslogResource.addProperty("log.index.url", syslogData.getUrl());
            syslogResource.addProperty("syslog.port", syslogData.getPort());
            syslogResource.addProperty("realm", syslogData.getRealm());
            syslogResource.addProperty("user.name", syslogData.getUserName());
            syslogResource.addProperty("password", this.encriptSyslogPassword(syslogData.getPassword()));
            registry.put("/repository/components/org.wso2.carbon.logging/loggers/syslog/SYSLOG_PROPERTIES", syslogResource);
            registry.commitTransaction();
        }
        catch (RegistryException e) {
            registry.rollbackTransaction();
            log.error((Object)"Cannot add syslog properties ", (Throwable)e);
        }
    }

    public void addAppender(Appender appender) throws Exception {
        try {
            Layout layout;
            registry.beginTransaction();
            Resource appenderResource = registry.newResource();
            if (appender.requiresLayout() && (layout = appender.getLayout()) instanceof PatternLayout) {
                appenderResource.addProperty("pattern", ((PatternLayout)layout).getConversionPattern());
            }
            if (appender instanceof FileAppender) {
                FileAppender fileAppender = (FileAppender)appender;
                String fileName = fileAppender.getFile();
                File logFile = new File(fileName);
                if (!logFile.isAbsolute()) {
                    if (fileName.startsWith(".")) {
                        fileName = fileName.substring(1);
                    }
                    fileName = (System.getProperty("carbon.home") + "/" + fileName).replace('\\', '/');
                    fileAppender.setFile(fileName);
                    fileAppender.activateOptions();
                }
                appenderResource.addProperty("log.file.name", fileName);
                appenderResource.addProperty("is.file.appender", Boolean.toString(true));
            } else {
                appenderResource.addProperty("is.file.appender", Boolean.toString(false));
            }
            if (appender instanceof MemoryAppender) {
                MemoryAppender memoryAppender = (MemoryAppender)appender;
                memoryAppender.setCircularBuffer(new CircularBuffer(200));
                memoryAppender.activateOptions();
            }
            if (appender instanceof AppenderSkeleton) {
                AppenderSkeleton appenderSkeleton = (AppenderSkeleton)appender;
                if (appenderSkeleton.getThreshold() != null) {
                    appenderResource.addProperty("threshold", appenderSkeleton.getThreshold().toString());
                } else {
                    appenderResource.addProperty("threshold", "DEBUG");
                }
            }
            if (appender instanceof SyslogAppender) {
                SyslogAppender syslogAppender = (SyslogAppender)appender;
                appenderResource.addProperty("sys.log.host", syslogAppender.getSyslogHost());
                appenderResource.addProperty("facility", syslogAppender.getFacility());
                appenderResource.addProperty("is.sys.log.appender", Boolean.toString(true));
            } else {
                appenderResource.addProperty("is.sys.log.appender", Boolean.toString(false));
            }
            registry.put("/repository/components/org.wso2.carbon.logging/appenders/" + appender.getName(), appenderResource);
            registry.commitTransaction();
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            log.error((Object)"Cannot add appender", (Throwable)e);
        }
    }

    public void updateCassandraConfig(String url, String keyspace, String columnFamily, String userName, String password) throws Exception {
        block5: {
            String cassandraResourcePath = "/repository/components/org.wso2.carbon.logging/loggers/cassandra/CASSANDRA_PROPERTIES";
            try {
                if (registry.resourceExists(cassandraResourcePath)) {
                    try {
                        registry.beginTransaction();
                        Resource appenderResource = registry.get(cassandraResourcePath);
                        appenderResource.setProperty("cassandra.host.url", url);
                        appenderResource.setProperty("cassandra.keyspace", keyspace);
                        appenderResource.setProperty("cassandra.keyspace.column.family", columnFamily);
                        appenderResource.setProperty("user.name", userName);
                        appenderResource.setProperty("password", this.encriptSyslogPassword(password));
                        registry.put("/repository/components/org.wso2.carbon.logging/loggers/cassandra/CASSANDRA_PROPERTIES", appenderResource);
                        registry.commitTransaction();
                        break block5;
                    }
                    catch (RegistryException e) {
                        registry.rollbackTransaction();
                        log.error((Object)"Unable to update the appender", (Throwable)e);
                        throw e;
                    }
                }
                CassandraConfig cassandraConfig = new CassandraConfig(keyspace, userName, password, columnFamily, url);
                this.addCassandraConfig(cassandraConfig);
            }
            catch (RegistryException e) {
                log.error((Object)"Unable to update the appender", (Throwable)e);
                throw e;
            }
        }
    }

    public void updateSyslogConfig(String url, String port, String realm, String userName, String password) throws Exception {
        block5: {
            String syslogResourcePath = "/repository/components/org.wso2.carbon.logging/loggers/syslog/SYSLOG_PROPERTIES";
            try {
                if (registry.resourceExists(syslogResourcePath)) {
                    try {
                        registry.beginTransaction();
                        Resource appenderResource = registry.get(syslogResourcePath);
                        appenderResource.setProperty("log.index.url", url);
                        appenderResource.setProperty("syslog.port", port);
                        appenderResource.setProperty("realm", realm);
                        appenderResource.setProperty("user.name", userName);
                        appenderResource.setProperty("password", this.encriptSyslogPassword(password));
                        registry.put("/repository/components/org.wso2.carbon.logging/loggers/syslog/SYSLOG_PROPERTIES", appenderResource);
                        registry.commitTransaction();
                        break block5;
                    }
                    catch (RegistryException e) {
                        registry.rollbackTransaction();
                        log.error((Object)"Unable to update the appender", (Throwable)e);
                        throw e;
                    }
                }
                SyslogData syslogData = new SyslogData(url, port, realm, userName, password);
                this.addSyslogConfig(syslogData);
            }
            catch (RegistryException e) {
                log.error((Object)"Unable to update the appender", (Throwable)e);
                throw e;
            }
        }
    }

    private CassandraConfig loadCassandraFromLog4j() {
        Logger rootLogger = Logger.getRootLogger();
        CassandraAppender logger = (CassandraAppender)rootLogger.getAppender("CASSANDRA");
        if (logger != null) {
            CassandraConfig cassandraConfig = new CassandraConfig();
            cassandraConfig.setCassandraServerAvailable(true);
            cassandraConfig.setColFamily(logger.getColFamily());
            cassandraConfig.setKeyspace(logger.getKeyspace());
            cassandraConfig.setPassword(logger.getPassword());
            cassandraConfig.setUrl(logger.getUrl());
            cassandraConfig.setUser(logger.getUser());
            return cassandraConfig;
        }
        return null;
    }

    public CassandraConfig getCassandraConfigData() throws Exception {
        try {
            Resource cassandraConfigResource = this.getCassandraConfig();
            String keyspace = "";
            String colFamily = "";
            String url = "";
            String userName = "";
            String password = "";
            if (cassandraConfigResource != null) {
                url = cassandraConfigResource.getProperty("cassandra.host.url");
                keyspace = cassandraConfigResource.getProperty("cassandra.keyspace");
                colFamily = cassandraConfigResource.getProperty("cassandra.keyspace.column.family");
                userName = cassandraConfigResource.getProperty("user.name");
                password = this.decriptPassword(cassandraConfigResource.getProperty("password"));
            } else {
                CassandraConfig config = this.loadCassandraFromLog4j();
                url = config.getUrl();
                keyspace = config.getKeyspace();
                colFamily = config.getColFamily();
                userName = config.getUser();
                userName = userName == null ? "" : userName;
                password = config.getPassword();
                password = password == null ? "" : password;
            }
            return new CassandraConfig(keyspace, userName, password, colFamily, url);
        }
        catch (Exception e) {
            log.error((Object)"Unable get SyslogData ", (Throwable)e);
            throw e;
        }
    }

    public SyslogData getSyslogData() throws Exception {
        try {
            Resource syslogConfigResource = this.getSyslogConfig();
            String url = "";
            String port = "";
            String realm = "";
            String userName = "";
            String password = "";
            if (syslogConfigResource != null) {
                url = syslogConfigResource.getProperty("log.index.url");
                port = syslogConfigResource.getProperty("syslog.port");
                realm = syslogConfigResource.getProperty("realm");
                userName = syslogConfigResource.getProperty("user.name");
                password = this.decriptPassword(syslogConfigResource.getProperty("password"));
            } else {
                SyslogConfiguration config = SyslogConfigManager.loadSyslogConfiguration();
                url = config.getSyslogHostURL();
                port = config.getPort();
                realm = config.getRealm();
                userName = config.getUserName();
                password = config.getPassword();
            }
            return new SyslogData(url, port, realm, userName, password);
        }
        catch (Exception e) {
            log.error((Object)"Unable get SyslogData ", (Throwable)e);
            throw e;
        }
    }

    public Resource getSyslogConfig() throws Exception {
        String syslogResourcePath = "/repository/components/org.wso2.carbon.logging/loggers/syslog/SYSLOG_PROPERTIES";
        if (registry.resourceExists(syslogResourcePath)) {
            return registry.get(syslogResourcePath);
        }
        return null;
    }

    public Resource getCassandraConfig() throws Exception {
        String cassandraResourcePath = "/repository/components/org.wso2.carbon.logging/loggers/cassandra/CASSANDRA_PROPERTIES";
        if (registry.resourceExists(cassandraResourcePath)) {
            return registry.get(cassandraResourcePath);
        }
        return null;
    }

    public void updateAppender(Appender appender, String appenderName, String appenderPattern, String threshold, String logFileName, String sysLogHost, String facility, boolean isFileAppender, boolean isSysLogAppender) throws Exception {
        String appenderResourcePath = "/repository/components/org.wso2.carbon.logging/appenders/" + appenderName;
        if (registry.resourceExists(appenderResourcePath)) {
            try {
                registry.beginTransaction();
                Resource appenderResource = registry.get(appenderResourcePath);
                appenderResource.setProperty("pattern", appenderPattern);
                if (isFileAppender) {
                    appenderResource.setProperty("log.file.name", logFileName);
                    appenderResource.setProperty("is.file.appender", Boolean.toString(true));
                }
                if (isSysLogAppender) {
                    appenderResource.setProperty("sys.log.host", sysLogHost);
                    appenderResource.setProperty("facility", facility);
                    appenderResource.setProperty("is.sys.log.appender", Boolean.toString(true));
                }
                appenderResource.setProperty("threshold", threshold);
                registry.put("/repository/components/org.wso2.carbon.logging/appenders/" + appenderName, appenderResource);
                registry.commitTransaction();
            }
            catch (Exception e) {
                registry.rollbackTransaction();
                log.error((Object)"Unable to update the appender", (Throwable)e);
                throw e;
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("appender " + appenderName + " is not available, therefore adding to registry"));
            }
            this.addAppender(appender);
            this.updateAppender(appender, appenderName, appenderPattern, threshold, logFileName, sysLogHost, facility, isFileAppender, isSysLogAppender);
        }
    }

    public Resource getAppender(String appenderName) throws Exception {
        String appenderResourcePath = "/repository/components/org.wso2.carbon.logging/appenders/" + appenderName;
        if (registry.resourceExists(appenderResourcePath)) {
            return registry.get(appenderResourcePath);
        }
        return null;
    }

    public Collection getAppenders() throws Exception {
        if (registry.resourceExists("/repository/components/org.wso2.carbon.logging/appenders/")) {
            return (Collection)registry.get("/repository/components/org.wso2.carbon.logging/appenders/");
        }
        return null;
    }

    public boolean isSysLogAppender() throws RegistryException {
        boolean isSyslogAppender = false;
        String appenderResourcePath = "/repository/components/org.wso2.carbon.logging/appenders/CARBON_SYS_LOG";
        if (registry.resourceExists(appenderResourcePath)) {
            Resource appenderResource = registry.get(appenderResourcePath);
            isSyslogAppender = Boolean.parseBoolean(appenderResource.getProperty("is.sys.log.appender"));
        }
        return isSyslogAppender;
    }

    public void removeAllRegistryEntries() throws Exception {
        try {
            registry.beginTransaction();
            if (registry.resourceExists("/repository/components/org.wso2.carbon.logging/loggers/")) {
                registry.delete("/repository/components/org.wso2.carbon.logging/loggers/");
            }
            if (registry.resourceExists("/repository/components/org.wso2.carbon.logging/appenders/")) {
                registry.delete("/repository/components/org.wso2.carbon.logging/appenders/");
            }
            if (registry.resourceExists("/repository/components/org.wso2.carbon.logging/wso2carbon.system.log.pattern")) {
                registry.delete("/repository/components/org.wso2.carbon.logging/wso2carbon.system.log.pattern");
            }
            if (registry.resourceExists("/repository/components/org.wso2.carbon.logging/wso2carbon.system.log.level")) {
                registry.delete("/repository/components/org.wso2.carbon.logging/wso2carbon.system.log.level");
            }
            registry.commitTransaction();
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            log.error((Object)"Unable to remove all the loggers and appenders", (Throwable)e);
            throw e;
        }
    }
}

