/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.logging.config.SyslogConfiguration;
import org.wso2.carbon.logging.service.data.SyslogData;
import org.wso2.carbon.utils.CarbonUtils;

public class SyslogConfigManager {
    private static final Log log = LogFactory.getLog(SyslogConfigManager.class);
    private static SyslogConfigManager syslogConfig;
    private static BundleContext bundleContext;

    public static SyslogConfigManager getSyslogConfig() {
        return syslogConfig;
    }

    public static void setBundleContext(BundleContext bundleContext) {
        SyslogConfigManager.bundleContext = bundleContext;
    }

    public static void setSyslogConfig(SyslogConfigManager syslogConfig) {
        SyslogConfigManager.syslogConfig = syslogConfig;
    }

    public static Log getLog() {
        return log;
    }

    public SyslogData getSyslogData() {
        return null;
    }

    public void updateSyslogConfig(String url, String port, String realm, String userName, String password) {
    }

    public static String getSyslogPattern() {
        SyslogConfiguration config = SyslogConfigManager.loadSyslogConfiguration();
        return config.getSyslogLogPattern();
    }

    public static SyslogConfiguration loadSyslogConfiguration() {
        String syslogConfigFileName = CarbonUtils.getCarbonConfigDirPath() + "/" + "etc" + "/" + "syslog-config.xml";
        return SyslogConfigManager.loadSyslogConfiguration(syslogConfigFileName);
    }

    private InputStream getInputStream(String configFilename) throws IOException {
        InputStream inStream = null;
        File configFile = new File(configFilename);
        if (configFile.exists()) {
            inStream = new FileInputStream(configFile);
        }
        String warningMessage = "";
        if (inStream == null) {
            if (bundleContext != null) {
                URL url = bundleContext.getBundle().getResource("syslog-config.xml");
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "Bundle context could not find resource syslog-config.xml or user does not have sufficient permission to access the resource.";
                    log.error((Object)warningMessage);
                }
            } else {
                URL url = this.getClass().getClassLoader().getResource("syslog-config.xml");
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "Could not find resource syslog-config.xml or user does not have sufficient permission to access the resource.";
                    log.error((Object)warningMessage);
                }
            }
        }
        return inStream;
    }

    private static SyslogConfiguration loadDefaultConfiguration() {
        SyslogConfiguration config = new SyslogConfiguration();
        config.setSyslogOn(false);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SyslogConfiguration loadSyslogConfiguration(String configFilename) {
        SyslogConfiguration config = new SyslogConfiguration();
        InputStream inputStream = null;
        try {
            inputStream = new SyslogConfigManager().getInputStream(configFilename);
        }
        catch (IOException e1) {
            log.error((Object)("Could not close the Configuration File " + configFilename));
        }
        if (inputStream != null) {
            try {
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                OMElement documentElement = builder.getDocumentElement();
                Iterator it = documentElement.getChildElements();
                while (it.hasNext()) {
                    OMElement element = (OMElement)it.next();
                    if ("isSyslogOn".equals(element.getLocalName())) {
                        String isSyslogOn = element.getText();
                        boolean isSyslogOnRequired = false;
                        if (isSyslogOn.trim().equalsIgnoreCase("true")) {
                            isSyslogOnRequired = true;
                        }
                        config.setSyslogOn(isSyslogOnRequired);
                        continue;
                    }
                    if ("syslogHost".equals(element.getLocalName())) {
                        config.setSyslogHostURL(element.getText());
                        continue;
                    }
                    if ("port".equals(element.getLocalName())) {
                        config.setPort(element.getText());
                        continue;
                    }
                    if ("realm".equals(element.getLocalName())) {
                        config.setRealm(element.getText());
                        continue;
                    }
                    if ("userName".equals(element.getLocalName())) {
                        config.setUserName(element.getText());
                        continue;
                    }
                    if ("password".equals(element.getLocalName())) {
                        config.setPassword(element.getText());
                        continue;
                    }
                    if (!"logPattern".equals(element.getLocalName())) continue;
                    config.setSyslogLogPattern(element.getText());
                }
                SyslogConfiguration syslogConfiguration = config;
                return syslogConfiguration;
            }
            catch (Exception e) {
                String msg = "Error in loading Stratos Configurations File: " + configFilename + ". Default Settings will be used.";
                log.error((Object)msg, (Throwable)e);
                SyslogConfiguration syslogConfiguration = SyslogConfigManager.loadDefaultConfiguration();
                return syslogConfiguration;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Could not close the Configuration File " + configFilename));
                    }
                }
            }
        }
        log.error((Object)"Unable to locate the stratos configurations file. Default Settings will be used.");
        return SyslogConfigManager.loadDefaultConfiguration();
    }
}

