/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.appender;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import me.prettyprint.cassandra.serializers.DateSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.carbon.utils.logging.TenantAwareLoggingEvent;
import org.wso2.carbon.utils.logging.TenantAwarePatternLayout;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class CassandraAppender
extends AppenderSkeleton
implements Appender {
    private Cluster cluster;
    private String user;
    private String password;
    private String url;
    private String keyspace;
    private String colFamily;
    private String columnList;
    private static final StringSerializer stringSerializer = StringSerializer.get();
    private static final BlockingQueue<TenantAwareLoggingEvent> loggingEventQueue = new LinkedBlockingDeque<TenantAwareLoggingEvent>();

    public CassandraAppender() {
        this.startLogger();
    }

    protected void append(LoggingEvent event) {
        Logger logger = Logger.getLogger((String)event.getLoggerName());
        TenantAwareLoggingEvent tenantEvent = event.getThrowableInformation() != null ? new TenantAwareLoggingEvent(event.fqnOfCategoryClass, (Category)logger, event.timeStamp, (Priority)event.getLevel(), event.getMessage(), event.getThrowableInformation().getThrowable()) : new TenantAwareLoggingEvent(event.fqnOfCategoryClass, (Category)logger, event.timeStamp, (Priority)event.getLevel(), event.getMessage(), null);
        if (CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId() > -1) {
            tenantEvent.setTenantId(Integer.toString(CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId()));
        }
        loggingEventQueue.add(tenantEvent);
    }

    private Cluster getConnection() {
        if (this.cluster == null) {
            this.cluster = this.newConnection();
        }
        return this.cluster;
    }

    private Cluster newConnection() {
        if (this.cluster == null) {
            HashMap<String, String> credentials = new HashMap<String, String>();
            if (this.user != null) {
                credentials.put("username", this.user);
            }
            if (this.password != null) {
                credentials.put("password", this.password);
            }
            this.cluster = HFactory.createCluster((String)"Cluster", (CassandraHostConfigurator)new CassandraHostConfigurator(this.url), credentials);
        }
        return this.cluster;
    }

    private void insertLogEvent(TenantAwareLoggingEvent event) throws ParseException {
        Keyspace ks = HFactory.createKeyspace((String)this.keyspace, (Cluster)this.getConnection());
        Mutator mutator = HFactory.createMutator((Keyspace)ks, (Serializer)stringSerializer);
        List<String> patterns = Arrays.asList(this.columnList.split(","));
        String tenantID = null;
        String serverName = null;
        String appName = null;
        String logTime = null;
        String logger = null;
        String priority = null;
        String message = null;
        String stacktrace = null;
        String ip = null;
        String instance = null;
        Iterator<String> i = patterns.iterator();
        while (i.hasNext()) {
            String currEle = i.next().replace("%", "");
            TenantAwarePatternLayout patternLayout = new TenantAwarePatternLayout("%" + currEle);
            if (currEle.equals("T")) {
                tenantID = patternLayout.format((LoggingEvent)event);
                continue;
            }
            if (currEle.equals("S")) {
                serverName = patternLayout.format((LoggingEvent)event);
                continue;
            }
            if (currEle.equals("A")) {
                appName = patternLayout.format((LoggingEvent)event);
                continue;
            }
            if (currEle.equals("d")) {
                logTime = patternLayout.format((LoggingEvent)event);
                continue;
            }
            if (currEle.equals("c")) {
                logger = patternLayout.format((LoggingEvent)event);
                continue;
            }
            if (currEle.equals("p")) {
                priority = patternLayout.format((LoggingEvent)event);
                continue;
            }
            if (currEle.equals("m")) {
                message = patternLayout.format((LoggingEvent)event);
                continue;
            }
            if (currEle.equals("I")) {
                instance = patternLayout.format((LoggingEvent)event);
                continue;
            }
            if (currEle.equals("Stacktrace")) {
                if (event.getThrowableInformation() != null) {
                    stacktrace = this.getStacktrace(event.getThrowableInformation().getThrowable());
                    continue;
                }
                stacktrace = "";
                continue;
            }
            if (!currEle.equals("H")) continue;
            ip = patternLayout.format((LoggingEvent)event);
        }
        if (tenantID != null && serverName != null && logTime != null) {
            String key = tenantID + "_" + serverName + "_" + logTime + "_" + UUID.randomUUID().toString();
            StringSerializer stringSerializer = StringSerializer.get();
            DateSerializer dateSerializer = DateSerializer.get();
            LongSerializer longSerializer = LongSerializer.get();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss,SSS");
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            Date date = formatter.parse(logTime);
            mutator.insert((Object)key, this.colFamily, HFactory.createColumn((Object)"tenantID", (Object)tenantID, (Serializer)stringSerializer, (Serializer)stringSerializer));
            mutator.insert((Object)key, this.colFamily, HFactory.createColumn((Object)"serverName", (Object)serverName, (Serializer)stringSerializer, (Serializer)stringSerializer));
            mutator.insert((Object)key, this.colFamily, HFactory.createColumn((Object)"appName", (Object)appName, (Serializer)stringSerializer, (Serializer)stringSerializer));
            mutator.insert((Object)key, this.colFamily, HFactory.createColumn((Object)"logTime", (Object)date.getTime(), (Serializer)stringSerializer, (Serializer)longSerializer));
            mutator.insert((Object)key, this.colFamily, HFactory.createColumn((Object)"logger", (Object)logger, (Serializer)stringSerializer, (Serializer)stringSerializer));
            mutator.insert((Object)key, this.colFamily, HFactory.createColumn((Object)"priority", (Object)priority, (Serializer)stringSerializer, (Serializer)stringSerializer));
            mutator.insert((Object)key, this.colFamily, HFactory.createColumn((Object)"message", (Object)message, (Serializer)stringSerializer, (Serializer)stringSerializer));
            mutator.insert((Object)key, this.colFamily, HFactory.createColumn((Object)"stacktrace", (Object)stacktrace, (Serializer)stringSerializer, (Serializer)stringSerializer));
            mutator.insert((Object)key, this.colFamily, HFactory.createColumn((Object)"ip", (Object)ip, (Serializer)stringSerializer, (Serializer)stringSerializer));
            mutator.insert((Object)key, this.colFamily, HFactory.createColumn((Object)"instance", (Object)instance, (Serializer)stringSerializer, (Serializer)stringSerializer));
            String[] currDate = logTime.split(" ");
            String keycf = tenantID + "_" + serverName.trim() + "_" + currDate[0];
            mutator.insert((Object)keycf, "TimeCF", HFactory.createColumn((Object)"logTime", (Object)date.getTime(), (Serializer)stringSerializer, (Serializer)longSerializer));
        }
    }

    private String getStacktrace(Throwable e) {
        StackTraceElement[] stackTraceElements;
        StringBuilder stackTrace = new StringBuilder();
        for (StackTraceElement ele : stackTraceElements = e.getStackTrace()) {
            stackTrace.append(ele.toString()).append("\n");
        }
        return stackTrace.toString();
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setColumnList(String columnList) {
        this.columnList = columnList;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public void setColFamily(String colFamily) {
        this.colFamily = colFamily;
    }

    public void finalize() {
        this.close();
        super.finalize();
    }

    private void processLoggingEventQueue() {
        while (true) {
            try {
                while (true) {
                    TenantAwareLoggingEvent event;
                    if ((event = loggingEventQueue.poll(1L, TimeUnit.SECONDS)) == null) {
                        continue;
                    }
                    this.insertLogEvent(event);
                }
            }
            catch (InterruptedException e) {
                LogLog.error((String)e.toString());
                continue;
            }
            catch (ParseException e) {
                LogLog.error((String)e.toString());
                continue;
            }
            break;
        }
    }

    private void startLogger() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                CassandraAppender.this.processLoggingEventQueue();
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void close() {
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getColFamily() {
        return this.colFamily;
    }

    public String getColumnList() {
        return this.columnList;
    }
}

